/*
 * Decompiled with CFR 0.152.
 */
package com.ChaseHQ.Statistician.Config;

import com.ChaseHQ.Statistician.StatisticianPlugin;
import org.bukkit.configuration.file.FileConfiguration;

public class Config {
    private static final int _dbVersion = 9;
    private static Config instance = null;
    private FileConfiguration config;
    private String dbAddress;
    private int dbPort;
    private String dbName;
    private String dbUsername;
    private String dbPassword;
    private int dbUpdateTime;

    public static Config getConfig() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    public static String getStatisticianVersion() {
        return StatisticianPlugin.getInstance().getDescription().getVersion();
    }

    public static String getLogPrefix() {
        return "[" + StatisticianPlugin.getInstance().getDescription().getName() + "]";
    }

    public static int getDBVersion() {
        return 9;
    }

    public Config() {
        if (instance != null) {
            return;
        }
        StatisticianPlugin plugin = StatisticianPlugin.getInstance();
        this.config = plugin.getConfig();
        this.config.options().copyDefaults(true);
        this.dbAddress = this.config.getString("database_address");
        this.dbPort = this.config.getInt("database_port");
        this.dbName = this.config.getString("database_name");
        this.dbUsername = this.config.getString("database_username");
        this.dbPassword = this.config.getString("database_password");
        this.dbUpdateTime = this.config.getInt("database_update_time");
        plugin.saveConfig();
    }

    public String getDBAddress() {
        return this.dbAddress;
    }

    public int getDBPort() {
        return this.dbPort;
    }

    public int getDBUpdateTime() {
        return this.dbUpdateTime * 1000;
    }

    public String getDBName() {
        return this.dbName;
    }

    public String getDBUsername() {
        return this.dbUsername;
    }

    public String getDBPassword() {
        return this.dbPassword;
    }
}

