/*
 * Decompiled with CFR 0.152.
 */
package com.ChaseHQ.Statistician.Database.DataValues;

import com.ChaseHQ.Statistician.Database.DataValues.IStaticValue;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Wolf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DBStaticValue_Creatures implements IStaticValue
{
    NONE(0),
    PLAYER(999),
    CHICKEN(1),
    COW(2),
    CREEPER(3),
    ELECTRIFIED_CREEPER(4),
    GHAST(5),
    GIANT(6),
    MONSTER(7),
    PIG(8),
    PIG_ZOMBIE(9),
    SHEEP(10),
    SKELETON(11),
    SLIME(12),
    SPIDER(13),
    SQUID(14),
    WOLF(15),
    TAME_WOLF(16),
    SPIDER_JOCKY(17),
    BLOCK(18),
    ZOMBIE(19),
    BLAZE(20),
    CAVESPIDER(21),
    ENDERDRAGON(22),
    ENDERMAN(23),
    MAGMACUBE(24),
    MUSHROOMCOW(25),
    SILVERFISH(26),
    SNOWMAN(27),
    VILLAGER(28),
    OCELOT(29),
    IRON_GOLEM(30);

    private final Integer id;

    private DBStaticValue_Creatures(Integer id) {
        this.id = id;
    }

    @Override
    public Integer getID() {
        return this.id;
    }

    public static DBStaticValue_Creatures mapCreature(Creature creature) {
        switch (creature.getType()) {
            case PLAYER: {
                return PLAYER;
            }
            case CHICKEN: {
                return CHICKEN;
            }
            case MUSHROOM_COW: {
                return MUSHROOMCOW;
            }
            case COW: {
                return COW;
            }
            case CREEPER: {
                if (((Creeper)creature).isPowered()) {
                    return ELECTRIFIED_CREEPER;
                }
                return CREEPER;
            }
            case GHAST: {
                return GHAST;
            }
            case PIG: {
                return PIG;
            }
            case PIG_ZOMBIE: {
                return PIG_ZOMBIE;
            }
            case SHEEP: {
                return SHEEP;
            }
            case SKELETON: {
                if (((Skeleton)creature).isInsideVehicle()) {
                    return SPIDER_JOCKY;
                }
                return SKELETON;
            }
            case MAGMA_CUBE: {
                return MAGMACUBE;
            }
            case SLIME: {
                return SLIME;
            }
            case SQUID: {
                return SQUID;
            }
            case WOLF: {
                if (((Wolf)creature).isTamed()) {
                    return TAME_WOLF;
                }
                return WOLF;
            }
            case ZOMBIE: {
                return ZOMBIE;
            }
            case CAVE_SPIDER: {
                return CAVESPIDER;
            }
            case SPIDER: {
                return SPIDER;
            }
            case GIANT: {
                return GIANT;
            }
            case BLAZE: {
                return BLAZE;
            }
            case ENDER_DRAGON: {
                return ENDERDRAGON;
            }
            case ENDERMAN: {
                return ENDERMAN;
            }
            case SILVERFISH: {
                return SILVERFISH;
            }
            case SNOWMAN: {
                return SNOWMAN;
            }
            case VILLAGER: {
                return VILLAGER;
            }
            case OCELOT: {
                return OCELOT;
            }
            case IRON_GOLEM: {
                return IRON_GOLEM;
            }
        }
        if (creature instanceof Monster) {
            return MONSTER;
        }
        return NONE;
    }
}

