/*
 * Decompiled with CFR 0.152.
 */
package couk.Adamki11s.Extras.Trace;

import couk.Adamki11s.Extras.Extras.Extras;
import couk.Adamki11s.Extras.Trace.TraceMethods;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class ExtrasTrace
extends TraceMethods {
    private long startTrace = 0L;
    private long endTrace = 0L;

    @Override
    public void startTrace() {
        this.startTrace = System.nanoTime();
    }

    @Override
    public void stopTrace() {
        this.endTrace = System.nanoTime() - this.startTrace;
    }

    @Override
    public long getTrace() {
        return this.endTrace / 1000L;
    }

    @Override
    public void logTraceTime() {
        System.out.println("[Extras] Trace time : " + this.getTrace() + "ms");
    }

    @Override
    public void logTraceTime(File file, String description) {
        try {
            FileWriter fstream = new FileWriter(file, true);
            BufferedWriter bw = new BufferedWriter(fstream);
            bw.write("[Extras] Trace : " + description + " : " + this.getTrace() + "ms.");
            bw.newLine();
            bw.close();
        }
        catch (IOException ex) {
            System.out.println("[Extras] Could not print trace to file! Caused by plugin : " + Extras.pluginName);
            ex.printStackTrace();
        }
    }

    @Override
    public void broadcastTraceTime(Server s) {
        s.broadcastMessage("Trace time : " + this.getTrace());
    }

    @Override
    public void sendTraceTime(Player p) {
        p.sendMessage("Trace time : " + this.getTrace());
    }

    @Override
    public void broadcastTraceTimeCustom(Server s, String prefix) {
        s.broadcastMessage(String.valueOf(prefix) + this.getTrace());
    }

    @Override
    public void sendTraceTimeCustom(Player p, String prefix) {
        p.sendMessage(String.valueOf(prefix) + this.getTrace());
    }
}

