/*
 * Decompiled with CFR 0.152.
 */
package me.ksafin.DynamicEconomy;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import me.ksafin.DynamicEconomy.DynamicEconomy;
import me.ksafin.DynamicEconomy.Item;
import me.ksafin.DynamicEconomy.Utility;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.block.SignChangeEvent;

public class dataSigns {
    static NumberFormat f = NumberFormat.getNumberInstance(Locale.US);
    public static DecimalFormat format = (DecimalFormat)f;

    public dataSigns(SignChangeEvent event) {
        String[] lines = event.getLines();
        if (lines[0].equalsIgnoreCase("dynamicsign")) {
            String item = lines[1];
            String info = lines[2];
            FileConfiguration conf = DynamicEconomy.signsConfig;
            try {
                conf.load(DynamicEconomy.signsFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Block block = event.getBlock();
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            String signID = String.valueOf(x) + " " + y + " " + z;
            ConfigurationSection curSign = conf.createSection(signID);
            curSign.set("WORLD", (Object)block.getWorld().getName());
            if (item.equalsIgnoreCase("purchasetax") || item.equalsIgnoreCase("salestax")) {
                double tax;
                String taxName;
                if (item.equalsIgnoreCase("purchasetax")) {
                    taxName = "Purchase Tax";
                    tax = DynamicEconomy.purchasetax;
                } else {
                    taxName = "Sales Tax";
                    tax = DynamicEconomy.salestax;
                }
                event.setLine(0, "");
                event.setLine(1, String.valueOf(Utility.getColor(DynamicEconomy.signTaglineColor)) + taxName);
                event.setLine(2, String.valueOf(Utility.getColor(DynamicEconomy.signInfoColor)) + (tax *= 100.0) + "%");
                curSign.set("TYPE", (Object)item);
                try {
                    conf.save(DynamicEconomy.signsFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                String[] itemInfo = Item.getAllInfo(item);
                if ((item = Item.getTrueName(item)).equals("")) {
                    return;
                }
                String data = info.equalsIgnoreCase("price") ? "$" + format.format(DynamicEconomy.itemConfig.getDouble(String.valueOf(item) + ".price", 0.0)) : (info.equalsIgnoreCase("stock") ? String.valueOf(DynamicEconomy.itemConfig.getDouble(String.valueOf(item) + ".stock", 0.0)) : (info.equalsIgnoreCase("span") ? String.valueOf(DynamicEconomy.itemConfig.getDouble(String.valueOf(item) + ".span", 0.0)) : (info.equalsIgnoreCase("ceiling") ? "$" + String.valueOf(DynamicEconomy.itemConfig.getDouble(String.valueOf(item) + ".ceiling", 0.0)) : (info.equalsIgnoreCase("floor") ? "$" + String.valueOf(DynamicEconomy.itemConfig.getDouble(String.valueOf(item) + ".floor", 0.0)) : "0"))));
                String tagLine = String.valueOf(item) + " " + info.toUpperCase();
                if (!item.equals("")) {
                    event.setLine(0, String.valueOf(Utility.getColor(DynamicEconomy.signTaglineColor)) + item);
                    event.setLine(1, String.valueOf(Utility.getColor(DynamicEconomy.signTaglineColor)) + info.toUpperCase());
                    event.setLine(2, String.valueOf(Utility.getColor(DynamicEconomy.signInfoColor)) + data);
                    event.setLine(3, "");
                    curSign.set("ITEM", (Object)item);
                    curSign.set("TYPE", (Object)info);
                    try {
                        conf.save(DynamicEconomy.signsFile);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    event.setLine(0, "");
                    event.setLine(1, String.valueOf(Utility.getColor(DynamicEconomy.signInvalidColor)) + "INVALID");
                    event.setLine(2, String.valueOf(Utility.getColor(DynamicEconomy.signInvalidColor)) + "ARGUMENTS");
                    event.setLine(3, "");
                }
            }
        }
    }

    public static void updateTaxSigns() {
        FileConfiguration conf = DynamicEconomy.signsConfig;
        Set set = conf.getKeys(false);
        Object[] signsObj = set.toArray();
        String[] signs = new String[signsObj.length];
        int x = 0;
        while (x < signsObj.length) {
            signs[x] = signsObj[x].toString();
            ++x;
        }
        String[] stringArray = signs;
        int n = signs.length;
        int n2 = 0;
        while (n2 < n) {
            String signID = stringArray[n2];
            String request = String.valueOf(signID) + ".TYPE";
            String type = conf.getString(request);
            if (type != null) {
                String tax;
                Sign sign;
                if (type.equalsIgnoreCase("purchasetax")) {
                    sign = dataSigns.getSign(signID);
                    if (sign != null) {
                        tax = format.format(DynamicEconomy.purchasetax * 100.0);
                        sign.setLine(2, String.valueOf(Utility.getColor(DynamicEconomy.signInfoColor)) + tax + "%");
                        sign.update();
                    }
                } else if (type.equalsIgnoreCase("salestax") && (sign = dataSigns.getSign(signID)) != null) {
                    tax = format.format(DynamicEconomy.salestax * 100.0);
                    sign.setLine(2, String.valueOf(Utility.getColor(DynamicEconomy.signInfoColor)) + tax + "%");
                    sign.update();
                }
            }
            ++n2;
        }
    }

    public static Sign getSign(String coords) {
        FileConfiguration conf = DynamicEconomy.signsConfig;
        String[] splitID = coords.split(" ");
        int x = Integer.parseInt(splitID[0]);
        int y = Integer.parseInt(splitID[1]);
        int z = Integer.parseInt(splitID[2]);
        String node = String.valueOf(coords) + ".WORLD";
        String worldName = conf.getString(node, "world");
        Location loc = new Location(Bukkit.getServer().getWorld(worldName), (double)x, (double)y, (double)z);
        Block block = loc.getBlock();
        if (block.getState() instanceof Sign) {
            Sign sign = (Sign)block.getState();
            return sign;
        }
        conf.set(coords, null);
        try {
            conf.save(DynamicEconomy.signsFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Utility.writeToLog("DynamicSign no longer found at " + coords + ", entry removed from file");
        return null;
    }

    public static void removeDataSign(Block block) {
        FileConfiguration conf = DynamicEconomy.signsConfig;
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        String signID = String.valueOf(x) + " " + y + " " + z;
        if (conf.contains(signID)) {
            conf.set(signID, null);
            try {
                conf.save(DynamicEconomy.signsFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void updateColors() {
        Set signs = DynamicEconomy.signsConfig.getKeys(false);
        Iterator i = signs.iterator();
        while (i.hasNext()) {
            Sign curSign = dataSigns.getSign((String)i.next());
            if (curSign == null) continue;
            String line1 = curSign.getLine(0).substring(2);
            String line2 = curSign.getLine(1).substring(2);
            String line3 = curSign.getLine(2).substring(2);
            curSign.setLine(0, String.valueOf(Utility.getColor(DynamicEconomy.signTaglineColor)) + line1);
            curSign.setLine(1, String.valueOf(Utility.getColor(DynamicEconomy.signTaglineColor)) + line2);
            curSign.setLine(2, String.valueOf(Utility.getColor(DynamicEconomy.signInfoColor)) + line3);
            if (curSign.getLine(3).length() != 0) {
                String line4 = curSign.getLine(3).substring(2);
                curSign.setLine(3, String.valueOf(Utility.getColor(DynamicEconomy.signInfoColor)) + line4);
            }
            curSign.update();
        }
    }

    public static void checkForUpdates(String item, int changeStock, double changePrice) {
        FileConfiguration conf = DynamicEconomy.signsConfig;
        Set set = conf.getKeys(false);
        Object[] signsObj = set.toArray();
        String[] signs = new String[signsObj.length];
        int x = 0;
        while (x < signsObj.length) {
            signs[x] = signsObj[x].toString();
            ++x;
        }
        int x2 = 0;
        while (x2 < signs.length) {
            String request = String.valueOf(signs[x2]) + ".ITEM";
            String itemName = conf.getString(request);
            if (itemName == null) {
                conf.set(signs[x2], null);
                try {
                    conf.save(DynamicEconomy.signsFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Utility.writeToLog("DynamicSign no longer found at " + signs[x2] + ", entry removed from file");
            } else if (itemName.equalsIgnoreCase(item)) {
                dataSigns.updateItem(item, signs[x2], changeStock, changePrice);
            }
            ++x2;
        }
    }

    public static void checkForUpdatesNonRegular(String item, double changeSpan, double changeCeiling, double changeFloor) {
        FileConfiguration conf = DynamicEconomy.signsConfig;
        Set set = conf.getKeys(false);
        Object[] signsObj = set.toArray();
        String[] signs = new String[signsObj.length];
        int x = 0;
        while (x < signsObj.length) {
            signs[x] = signsObj[x].toString();
            ++x;
        }
        int x2 = 0;
        while (x2 < signs.length) {
            String request = String.valueOf(signs[x2]) + ".ITEM";
            String itemName = conf.getString(request);
            if (itemName == null) {
                conf.set(signs[x2], null);
                try {
                    conf.save(DynamicEconomy.signsFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Utility.writeToLog("DynamicSign no longer found at " + signs[x2] + ", entry removed from file");
            } else if (itemName.equalsIgnoreCase(item)) {
                dataSigns.updateItem(item, signs[x2], changeSpan, changeCeiling, changeFloor);
            }
            ++x2;
        }
    }

    public static void updateItem(String item, String signID, int changeStock, double changePrice) {
        FileConfiguration conf = DynamicEconomy.signsConfig;
        Sign sign = dataSigns.getSign(signID);
        if (sign == null) {
            return;
        }
        String data = "";
        String type = conf.getString(String.valueOf(signID) + ".TYPE");
        String change = "";
        if (type.equalsIgnoreCase("price") && changePrice != 0.0) {
            data = "$" + format.format(DynamicEconomy.itemConfig.getDouble(String.valueOf(item) + ".price", 0.0));
            change = changePrice > 0.0 ? "+" + format.format(changePrice) : String.valueOf(format.format(changePrice));
        } else if (type.equalsIgnoreCase("stock") && changeStock != 0) {
            data = String.valueOf(DynamicEconomy.itemConfig.getDouble(String.valueOf(item) + ".stock", 0.0));
            change = changeStock > 0 ? "+" + changeStock : String.valueOf(changeStock);
        }
        if (!change.equals("")) {
            sign.setLine(2, String.valueOf(Utility.getColor(DynamicEconomy.signInfoColor)) + data);
            sign.setLine(3, String.valueOf(Utility.getColor(DynamicEconomy.signInfoColor)) + "(" + change + ")");
        }
        sign.update();
    }

    public static void updateItem(String item, String signID, double changeSpan, double changeCeiling, double changeFloor) {
        FileConfiguration conf = DynamicEconomy.signsConfig;
        String[] splitID = signID.split(" ");
        int x = Integer.parseInt(splitID[0]);
        int y = Integer.parseInt(splitID[1]);
        int z = Integer.parseInt(splitID[2]);
        String node = String.valueOf(signID) + ".WORLD";
        String worldName = conf.getString(node, "world");
        Location loc = new Location(Bukkit.getServer().getWorld(worldName), (double)x, (double)y, (double)z);
        Block block = loc.getBlock();
        Sign sign = (Sign)block.getState();
        String data = "";
        String type = conf.getString(String.valueOf(signID) + ".TYPE");
        String change = "";
        if (type.equalsIgnoreCase("ceiling") && changeCeiling != 0.0) {
            data = format.format(DynamicEconomy.itemConfig.getDouble(String.valueOf(item) + ".ceiling", 0.0));
            change = changeCeiling > 0.0 ? "+" + format.format(changeCeiling) : String.valueOf(format.format(changeCeiling));
        } else if (type.equalsIgnoreCase("floor") && changeFloor != 0.0) {
            data = String.valueOf(DynamicEconomy.itemConfig.getDouble(String.valueOf(item) + ".floor", 0.0));
            change = changeFloor > 0.0 ? "+" + format.format(changeFloor) : String.valueOf(format.format(changeFloor));
        } else if (type.equalsIgnoreCase("span") && changeSpan != 0.0) {
            data = String.valueOf(DynamicEconomy.itemConfig.getDouble(String.valueOf(item) + ".velocity", 0.0));
            change = changeSpan > 0.0 ? "+" + format.format(changeSpan) : String.valueOf(format.format(changeSpan));
        }
        if (!change.equals("")) {
            sign.setLine(2, String.valueOf(Utility.getColor(DynamicEconomy.signInfoColor)) + data);
            sign.setLine(3, String.valueOf(Utility.getColor(DynamicEconomy.signInfoColor)) + "(" + change + ")");
        }
        sign.update();
    }
}

