/*
 * Decompiled with CFR 0.152.
 */
package com.ChaseHQ.Statistician;

import com.ChaseHQ.Statistician.Config.Config;
import com.ChaseHQ.Statistician.DataProcessor;
import com.ChaseHQ.Statistician.Database.DBConnectFail;
import com.ChaseHQ.Statistician.Database.DataValues.DataValues_Config;
import com.ChaseHQ.Statistician.Database.Database;
import com.ChaseHQ.Statistician.EventDataHandlers.EDHPlayer;
import com.ChaseHQ.Statistician.Listeners.BlockListener;
import com.ChaseHQ.Statistician.Listeners.EntityListener;
import com.ChaseHQ.Statistician.Listeners.PlayerListener;
import com.ChaseHQ.Statistician.Stats.PlayerData;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class StatisticianPlugin
extends JavaPlugin {
    private static StatisticianPlugin singleton = null;
    private Database database;
    private ExecutorService executorService;
    private DataProcessor dataProcessor;
    private Timer dataProcessorTimer;
    private PlayerData playerData;
    private EDHPlayer edhPlayer;
    private PlayerListener playerListener;
    private BlockListener blockListener;
    private EntityListener entityListener;

    public static StatisticianPlugin getInstance() {
        return singleton;
    }

    public void onEnable() {
        block8: {
            if (singleton != null) {
                return;
            }
            singleton = this;
            this.setNaggable(false);
            if (this.database == null) {
                try {
                    this.database = new Database();
                }
                catch (ClassNotFoundException e) {
                    this.getLogger().severe("MySQL Driver not found");
                    if (Config.getConfig().isVerboseErrors()) {
                        e.printStackTrace();
                    }
                }
                catch (DBConnectFail e) {
                    this.getLogger().log(Level.SEVERE, "Critical Error, could not connect to mySQL. Is the database Available? Check config file and try again. (" + e.getMessage() + ")");
                    if (!Config.getConfig().isVerboseErrors()) break block8;
                    e.printStackTrace();
                }
            }
        }
        if (this.database == null) {
            singleton = null;
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        DataValues_Config.refresh();
        this.database.callStoredProcedure("pluginStartup", null);
        this.executorService = Executors.newCachedThreadPool();
        this.edhPlayer = new EDHPlayer();
        this.playerData = new PlayerData();
        this.dataProcessor = new DataProcessor();
        this.dataProcessor.addProcessable(this.playerData);
        this.dataProcessorTimer = new Timer(true);
        this.dataProcessorTimer.scheduleAtFixedRate((TimerTask)this.dataProcessor, Config.getConfig().getDBUpdateTime(), (long)Config.getConfig().getDBUpdateTime());
        this.playerListener = new PlayerListener(this.edhPlayer);
        this.blockListener = new BlockListener(this.edhPlayer);
        this.entityListener = new EntityListener(this.edhPlayer);
        this.registerEvents();
        Player[] playerArray = this.getServer().getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            this.edhPlayer.PlayerJoin(player);
            ++n2;
        }
    }

    public void onDisable() {
        if (singleton == null || !singleton.equals((Object)this)) {
            return;
        }
        this.dataProcessorTimer.cancel();
        if (this.edhPlayer != null) {
            Player[] playerArray = this.getServer().getOnlinePlayers();
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player player = playerArray[n2];
                this.edhPlayer.PlayerQuit(player);
                ++n2;
            }
        }
        if (this.playerData != null) {
            this.playerData._processData();
        }
        if (this.database != null) {
            this.database.callStoredProcedure("pluginShutdown", null);
            this.database = null;
        }
        singleton = null;
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    private void registerEvents() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)this.blockListener, (Plugin)this);
        pm.registerEvents((Listener)this.entityListener, (Plugin)this);
        pm.registerEvents((Listener)this.playerListener, (Plugin)this);
    }

    public Database getDB() {
        return this.database;
    }

    public ExecutorService getExecutor() {
        return this.executorService;
    }

    public PlayerData getPlayerData() {
        return this.playerData;
    }

    public boolean permissionToRecordStat(Player player) {
        return !player.hasPermission("statistician.ignore");
    }
}

