/*
 * Decompiled with CFR 0.152.
 */
package com.ChaseHQ.Statistician.Stats;

import com.ChaseHQ.Statistician.Database.DBSynchDataGetSet;
import com.ChaseHQ.Statistician.Database.DataValues.DBDataValues_Players;
import com.ChaseHQ.Statistician.Database.DataValues.DataStores;
import com.ChaseHQ.Statistician.Stats.IProcessable;
import com.ChaseHQ.Statistician.Stats.KillTag;
import com.ChaseHQ.Statistician.Stats._InternalPlayer;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Pig;

public class PlayerData
implements IProcessable {
    private HashMap<String, _InternalPlayer> _watchedPlayers = new HashMap();

    public synchronized void addPlayerToWatch(String UUID2, Location loc) {
        _InternalPlayer ip = this._watchedPlayers.get(UUID2);
        if (ip == null) {
            this._watchedPlayers.put(UUID2, new _InternalPlayer(UUID2, loc));
        } else {
            ip.RenewMe = true;
            ip.RenewMeTime = System.currentTimeMillis() / 1000L;
        }
    }

    public synchronized void removePlayerToWatch(String UUID2) {
        _InternalPlayer ip = this._watchedPlayers.get(UUID2);
        Long logoutTime = System.currentTimeMillis() / 1000L;
        if (ip != null) {
            if (ip.RenewMe) {
                ip.TimeAlteration += logoutTime.intValue() - ip.LastUpdateTime.intValue() - (logoutTime.intValue() - ip.RenewMeTime.intValue());
                ip.RenewMe = false;
                ip.LastUpdateTime = logoutTime;
            }
            ip.DestroyAndCleanup = true;
            ip.LogOutTime = logoutTime;
        }
    }

    public synchronized void addBlockBreak(String UUID2, Integer blockID) {
        _InternalPlayer ip = this._watchedPlayers.get(UUID2);
        if (ip == null) {
            return;
        }
        Integer pbb = ip.BlockDestroyed.get(blockID);
        if (pbb == null) {
            pbb = new Integer(0);
        }
        pbb = pbb + 1;
        ip.BlockDestroyed.put(blockID, pbb);
    }

    public void incrementStepsTaken(String UUID2, Location loc, Class<? extends Entity> vehicleType) {
        _InternalPlayer ip = this._watchedPlayers.get(UUID2);
        if (ip == null) {
            return;
        }
        try {
            int newDist = (int)ip.LastLocation.distance(loc);
            if (newDist > 0) {
                ip.Distance = ip.Distance + newDist;
                if (vehicleType != null) {
                    if (Minecart.class.isAssignableFrom(vehicleType)) {
                        ip.DistanceInMinecart = ip.DistanceInMinecart + newDist;
                    }
                    if (Pig.class.isAssignableFrom(vehicleType)) {
                        ip.DistanceOnPig = ip.DistanceOnPig + newDist;
                    }
                    if (Boat.class.isAssignableFrom(vehicleType)) {
                        ip.DistanceInBoat = ip.DistanceInBoat + newDist;
                    }
                }
                ip.LastLocation = loc;
            }
        }
        catch (IllegalArgumentException e) {
            ip.LastLocation = loc;
        }
    }

    public synchronized void addBlockPlaced(String UUID2, Integer blockID) {
        _InternalPlayer ip = this._watchedPlayers.get(UUID2);
        if (ip == null) {
            return;
        }
        Integer pbb = ip.BlockPlaced.get(blockID);
        if (pbb == null) {
            pbb = new Integer(0);
        }
        pbb = pbb + 1;
        ip.BlockPlaced.put(blockID, pbb);
    }

    public synchronized void addKillTag(String UUID2, KillTag kt) {
        _InternalPlayer ip = this._watchedPlayers.get(UUID2);
        if (ip == null) {
            return;
        }
        ip.KillTags.add(kt);
    }

    public synchronized void addItemPickup(String UUID2, Integer itemID, Integer amount) {
        _InternalPlayer ip = this._watchedPlayers.get(UUID2);
        if (ip == null) {
            return;
        }
        Integer itemStore = ip.ItemPickup.get(itemID);
        if (itemStore == null) {
            itemStore = new Integer(0);
        }
        itemStore = itemStore + amount;
        ip.ItemPickup.put(itemID, itemStore);
    }

    public synchronized void addItemDropped(String UUID2, Integer itemID, Integer amount) {
        _InternalPlayer ip = this._watchedPlayers.get(UUID2);
        if (ip == null) {
            return;
        }
        Integer itemStore = ip.ItemDropped.get(itemID);
        if (itemStore == null) {
            itemStore = new Integer(0);
        }
        itemStore = itemStore + amount;
        ip.ItemDropped.put(itemID, itemStore);
    }

    @Override
    public synchronized void _processData() {
        ArrayList<_InternalPlayer> playersToRemove = new ArrayList<_InternalPlayer>();
        for (_InternalPlayer intP : this._watchedPlayers.values()) {
            Long currentTimeStamp = System.currentTimeMillis() / 1000L;
            int timeSpentOnSinceLast = 0;
            if (intP.DestroyAndCleanup) {
                timeSpentOnSinceLast = currentTimeStamp.intValue() - intP.LastUpdateTime.intValue() - (currentTimeStamp.intValue() - intP.LogOutTime.intValue());
                if (intP.RenewMe) {
                    timeSpentOnSinceLast += currentTimeStamp.intValue() - intP.RenewMeTime.intValue();
                }
            } else {
                timeSpentOnSinceLast = currentTimeStamp.intValue() - intP.LastUpdateTime.intValue();
            }
            DBSynchDataGetSet.incrementValue(DataStores.PLAYER, DBDataValues_Players.NUM_SECS_LOGGED, timeSpentOnSinceLast += intP.TimeAlteration, DBDataValues_Players.UUID, intP.UUID);
            if (intP.Distance > 0) {
                DBSynchDataGetSet.incrementValue(DataStores.PLAYER, DBDataValues_Players.DISTANCE_TRAVELED, intP.Distance, DBDataValues_Players.UUID, intP.UUID);
            }
            if (intP.DistanceInMinecart > 0) {
                DBSynchDataGetSet.incrementValue(DataStores.PLAYER, DBDataValues_Players.DISTANCE_TRAVELED_IN_MINECART, intP.DistanceInMinecart, DBDataValues_Players.UUID, intP.UUID);
            }
            if (intP.DistanceOnPig > 0) {
                DBSynchDataGetSet.incrementValue(DataStores.PLAYER, DBDataValues_Players.DISTANCE_TRAVELED_ON_PIG, intP.DistanceOnPig, DBDataValues_Players.UUID, intP.UUID);
            }
            if (intP.DistanceInBoat > 0) {
                DBSynchDataGetSet.incrementValue(DataStores.PLAYER, DBDataValues_Players.DISTANCE_TRAVELED_IN_BOAT, intP.DistanceInBoat, DBDataValues_Players.UUID, intP.UUID);
            }
            for (Integer BlockID : intP.BlockDestroyed.keySet()) {
                Integer smashValue = intP.BlockDestroyed.get(BlockID);
                DBSynchDataGetSet.incrementBlockDestroy(intP.UUID, BlockID, smashValue);
            }
            for (Integer BlockID : intP.BlockPlaced.keySet()) {
                Integer putValue = intP.BlockPlaced.get(BlockID);
                DBSynchDataGetSet.incrementBlockPlaced(intP.UUID, BlockID, putValue);
            }
            for (KillTag kt : intP.KillTags) {
                DBSynchDataGetSet.newKill(kt);
            }
            for (Integer itemID : intP.ItemPickup.keySet()) {
                Integer pickedUp = intP.ItemPickup.get(itemID);
                DBSynchDataGetSet.incrementItemPickup(intP.UUID, itemID, pickedUp);
            }
            for (Integer itemID : intP.ItemDropped.keySet()) {
                Integer dropped = intP.ItemDropped.get(itemID);
                DBSynchDataGetSet.incrementItemDrop(intP.UUID, itemID, dropped);
            }
            intP.LastUpdateTime = currentTimeStamp;
            if (intP.DestroyAndCleanup) {
                if (intP.RenewMe) {
                    intP.DestroyAndCleanup = false;
                    intP.RenewMe = false;
                } else {
                    playersToRemove.add(intP);
                }
            }
            intP._resetInternal();
        }
        for (_InternalPlayer intP : playersToRemove) {
            this._watchedPlayers.remove(intP.UUID);
        }
    }
}

