/*
 * Decompiled with CFR 0.152.
 */
package org.melonbrew.fe;

import java.text.DecimalFormat;
import java.util.List;
import org.bukkit.ChatColor;
import org.melonbrew.fe.Fe;
import org.melonbrew.fe.database.Account;

public class API {
    private final Fe plugin;
    private final DecimalFormat moneyFormat;

    public API(Fe plugin) {
        this.plugin = plugin;
        this.moneyFormat = new DecimalFormat("###,###.###");
    }

    public List<Account> getTopAccounts() {
        return this.plugin.getFeDatabase().getTopAccounts();
    }

    public double getDefaultHoldings() {
        return this.plugin.getConfig().getDouble("holdings");
    }

    public Account createAccount(String name) {
        return this.plugin.getFeDatabase().createAccount(name.toLowerCase());
    }

    public void removeAccount(String name) {
        this.plugin.getFeDatabase().removeAccount(name.toLowerCase());
    }

    public Account getAccount(String name) {
        return this.plugin.getFeDatabase().getAccount(name.toLowerCase());
    }

    public boolean accountExists(String name) {
        return this.plugin.getFeDatabase().accountExists(name.toLowerCase());
    }

    public String formatNoColor(double amount) {
        return ChatColor.stripColor((String)this.format(amount));
    }

    public String format(double amount) {
        amount = this.getMoneyRounded(amount);
        String suffix = " ";
        suffix = amount == 1.0 ? suffix + this.getCurrencySingle() : suffix + this.getCurrencyMultiple();
        return ChatColor.GOLD.toString() + this.moneyFormat.format(amount) + ChatColor.GRAY + suffix;
    }

    private double getMoneyRounded(double amount) {
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        return Double.valueOf(twoDForm.format(amount));
    }

    public String formatNoColor(Account account) {
        return ChatColor.stripColor((String)this.format(account));
    }

    public String format(Account account) {
        return this.format(account.getMoney());
    }

    public String getCurrencySingle() {
        return this.plugin.getCurrencySingle();
    }

    public String getCurrencyMultiple() {
        return this.plugin.getCurrencyMultiple();
    }

    public void clean() {
        this.plugin.getFeDatabase().clean();
    }
}

