/*
 * Decompiled with CFR 0.152.
 */
package org.melonbrew.fe;

import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.melonbrew.fe.API;
import org.melonbrew.fe.Economy_Fe;
import org.melonbrew.fe.FeCommand;
import org.melonbrew.fe.Phrase;
import org.melonbrew.fe.database.Account;
import org.melonbrew.fe.database.Database;
import org.melonbrew.fe.database.databases.FlatFile;
import org.melonbrew.fe.database.databases.MySQLDB;
import org.melonbrew.fe.listeners.FePlayerListener;

public class Fe
extends JavaPlugin {
    private Logger log;
    private API api;
    private Database database;

    public void onEnable() {
        this.log = this.getServer().getLogger();
        this.getDataFolder().mkdirs();
        new FePlayerListener(this);
        this.getConfig().options().copyDefaults(true);
        this.getConfig().options().header("Fe Config - melonbrew.org\nholdings - The amount of money that the player will start out with\nprefix - The message prefix\ncurrency - The single and multiple names for the currency\ntype - The type of database used (mysql or flatfile)\n");
        this.saveConfig();
        this.api = new API(this);
        if (!this.setupDatabase()) {
            return;
        }
        this.setupVault();
        this.getCommand("fe").setExecutor((CommandExecutor)new FeCommand(this));
    }

    private void setupVault() {
        Plugin vault = this.getServer().getPluginManager().getPlugin("Vault");
        if (vault == null) {
            return;
        }
        RegisteredServiceProvider economyProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            this.getServer().getServicesManager().unregister(economyProvider.getProvider());
        }
        this.getServer().getServicesManager().register(Economy.class, (Object)new Economy_Fe((Plugin)this), (Plugin)this, ServicePriority.Highest);
    }

    public void onDisable() {
        this.getServer().getServicesManager().unregisterAll((Plugin)this);
        this.getFeDatabase().close();
    }

    public void log(String message) {
        this.log.info("[Fe] " + message);
    }

    public void log(Phrase phrase) {
        this.log(phrase.parse(new String[0]));
    }

    public Database getFeDatabase() {
        return this.database;
    }

    public API getAPI() {
        return this.api;
    }

    private boolean setupDatabase() {
        String type = this.getConfig().getString("type");
        this.database = type.equalsIgnoreCase("flatfile") ? new FlatFile(this) : new MySQLDB(this);
        if (!this.database.init()) {
            this.log(Phrase.DATABASE_FAILURE_DISABLE);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return false;
        }
        return true;
    }

    public ConfigurationSection getMySQLConfig() {
        return this.getConfig().getConfigurationSection("mysql");
    }

    public String getReadName(Account account) {
        return this.getReadName(account.getName());
    }

    public String getReadName(String name) {
        name = name.toLowerCase();
        OfflinePlayer player = this.getServer().getOfflinePlayer(name);
        if (player != null) {
            name = player.getName();
        }
        return name;
    }

    public String getMessagePrefix() {
        return ChatColor.DARK_GRAY + "[" + ChatColor.GOLD + this.getConfig().getString("prefix") + ChatColor.DARK_GRAY + "] " + ChatColor.GRAY;
    }

    public String getCurrencySingle() {
        return this.getConfig().getString("currency.single");
    }

    public String getCurrencyMultiple() {
        return this.getConfig().getString("currency.multiple");
    }

    public String getEqualMessage(String inBetween, int length) {
        return this.getEqualMessage(inBetween, length, length);
    }

    public String getEqualMessage(String inBetween, int length, int length2) {
        String equals = this.getEndEqualMessage(length);
        String end = this.getEndEqualMessage(length2);
        return equals + ChatColor.DARK_GRAY + "[" + ChatColor.GOLD + inBetween + ChatColor.DARK_GRAY + "]" + end;
    }

    public String getEndEqualMessage(int length) {
        String message = ChatColor.GRAY + "";
        for (int i = 0; i < length; ++i) {
            message = message + "=";
        }
        return message;
    }
}

