/*
 * Decompiled with CFR 0.152.
 */
package org.melonbrew.fe;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.melonbrew.fe.Fe;
import org.melonbrew.fe.Phrase;
import org.melonbrew.fe.command.CommandType;
import org.melonbrew.fe.command.SubCommand;
import org.melonbrew.fe.command.commands.BalanceCommand;
import org.melonbrew.fe.command.commands.CleanCommand;
import org.melonbrew.fe.command.commands.CreateCommand;
import org.melonbrew.fe.command.commands.GrantCommand;
import org.melonbrew.fe.command.commands.HelpCommand;
import org.melonbrew.fe.command.commands.ReloadCommand;
import org.melonbrew.fe.command.commands.RemoveCommand;
import org.melonbrew.fe.command.commands.SendCommand;
import org.melonbrew.fe.command.commands.SetCommand;
import org.melonbrew.fe.command.commands.TopCommand;

public class FeCommand
implements CommandExecutor {
    private final Fe plugin;
    private final List<SubCommand> commands;

    public FeCommand(Fe plugin) {
        this.plugin = plugin;
        this.commands = new ArrayList<SubCommand>();
        this.commands.add(new BalanceCommand(plugin));
        this.commands.add(new ReloadCommand(plugin));
        this.commands.add(new SendCommand(plugin));
        this.commands.add(new TopCommand(plugin));
        this.commands.add(new CreateCommand(plugin));
        this.commands.add(new RemoveCommand(plugin));
        this.commands.add(new SetCommand(plugin));
        this.commands.add(new GrantCommand(plugin));
        this.commands.add(new CleanCommand(plugin));
        this.commands.add(new HelpCommand(plugin, this));
    }

    public List<SubCommand> getCommands() {
        return this.commands;
    }

    private SubCommand getCommand(String name) {
        for (SubCommand command : this.commands) {
            String[] aliases;
            for (String alias : aliases = command.getName().split(",")) {
                if (!alias.equalsIgnoreCase(name)) continue;
                return command;
            }
        }
        return null;
    }

    private String[] merge(String[] ... arrays) {
        int arraySize = 0;
        for (String[] array : arrays) {
            arraySize += array.length;
        }
        String[] result = new String[arraySize];
        int j = 0;
        String[][] arr$ = arrays;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String[] array;
            for (String string : array = arr$[i$]) {
                result[j++] = string;
            }
        }
        return result;
    }

    private void sendDefaultCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        String command = sender instanceof Player ? "balance" : "help";
        this.onCommand(sender, cmd, commandLabel, this.merge({command}, args));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        boolean console;
        if (args.length < 1) {
            this.sendDefaultCommand(sender, cmd, commandLabel, args);
            return true;
        }
        SubCommand command = this.getCommand(args[0]);
        if (command == null) {
            this.sendDefaultCommand(sender, cmd, commandLabel, args);
            return true;
        }
        boolean bl = console = !(sender instanceof Player);
        if (console && args.length < 2 && command.getCommandType() == CommandType.CONSOLE_WITH_ARGUMENTS) {
            sender.sendMessage(ChatColor.RED + "That command needs arguments.");
            return true;
        }
        if (console && command.getCommandType() == CommandType.PLAYER) {
            sender.sendMessage(ChatColor.RED + Phrase.COMMAND_NOT_CONSOLE.parse(command.getFirstName()));
            return true;
        }
        if (!sender.hasPermission(command.getPermission())) {
            sender.sendMessage(ChatColor.RED + Phrase.NO_PERMISSION_FOR_COMMAND.parse(new String[0]));
            return true;
        }
        String[] realArgs = new String[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            realArgs[i - 1] = args[i];
        }
        if (!command.onCommand(sender, cmd, commandLabel, realArgs)) {
            sender.sendMessage(this.plugin.getMessagePrefix() + "Try " + ChatColor.GOLD + "/" + commandLabel + " " + command.getUsage());
        }
        return true;
    }

    public String parse(String label, SubCommand command) {
        String[] split;
        ChatColor commandColor = ChatColor.GOLD;
        ChatColor operatorsColor = ChatColor.DARK_GRAY;
        ChatColor argumentColor = ChatColor.YELLOW;
        String finalMessage = commandColor + "/" + label;
        if (!command.getFirstName().equalsIgnoreCase("balance")) {
            finalMessage = finalMessage + " " + command.getFirstName() + " ";
        }
        if ((split = command.getUsage().split(" "))[0].equalsIgnoreCase(command.getFirstName())) {
            for (int i = 1; i < split.length; ++i) {
                finalMessage = finalMessage + this.parseArg(split[i], operatorsColor, argumentColor) + " ";
            }
            finalMessage = finalMessage.substring(0, finalMessage.length() - 1);
        } else {
            finalMessage = finalMessage + " " + this.parseArg(split[0], operatorsColor, argumentColor) + " ";
            finalMessage = finalMessage.substring(0, finalMessage.length() - 1);
        }
        return finalMessage;
    }

    private String parseArg(String argument, ChatColor operatorsColor, ChatColor argumentColor) {
        String operator = argument.substring(0, 1);
        argument = argument.substring(1, argument.length());
        String reverse = operator.equals("[") ? "]" : ")";
        argument = argument.substring(0, argument.length() - 1);
        argument = operatorsColor + operator + argumentColor + argument + operatorsColor + reverse;
        return argument;
    }
}

