/*
 * Decompiled with CFR 0.152.
 */
package org.melonbrew.fe.command.commands;

import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.melonbrew.fe.Fe;
import org.melonbrew.fe.Phrase;
import org.melonbrew.fe.command.CommandType;
import org.melonbrew.fe.command.SubCommand;
import org.melonbrew.fe.database.Account;

public class GrantCommand
extends SubCommand {
    private final Fe plugin;

    public GrantCommand(Fe plugin) {
        super("grant", "fe.grant", "grant [name] [amount]", "Grants a player more Fe", CommandType.CONSOLE);
        this.plugin = plugin;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        double money;
        if (args.length < 2) {
            return false;
        }
        try {
            money = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        Account victim = this.plugin.getAPI().getAccount(args[0]);
        if (victim == null) {
            sender.sendMessage(this.plugin.getMessagePrefix() + Phrase.ACCOUNT_DOES_NOT_EXIST.parse(new String[0]));
            return true;
        }
        victim.setMoney(victim.getMoney() + money);
        String message = this.plugin.getMessagePrefix() + Phrase.PLAYER_GRANT_MONEY.parse(this.plugin.getAPI().format(money), this.plugin.getReadName(victim));
        sender.sendMessage(message);
        return true;
    }
}

