/*
 * Decompiled with CFR 0.152.
 */
package org.melonbrew.fe.command.commands;

import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.melonbrew.fe.Fe;
import org.melonbrew.fe.Phrase;
import org.melonbrew.fe.command.CommandType;
import org.melonbrew.fe.command.SubCommand;
import org.melonbrew.fe.database.Account;

public class SendCommand
extends SubCommand {
    private final Fe plugin;

    public SendCommand(Fe plugin) {
        super("send,pay,give", "fe.send", "send [name] [amount]", "Sends another player Fe", CommandType.PLAYER);
        this.plugin = plugin;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        double money;
        if (args.length < 2) {
            return false;
        }
        try {
            money = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (money <= 0.0) {
            return false;
        }
        Account reciever = this.plugin.getAPI().getAccount(args[0]);
        String messagePrefix = this.plugin.getMessagePrefix();
        if (reciever == null) {
            sender.sendMessage(messagePrefix + Phrase.ACCOUNT_DOES_NOT_EXIST.parse(new String[0]));
            return true;
        }
        Account account = this.plugin.getAPI().getAccount(sender.getName());
        if (!account.has(money)) {
            sender.sendMessage(messagePrefix + Phrase.NOT_ENOUGH_MONEY.parse(new String[0]));
            return true;
        }
        String formattedMoney = this.plugin.getAPI().format(money);
        account.withdraw(money);
        reciever.deposit(money);
        sender.sendMessage(messagePrefix + "You've sent " + formattedMoney + " to " + this.plugin.getReadName(reciever));
        Player recieverPlayer = this.plugin.getServer().getPlayerExact(reciever.getName());
        if (recieverPlayer != null) {
            recieverPlayer.sendMessage(messagePrefix + Phrase.MONEY_RECIEVE.parse(formattedMoney, sender.getName()));
        }
        return true;
    }
}

