/*
 * Decompiled with CFR 0.152.
 */
package org.melonbrew.fe.database;

import java.text.DecimalFormat;
import org.melonbrew.fe.database.Database;

public class Account {
    private final String name;
    private final Database database;

    public Account(String name, Database database) {
        this.name = name;
        this.database = database;
    }

    public String getName() {
        return this.name;
    }

    public double getMoney() {
        return this.database.loadAccountMoney(this.name);
    }

    public void withdraw(double amount) {
        this.setMoney(this.getMoney() - amount);
    }

    public void deposit(double amount) {
        this.setMoney(this.getMoney() + amount);
    }

    public double getMoneyRounded(double amount) {
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        return Double.valueOf(twoDForm.format(amount));
    }

    public void setMoney(double money) {
        double currentMoney = this.getMoney();
        if (currentMoney == money) {
            return;
        }
        if (money < 0.0) {
            money = 0.0;
        }
        currentMoney = this.getMoneyRounded(money);
        this.save(currentMoney);
    }

    public boolean has(double amount) {
        return this.getMoney() >= amount;
    }

    public void save(double money) {
        this.database.saveAccount(this.name, money);
    }
}

