/*
 * Decompiled with CFR 0.152.
 */
package org.melonbrew.fe.database;

import java.util.List;
import org.melonbrew.fe.Fe;
import org.melonbrew.fe.database.Account;

public abstract class Database {
    private final Fe plugin;

    public Database(Fe plugin) {
        this.plugin = plugin;
    }

    public abstract boolean init();

    public abstract List<Account> getTopAccounts();

    public abstract double loadAccountMoney(String var1);

    protected abstract void saveAccount(String var1, double var2);

    public abstract void removeAccount(String var1);

    public abstract void clean();

    public abstract void close();

    public Account getAccount(String name) {
        double money = this.loadAccountMoney(name);
        if (money == -1.0) {
            return null;
        }
        Account account = new Account(name, this);
        account.setMoney(money);
        return account;
    }

    public Account createAccount(String name) {
        Account exists = this.getAccount(name);
        if (exists != null) {
            return exists;
        }
        Account account = new Account(name, this);
        account.setMoney(this.plugin.getAPI().getDefaultHoldings());
        return account;
    }

    public boolean accountExists(String name) {
        return this.getAccount(name) != null;
    }
}

