/*
 * Decompiled with CFR 0.152.
 */
package org.melonbrew.fe.database.databases;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.melonbrew.fe.Fe;
import org.melonbrew.fe.database.Account;
import org.melonbrew.fe.database.AccountCompare;
import org.melonbrew.fe.database.Database;

public class FlatFile
extends Database {
    private final Fe plugin;
    private final File storageFile;
    private final Properties storage;

    public FlatFile(Fe plugin) {
        super(plugin);
        this.plugin = plugin;
        this.storageFile = new File(plugin.getDataFolder(), "flatdatabase.prop");
        this.storage = new Properties();
    }

    @Override
    public boolean init() {
        try {
            this.storageFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        try {
            FileInputStream inputStream = new FileInputStream(this.storageFile);
            this.storage.load(inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public double loadAccountMoney(String name) {
        try {
            double money = Double.parseDouble(this.storage.getProperty(name));
            return money;
        }
        catch (Exception e) {
            return -1.0;
        }
    }

    @Override
    public void removeAccount(String name) {
        this.storage.remove(name);
        this.saveFile();
    }

    private void saveFile() {
        this.storageFile.delete();
        try {
            this.storageFile.createNewFile();
            FileOutputStream outputStream = new FileOutputStream(this.storageFile);
            this.storage.store(outputStream, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void saveAccount(String name, double money) {
        this.storage.setProperty(name, money + "");
        this.saveFile();
    }

    @Override
    public List<Account> getTopAccounts() {
        ArrayList<Account> allAccounts = new ArrayList<Account>();
        for (String name : this.storage.stringPropertyNames()) {
            Account account = this.getAccount(name);
            allAccounts.add(account);
        }
        Account[] array = allAccounts.toArray(new Account[allAccounts.size()]);
        Arrays.sort(array, new AccountCompare());
        ArrayList<Account> finalAccounts = new ArrayList<Account>();
        for (int i = array.length - 1; i > array.length - 6; --i) {
            try {
                finalAccounts.add(array[i]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                break;
            }
        }
        return finalAccounts;
    }

    @Override
    public void clean() {
        for (String name : this.storage.stringPropertyNames()) {
            Account account = this.getAccount(name);
            if (this.plugin.getServer().getPlayerExact(name) != null || account.getMoney() != this.plugin.getAPI().getDefaultHoldings()) continue;
            this.removeAccount(name);
        }
    }
}

