/*
 * Decompiled with CFR 0.152.
 */
package org.melonbrew.fe.database.databases;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import lib.PatPeter.SQLibrary.MySQL;
import org.bukkit.configuration.ConfigurationSection;
import org.melonbrew.fe.Fe;
import org.melonbrew.fe.database.Account;
import org.melonbrew.fe.database.Database;

public class MySQLDB
extends Database {
    private final Fe plugin;
    private MySQL mySQL;
    private final String accounts;

    public MySQLDB(Fe plugin) {
        super(plugin);
        this.plugin = plugin;
        this.accounts = "fe_accounts";
    }

    @Override
    public boolean init() {
        ConfigurationSection config = this.plugin.getMySQLConfig();
        this.mySQL = new MySQL(this.plugin.getLogger(), "Fe", config.getString("host"), config.getString("port"), config.getString("database"), config.getString("user"), config.getString("password"));
        this.mySQL.open();
        if (!this.mySQL.checkConnection()) {
            return false;
        }
        return this.mySQL.createTable("CREATE TABLE IF NOT EXISTS " + this.accounts + "(name varchar(16), money double);");
    }

    @Override
    public void close() {
        this.mySQL.close();
    }

    @Override
    public List<Account> getTopAccounts() {
        String sql = "SELECT name FROM " + this.accounts + " ORDER BY money DESC limit 5";
        ArrayList<Account> topAccounts = new ArrayList<Account>();
        ResultSet set = this.mySQL.query(sql);
        try {
            while (set.next()) {
                topAccounts.add(this.getAccount(set.getString("name")));
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        return topAccounts;
    }

    @Override
    public double loadAccountMoney(String name) {
        String sql = "SELECT * FROM " + this.accounts + " WHERE name=?";
        double money = -1.0;
        try {
            PreparedStatement prest = this.mySQL.prepare(sql);
            prest.setString(1, name);
            ResultSet set = prest.executeQuery();
            while (set.next()) {
                money = set.getDouble("money");
            }
            prest.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1.0;
        }
        return money;
    }

    @Override
    public void removeAccount(String name) {
        String sql = "DELETE FROM " + this.accounts + " WHERE name=?";
        try {
            PreparedStatement prest = this.mySQL.prepare(sql);
            prest.setString(1, name);
            prest.execute();
            prest.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    protected void saveAccount(String name, double money) {
        if (this.accountExists(name)) {
            String sql = "UPDATE " + this.accounts + " SET money=? WHERE name=?";
            try {
                PreparedStatement prest = this.mySQL.prepare(sql);
                prest.setDouble(1, money);
                prest.setString(2, name);
                prest.executeUpdate();
                prest.close();
            }
            catch (SQLException e) {}
        } else {
            String sql = "INSERT INTO " + this.accounts + " (name, money) VALUES (?, ?)";
            try {
                PreparedStatement prest = this.mySQL.prepare(sql);
                prest.setString(1, name);
                prest.setDouble(2, money);
                prest.executeUpdate();
                prest.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
    }

    @Override
    public void clean() {
        String sql = "SELECT name FROM " + this.accounts + " WHERE money=" + this.plugin.getAPI().getDefaultHoldings();
        ResultSet set = this.mySQL.query(sql);
        try {
            while (set.next()) {
                String name = set.getString("name");
                if (this.plugin.getServer().getPlayerExact(name) != null) continue;
                this.mySQL.query("DELETE FROM " + this.accounts + " WHERE name='" + name + "'");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

