/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.zcraig29;

import com.gmail.zcraig29.PlayerJoin;
import java.io.File;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MaintenanceMode
extends JavaPlugin {
    public static boolean kickplayers;
    Logger log;

    public void onEnable() {
        this.log = this.getLogger();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoin(this), (Plugin)this);
        File f = new File(this.getDataFolder(), "config.yml");
        if (!f.exists()) {
            this.log.info("No Configuration file found! Generating a new one!");
            FileConfiguration config = this.getConfig();
            this.saveDefaultConfig();
            this.log.info("Configuration file created succesfully!");
        }
        if (this.getConfig().getBoolean("defaults.persist")) {
            this.log.info("Checking persistance");
            if (this.getConfig().getBoolean("mm")) {
                this.getServer().getConsoleSender().sendMessage("MaintenanceMode is " + ChatColor.GREEN + " ON");
                kickplayers = true;
            } else if (!this.getConfig().getBoolean("mm")) {
                this.getServer().getConsoleSender().sendMessage("MaintenanceMode is " + ChatColor.RED + " OFF");
                kickplayers = false;
            }
        }
    }

    public void onDisable() {
        this.log.info("Plugin Sucessfully disabled!");
        if (this.getConfig().getBoolean("defaults.persist")) {
            this.log.info("Persistance enabled, Saving MaintenanceMode");
            if (kickplayers) {
                this.log.info("Setting config to TRUE");
                this.getConfig().set("mm", (Object)true);
            } else if (!kickplayers) {
                this.log.info("Setting config to FLASE");
                this.getConfig().set("mm", (Object)false);
            }
        }
        this.saveConfig();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        String arg1 = args[0];
        String warningmessage = this.getConfig().getString("defaults.warning-message");
        final String kickmessage = this.getConfig().getString("defaults.kick-message");
        long time = this.getConfig().getInt("defaults.time");
        if (!cmd.getName().equalsIgnoreCase("mm")) return false;
        if (args.length < 1) return false;
        if (arg1.equalsIgnoreCase("enable")) {
            if (kickplayers) {
                sender.sendMessage(ChatColor.RED + "[ERROR] MaintenanceMode is already enabled!");
                return true;
            }
            if (this.getConfig().getBoolean("defaults.delay")) {
                Bukkit.broadcastMessage((String)(ChatColor.GOLD + "[MM] MaintenanceMode enabled by " + sender.getName()));
                Bukkit.broadcastMessage((String)(ChatColor.RED + "[WARNING] " + warningmessage));
                kickplayers = true;
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

                    @Override
                    public void run() {
                        Player[] playerArray = MaintenanceMode.this.getServer().getOnlinePlayers();
                        int n = playerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Player p = playerArray[n2];
                            if (!p.hasPermission("mm.bypass")) {
                                p.kickPlayer(kickmessage);
                            }
                            ++n2;
                        }
                    }
                }, time * 20L);
                return true;
            }
            if (!this.getConfig().getBoolean("defaults.delay")) {
                Bukkit.broadcastMessage((String)(ChatColor.GOLD + "[MM] MaintenanceMode enabled by " + sender.getName()));
                kickplayers = true;
                Player[] playerArray = this.getServer().getOnlinePlayers();
                if (playerArray.length != 0) {
                    Player p = playerArray[0];
                    p.kickPlayer(kickmessage);
                    return true;
                }
            }
        } else if (arg1.equalsIgnoreCase("disable")) {
            if (kickplayers) {
                Bukkit.broadcastMessage((String)(ChatColor.GOLD + "[MM] MaintenanceMode disabled by " + sender.getName()));
                kickplayers = false;
                return true;
            }
            sender.sendMessage(ChatColor.RED + "[ERROR] MaintenanceMode is already disabled!");
            return true;
        }
        if (!arg1.equalsIgnoreCase("status")) return false;
        if (kickplayers) {
            sender.sendMessage(ChatColor.GOLD + "[MM] MaintenanceMode is currently enabled!");
            return true;
        }
        if (kickplayers) return true;
        sender.sendMessage(ChatColor.GOLD + "[MM] MaintenanceMode is currently disabled!");
        return true;
    }
}

