/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import codechicken.core.IGuiIndirectButtons;

public abstract class GuiScrollSlot
extends oo {
    protected abp scrollupbutton;
    protected abp scrolldownbutton;
    protected abp activatebutton;
    protected IGuiIndirectButtons parentscreen;
    protected int scrollclicky = -1;
    protected float scrollpercent;
    protected int scrollmousey;
    protected float percentscrolled;
    protected int lastslotclicked = -1;
    protected long lastslotclicktime;
    public boolean focused;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int contentx;
    protected int contenty;
    protected int contentheight;

    public GuiScrollSlot(IGuiIndirectButtons parent) {
        this.parentscreen = parent;
    }

    public void setSize(int x2, int y2, int w2, int h2) {
        this.x = x2;
        this.y = y2;
        this.width = w2;
        this.height = h2;
        this.contentx = x2 + 3;
        this.contenty = y2 + 2;
        this.contentheight = this.height - 2;
    }

    public void setContentSize(int x2, int y2, int h2) {
        this.contentx = x2;
        this.contenty = y2;
        this.contentheight = h2;
    }

    public void registerButtons(abp up2, abp down, abp activate) {
        this.scrollupbutton = up2;
        this.scrolldownbutton = down;
        this.activatebutton = activate;
    }

    public abstract int getSlotHeight();

    protected abstract int getNumSlots();

    public abstract void selectNext();

    public abstract void selectPrev();

    protected abstract void slotClicked(int var1, boolean var2);

    protected abstract boolean isSlotSelected(int var1);

    protected abstract void drawSlot(int var1, int var2, int var3, boolean var4);

    protected void unfocus() {
    }

    public void setFocused(boolean focus) {
        if (!focus) {
            this.unfocus();
        }
        this.focused = focus;
    }

    public void scrollUp() {
        this.percentscrolled = (float)((double)this.percentscrolled - 0.05);
        this.calculatePercentScrolled();
    }

    public void scrollDown() {
        this.percentscrolled = (float)((double)this.percentscrolled + 0.05);
        this.calculatePercentScrolled();
    }

    public int getContentHeight() {
        return this.getNumSlots() * this.getSlotHeight();
    }

    public int getClickedSlot(int mousey) {
        int startheight = this.contenty - (int)((double)((float)(this.getContentHeight() - this.contentheight) * this.percentscrolled) + 0.5);
        int slot = 0;
        while (slot < this.getNumSlots()) {
            int sloty = startheight + slot * this.getSlotHeight();
            if (mousey >= sloty && mousey < sloty + this.getSlotHeight()) {
                return slot;
            }
            ++slot;
        }
        return -1;
    }

    public int getScrollBarWidth() {
        return 5;
    }

    public int getScrollBarHeight() {
        int sbarh = (int)((float)this.contentheight / (float)this.getContentHeight() * (float)this.height);
        if (sbarh > this.height) {
            return this.height;
        }
        if (sbarh < this.height / 15) {
            return this.height / 15;
        }
        return sbarh;
    }

    public void calculatePercentScrolled() {
        int barempty = this.height - this.getScrollBarHeight();
        if (this.scrollclicky >= 0) {
            int scrolldiff = this.scrollmousey - this.scrollclicky;
            this.percentscrolled = (float)scrolldiff / (float)barempty + this.scrollpercent;
        }
        if (this.percentscrolled < 0.0f) {
            this.percentscrolled = 0.0f;
        }
        if (this.percentscrolled > 1.0f) {
            this.percentscrolled = 1.0f;
        }
        int sbary = this.y + (int)((double)((float)barempty * this.percentscrolled) + 0.5);
        this.percentscrolled = (float)(sbary - this.y) / (float)barempty;
    }

    public void showSlot(int slot) {
        int startheight = this.contenty - (int)((double)((float)(this.getContentHeight() - this.contentheight) * this.percentscrolled) + 0.5);
        int sloty = startheight + slot * this.getSlotHeight();
        while (sloty > this.contenty + this.contentheight - this.getSlotHeight()) {
            this.scrollDown();
            startheight = this.contenty - (int)((double)((float)(this.getContentHeight() - this.contentheight) * this.percentscrolled) + 0.5);
            sloty = startheight + slot * this.getSlotHeight();
        }
        while (sloty < this.contenty) {
            this.scrollUp();
            startheight = this.contenty - (int)((double)((float)(this.getContentHeight() - this.contentheight) * this.percentscrolled) + 0.5);
            sloty = startheight + slot * this.getSlotHeight();
        }
    }

    public void processMouse(int mousex, int mousey) {
        if (this.scrollclicky >= 0) {
            int scrolldiff = mousey - this.scrollclicky;
            int barupallowed = (int)((double)((float)(this.height - this.getScrollBarHeight()) * this.scrollpercent) + 0.5);
            int bardownallowed = this.height - this.getScrollBarHeight() - barupallowed;
            this.scrollmousey = -scrolldiff > barupallowed ? this.scrollclicky - barupallowed : (scrolldiff > bardownallowed ? this.scrollclicky + bardownallowed : mousey);
            this.calculatePercentScrolled();
        }
    }

    public void actionPerformed(abp guibutton) {
        if (!guibutton.h) {
            return;
        }
        if (this.scrollupbutton != null && guibutton.f == this.scrollupbutton.f) {
            this.scrollUp();
        } else if (this.scrolldownbutton != null && guibutton.f == this.scrolldownbutton.f) {
            this.scrollDown();
        }
    }

    public void mouseClicked(int mousex, int mousey, int button) {
        boolean needsfocus;
        boolean bl2 = needsfocus = mousex >= this.x && mousex < this.x + this.width && mousey >= this.y && mousey <= this.y + this.height;
        if (needsfocus != this.focused) {
            this.setFocused(needsfocus);
        }
        if (button != 0) {
            return;
        }
        int barempty = this.height - this.getScrollBarHeight();
        int sbarx = this.x + this.width - this.getScrollBarWidth();
        int sbary = this.y + (int)((double)((float)barempty * this.percentscrolled) + 0.5);
        if (this.getScrollBarHeight() < this.height && mousex >= sbarx && mousex <= this.x + this.width && mousey >= this.y && mousey <= this.y + this.height) {
            if (mousey < sbary) {
                this.percentscrolled = (float)(mousey - this.y) / (float)barempty;
                this.calculatePercentScrolled();
            } else if (mousey > sbary + this.getScrollBarHeight()) {
                this.percentscrolled = (float)(mousey - this.y - this.getScrollBarHeight() + 1) / (float)barempty;
                this.calculatePercentScrolled();
            } else {
                this.scrollclicky = mousey;
                this.scrollpercent = this.percentscrolled;
                this.scrollmousey = mousey;
            }
        } else if (mousex >= this.contentx && mousex < sbarx && mousey >= this.contenty && mousey <= this.contenty + this.contentheight) {
            int slot = this.getClickedSlot(mousey);
            if (slot == this.lastslotclicked && System.currentTimeMillis() - this.lastslotclicktime < 500L) {
                this.slotClicked(slot, true);
            } else {
                this.slotClicked(slot, false);
            }
            this.lastslotclicked = slot;
            this.lastslotclicktime = System.currentTimeMillis();
        }
    }

    public void mouseMovedOrUp(int mousex, int mousey, int button) {
        if (this.scrollclicky >= 0 && button == 0) {
            this.scrollclicky = -1;
        }
    }

    public void keyTyped(char c2, int keycode) {
        if (!this.focused) {
            return;
        }
        if (keycode == 200) {
            this.selectPrev();
        }
        if (keycode == 208) {
            this.selectNext();
        }
        if (keycode == 28 && this.activatebutton != null) {
            this.parentscreen.buttonPressed(this.activatebutton);
        }
    }

    public void drawSlotBox() {
        GuiScrollSlot.a(this.x, this.y, this.x + this.width, this.y + this.height, -16777216);
    }

    public void drawBackground() {
    }

    public void drawOverlay() {
        GuiScrollSlot.a(this.x, this.y - 1, this.x + this.width, this.y, -6250336);
        GuiScrollSlot.a(this.x, this.y + this.height, this.x + this.width, this.y + this.height + 1, -6250336);
        GuiScrollSlot.a(this.x - 1, this.y - 1, this.x, this.y + this.height + 1, -6250336);
        GuiScrollSlot.a(this.x + this.width, this.y - 1, this.x + this.width + 1, this.y + this.height + 1, -6250336);
    }

    public void drawScrollBar() {
        int sbarx = this.x + this.width - this.getScrollBarWidth();
        int sbary = this.y + (int)((double)((float)(this.height - this.getScrollBarHeight()) * this.percentscrolled) + 0.5);
        GuiScrollSlot.a(sbarx - 1, this.y, sbarx, this.y + this.height, -8355712);
        GuiScrollSlot.a(sbarx, sbary, this.x + this.width, sbary + this.getScrollBarHeight(), -2039584);
    }

    public void drawSlots() {
        int startheight = this.contenty - (int)((double)((float)(this.getContentHeight() - this.contentheight) * this.percentscrolled) + 0.5);
        int slot = 0;
        while (slot < this.getNumSlots()) {
            int sloty = startheight + slot * this.getSlotHeight();
            if (sloty > this.contenty - this.getSlotHeight() && sloty < this.contenty + this.contentheight) {
                this.drawSlot(slot, this.contentx, sloty, this.isSlotSelected(slot));
            }
            ++slot;
        }
    }

    public void drawScreen(int mousex, int mousey, float partialframe) {
        this.processMouse(mousex, mousey);
        this.drawBackground();
        this.drawSlotBox();
        this.drawSlots();
        this.drawScrollBar();
        this.drawOverlay();
    }
}

