/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.ConfigFile;
import codechicken.core.ConfigTag;
import codechicken.nei.DropDownWidget;
import codechicken.nei.GuiManager;
import codechicken.nei.ItemVisibilityHash;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIConfig;
import codechicken.nei.SubSetRangeTag;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class DropDownFile
extends ConfigFile {
    public ArrayList sortedtags = new ArrayList();
    public int slotwidth = 0;
    public boolean hasscroll;
    protected int scrollclicky = -1;
    protected float scrollpercent;
    protected int scrollmousey;
    protected float percentscrolled;
    protected int lastslotclicked = -1;
    protected long lastslotclicktime;
    int x;
    int y;
    int height;
    int width;
    int contentheight;
    public boolean hidden;
    public static final int slotheight = 18;
    public static DropDownFile dropDownInstance = new DropDownFile(new File(Minecraft.b(), "config/NEISubset.cfg"));

    static {
        dropDownInstance.setComment("You can put your own custom SubSet Ranges in here:Follow the following format (replace {something} with what you want.:{Parent}.{Name}=[{item1}],[{item2}],[{item3}-{item4}],[{item5}::{damage}],[{item6}::{damage1}-{damage2}]:Eg. Blocks.Nether = [87-89],[112-115]:Eg2. Birch = [17::2],[6::2]");
    }

    public DropDownFile(File file) {
        super(file);
    }

    @Override
    public SubSetRangeTag getTag(String tagname) {
        return (SubSetRangeTag)super.getTag(tagname);
    }

    @Override
    public SubSetRangeTag getTag(String tagname, boolean createnew) {
        return (SubSetRangeTag)super.getTag(tagname, createnew);
    }

    @Override
    public SubSetRangeTag getNewTag(String name) {
        return new SubSetRangeTag(this, name);
    }

    @Override
    public void saveConfig() {
        super.saveConfig();
    }

    public boolean thisContains(int mousex, int mousey) {
        return mousex >= this.x && mousex < this.x + this.width && mousey >= this.y && mousey <= this.y + this.height;
    }

    public boolean contains(int mousex, int mousey) {
        if (this.thisContains(mousex, mousey)) {
            return true;
        }
        for (ConfigTag tag : this.sortedtags) {
            SubSetRangeTag stag = (SubSetRangeTag)tag;
            if (!stag.contains(mousex, mousey)) continue;
            return true;
        }
        return false;
    }

    public int getScrollBarWidth() {
        return 5;
    }

    public int getScrollBarHeight() {
        int sbarh = (int)((float)this.height / (float)this.contentheight * (float)this.height);
        if (sbarh > this.height) {
            return this.height;
        }
        if (sbarh < this.height / 15) {
            return this.height / 15;
        }
        return sbarh;
    }

    public int getScrolledSlots() {
        int slots = this.maintags.size();
        int shownslots = this.height / 18;
        return (int)(this.percentscrolled * (float)(slots - shownslots) + 0.5f);
    }

    private int getClickedSlot(int mousey) {
        return (mousey - this.y) / 18 + this.getScrolledSlots();
    }

    public void calculatePercentScrolled() {
        int barempty = this.height - this.getScrollBarHeight();
        if (this.scrollclicky >= 0) {
            int scrolldiff = this.scrollmousey - this.scrollclicky;
            this.percentscrolled = (float)scrolldiff / (float)barempty + this.scrollpercent;
        }
        if (this.percentscrolled < 0.0f) {
            this.percentscrolled = 0.0f;
        }
        if (this.percentscrolled > 1.0f) {
            this.percentscrolled = 1.0f;
        }
        int sbary = this.y + (int)((double)((float)barempty * this.percentscrolled) + 0.5);
        this.percentscrolled = (float)(sbary - this.y) / (float)barempty;
    }

    public void processScrollMouse(int mousex, int mousey) {
        if (this.scrollclicky >= 0) {
            int scrolldiff = mousey - this.scrollclicky;
            int barupallowed = (int)((double)((float)(this.height - this.getScrollBarHeight()) * this.scrollpercent) + 0.5);
            int bardownallowed = this.height - this.getScrollBarHeight() - barupallowed;
            this.scrollmousey = -scrolldiff > barupallowed ? this.scrollclicky - barupallowed : (scrolldiff > bardownallowed ? this.scrollclicky + bardownallowed : mousey);
            this.calculatePercentScrolled();
        }
    }

    public String updateMouseOver(int mousex, int mousey, String mouseovername) {
        this.processScrollMouse(mousex, mousey);
        String currentmouseover = "";
        int sloty = this.y;
        int slotx = this.x + (this.hasscroll ? this.getScrollBarWidth() : 0);
        int slot = 0;
        for (ConfigTag tag : this.sortedtags) {
            String s2;
            if (++slot <= this.getScrolledSlots()) continue;
            SubSetRangeTag stag = (SubSetRangeTag)tag;
            if (slotx <= mousex && this.x + this.width > mousex && sloty <= mousey && sloty + 18 > mousey) {
                currentmouseover = stag.qualifiedname;
            }
            if (!(s2 = stag.updateMouseOver(mousex, mousey, mouseovername)).equals("")) {
                currentmouseover = s2;
            }
            sloty += 18;
        }
        return currentmouseover;
    }

    public boolean click(int mousex, int mousey, int button) {
        boolean inbounds = this.thisContains(mousex, mousey);
        if (!inbounds) {
            for (ConfigTag tag : this.sortedtags) {
                SubSetRangeTag stag = (SubSetRangeTag)tag;
                stag.click(mousex, mousey, button);
            }
        }
        int barempty = this.height - this.getScrollBarHeight();
        int sbary = this.y + (int)((double)((float)barempty * this.percentscrolled) + 0.5);
        int contentx = this.x + this.getScrollBarWidth();
        if (this.hasscroll && button == 0 && this.getScrollBarHeight() < this.height && mousex >= this.x && mousex <= this.x + this.getScrollBarWidth() && mousey >= this.y && mousey <= this.y + this.height) {
            if (mousey < sbary) {
                this.percentscrolled = (float)(mousey - this.y) / (float)barempty;
                this.calculatePercentScrolled();
            } else if (mousey > sbary + this.getScrollBarHeight()) {
                this.percentscrolled = (float)(mousey - this.y - this.getScrollBarHeight() + 1) / (float)barempty;
                this.calculatePercentScrolled();
            } else {
                this.scrollclicky = mousey;
                this.scrollpercent = this.percentscrolled;
                this.scrollmousey = mousey;
            }
        } else if (mousex >= contentx && mousex < this.x + this.width && mousey >= this.y && mousey <= this.y + this.height) {
            int slot = this.getClickedSlot(mousey);
            if (slot == this.lastslotclicked && System.currentTimeMillis() - this.lastslotclicktime < 500L && button == 0) {
                this.slotClicked(slot, button, true);
            } else {
                this.slotClicked(slot, button, false);
            }
            if (button == 0) {
                this.lastslotclicked = slot;
                this.lastslotclicktime = System.currentTimeMillis();
            }
        }
        return true;
    }

    public void onMouseWheel(int i2) {
        if (this.scrollclicky != -1) {
            return;
        }
        for (ConfigTag tag : this.sortedtags) {
            SubSetRangeTag stag = (SubSetRangeTag)tag;
            if (!stag.expanded) continue;
            stag.onMouseWheel(i2);
            return;
        }
        this.scrollpercent += (float)i2 / (float)this.contentheight * 10.0f;
        if (this.scrollpercent > 1.0f) {
            this.scrollpercent = 1.0f;
        } else if (this.scrollpercent < 0.0f) {
            this.scrollpercent = 0.0f;
        }
    }

    private void slotClicked(int slot, int button, boolean doubleclick) {
        int i2 = 0;
        for (ConfigTag tag : this.sortedtags) {
            if (slot == i2) {
                SubSetRangeTag stag = (SubSetRangeTag)tag;
                stag.onClick(button, doubleclick);
                return;
            }
            ++i2;
        }
    }

    public void hideAllItems() {
        for (ConfigTag tag : this.sortedtags) {
            SubSetRangeTag stag = (SubSetRangeTag)tag;
            stag.hideAllItems();
        }
    }

    public void showAllItems() {
        for (ConfigTag tag : this.sortedtags) {
            SubSetRangeTag stag = (SubSetRangeTag)tag;
            stag.showAllItems();
        }
    }

    public void mouseUp(int mousex, int mousey, int button) {
        if (this.scrollclicky >= 0 && button == 0) {
            this.scrollclicky = -1;
        }
        for (ConfigTag tag : this.sortedtags) {
            SubSetRangeTag stag = (SubSetRangeTag)tag;
            stag.mouseUp(mousex, mousey, button);
        }
    }

    public void draw(GuiManager gui, int mousex, int mousey) {
        this.drawScrollBar(gui);
        int drawy = this.y;
        int drawx = this.x + (this.hasscroll ? this.getScrollBarWidth() : 0);
        int slot = 0;
        for (ConfigTag tag : this.sortedtags) {
            if (++slot <= this.getScrolledSlots()) continue;
            SubSetRangeTag stag = (SubSetRangeTag)tag;
            if (!this.hidden) {
                if (!DropDownWidget.texturedButtons) {
                    boolean contains = mousex >= drawx && mousex < drawx + this.slotwidth && mousey >= drawy && mousey < drawy + 18;
                    gui.drawRect(drawx, drawy, this.slotwidth, 18, contains ? -12578808 : -16777216);
                    gui.drawTextCentered(drawx, drawy, this.slotwidth, 18, stag.name, stag.getColourFromState(), stag.state == 0);
                } else {
                    GL11.glBindTexture((int)3553, (int)gui.window.mc().p.b("/gui/gui.png"));
                    if (stag.state == 1) {
                        GL11.glColor4f((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
                    } else {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                    int tex = stag.state == 0 ? 0 : 1;
                    gui.drawButtonBackground(drawx, drawy, this.slotwidth, 18, false, tex);
                    int textcolour = stag.state == 2 ? -2039584 : -6250336;
                    gui.drawTextCentered(drawx, drawy, this.slotwidth, 18, stag.name, textcolour);
                }
            }
            stag.draw(gui, mousex, mousey);
            if ((drawy += 18) >= this.y + this.height) break;
        }
    }

    private void drawScrollBar(GuiManager gui) {
        if (this.hasscroll && !this.hidden) {
            int sbary = this.y + (int)((double)((float)(this.height - this.getScrollBarHeight()) * this.percentscrolled) + 0.5);
            gui.drawRect(this.x, this.y, 5, this.height, -14671840);
            if (DropDownWidget.texturedButtons) {
                gui.drawRect(this.x, sbary, 5, this.getScrollBarHeight(), -7631989);
                gui.drawRect(this.x, sbary, 4, this.getScrollBarHeight() - 1, -986896);
                gui.drawRect(this.x + 1, sbary + 1, 4, this.getScrollBarHeight() - 1, -11184811);
                gui.drawRect(this.x + 1, sbary + 1, 3, this.getScrollBarHeight() - 2, -3750202);
            } else {
                gui.drawRect(this.x, sbary, 5, this.getScrollBarHeight(), -2039584);
            }
        }
    }

    public void position(int px2, int py2) {
        this.x = px2;
        this.y = py2;
        this.recalcSize();
        int suby = this.y;
        int subx = this.x + this.width;
        int slot = 0;
        for (ConfigTag tag : this.sortedtags) {
            if (++slot <= this.getScrolledSlots()) continue;
            SubSetRangeTag stag = (SubSetRangeTag)tag;
            stag.position(subx, suby);
            if ((suby += 18) >= this.y + this.height) break;
        }
    }

    public void recalcSize() {
        int totalwidth;
        int maxheight = ModLoader.getMinecraftInstance().s.r - this.y;
        this.contentheight = this.maintags.size() * 18;
        if (this.contentheight > maxheight) {
            this.height = maxheight / 18 * 18;
            this.hasscroll = true;
        } else {
            this.hasscroll = false;
            this.height = this.contentheight;
        }
        this.slotwidth = 0;
        nl fontRenderer = ModLoader.getMinecraftInstance().q;
        for (ConfigTag tag : this.sortedtags) {
            int tagwidth = fontRenderer.a(tag.name);
            if (tagwidth <= this.slotwidth) continue;
            this.slotwidth = tagwidth;
        }
        this.slotwidth += 2;
        this.width = this.slotwidth;
        if (this.hasscroll) {
            this.width += 5;
        }
        this.hidden = (totalwidth = this.x + this.width - LayoutManager.dropDown.x) <= 0;
    }

    public void resetHashes() {
        this.sortedtags = ConfigFile.getSortedTagList(this.maintags);
        for (ConfigTag tag : this.sortedtags) {
            ((SubSetRangeTag)tag).resetHashes();
        }
    }

    public void updateState() {
        ItemVisibilityHash vis = NEIConfig.vishash;
        for (ConfigTag tag : this.sortedtags) {
            SubSetRangeTag stag = (SubSetRangeTag)tag;
            stag.updateState(vis);
        }
    }

    public void addItemIfInRange(int item, int damage, ady compound) {
        for (ConfigTag tag : this.sortedtags) {
            ((SubSetRangeTag)tag).addItemIfInRange(item, damage, compound);
        }
    }

    public int getWidthAtLevel(int hiddenlevel) {
        if (hiddenlevel == 0) {
            return this.width;
        }
        for (ConfigTag tag : this.sortedtags) {
            SubSetRangeTag stag = (SubSetRangeTag)tag;
            int subwidth = stag.getWidthAtLevel(hiddenlevel - 1);
            if (subwidth == 0) continue;
            return subwidth;
        }
        return 0;
    }
}

