/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.API;
import codechicken.nei.BrewingRecipeHandler;
import codechicken.nei.FurnaceRecipeHandler;
import codechicken.nei.GuiRecipe;
import codechicken.nei.ICraftingHandler;
import codechicken.nei.ShapedRecipeHandler;
import codechicken.nei.ShapelessRecipeHandler;
import java.util.ArrayList;

public class GuiCraftingRecipe
extends GuiRecipe {
    private ArrayList currenthandlers;
    private static ArrayList recipehandlers = new ArrayList();

    static {
        GuiCraftingRecipe.registerRecipeHandler(new ShapedRecipeHandler());
        GuiCraftingRecipe.registerRecipeHandler(new ShapelessRecipeHandler());
        GuiCraftingRecipe.registerRecipeHandler(new FurnaceRecipeHandler());
        GuiCraftingRecipe.registerRecipeHandler(new BrewingRecipeHandler());
        API.registerGuiOverlay(aen.class, "crafting", 5, 11);
        API.registerGuiOverlay(ain.class, "crafting2x2", 63, 20);
        API.registerGuiOverlay(kv.class, "smelting", 5, 11);
        API.registerGuiOverlay(kv.class, "fuel", 5, 11);
        API.registerGuiOverlay(hg.class, "brewing", 5, 11);
    }

    public GuiCraftingRecipe(aan result, gb prevgui) {
        super(result, prevgui);
    }

    public static void registerRecipeHandler(ICraftingHandler handler) {
        if (!recipehandlers.contains(handler)) {
            recipehandlers.add(handler);
        }
    }

    public static boolean hasRecipe(aan result) {
        for (ICraftingHandler recipehandler : recipehandlers) {
            ICraftingHandler handler = recipehandler.getRecipeHandler(result);
            if (handler.getNumRecipes() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList getCurrentRecipeHandlers() {
        if (this.currenthandlers == null) {
            this.currenthandlers = new ArrayList();
            for (ICraftingHandler recipehandler : recipehandlers) {
                ICraftingHandler handler = recipehandler.getRecipeHandler(this.key);
                if (handler.getNumRecipes() <= 0) continue;
                this.currenthandlers.add(handler);
            }
        }
        return this.currenthandlers;
    }
}

