/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.ReflectionManager;
import codechicken.nei.API;
import codechicken.nei.BrewingRecipeHandler;
import codechicken.nei.InfiniteStackSizeHandler;
import codechicken.nei.InfiniteToolHandler;
import codechicken.nei.ItemHash;
import codechicken.nei.ItemMobSpawner;
import codechicken.nei.MultiItemRange;
import codechicken.nei.NEIUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ItemInfo {
    static final HashMap fallbackNames = new HashMap();
    static final HashSet excludeIds = new HashSet();
    static final HashSet nonUnlimitedIds = new HashSet();
    static final HashMap damageVariants = new HashMap();
    static final ArrayList defaultDamageRange = new ArrayList();
    static final HashMap itemcompounds = new HashMap();
    static final LinkedList tooltipHandlers = new LinkedList();
    static final LinkedList infiniteHandlers = new LinkedList();

    public static boolean isHidden(int itemID) {
        return excludeIds.contains(itemID);
    }

    public static ArrayList getItemDamageVariants(int itemID) {
        ArrayList damages = (ArrayList)damageVariants.get(itemID);
        return damages == null ? defaultDamageRange : damages;
    }

    public static String getOverrideName(int itemID, int itemDamage) {
        ItemHash itemhash = new ItemHash(itemID, itemDamage);
        return (String)fallbackNames.get(itemhash);
    }

    public static boolean canItemBeUnlimited(int itemID) {
        return !nonUnlimitedIds.contains(itemID);
    }

    public static ArrayList getItemCompounds(int itemID) {
        return (ArrayList)itemcompounds.get(itemID);
    }

    public static void load() {
        int[] nArray = new int[2];
        nArray[1] = 15;
        defaultDamageRange.add(nArray);
        ItemInfo.addVanillaBlockProperties();
        ItemInfo.addDefaultDropDowns();
        ItemInfo.searchItems();
        ItemInfo.searchCreativeMenu();
        ItemInfo.addMobSpawnerItem();
        ItemInfo.addSpawnEggs();
        new BrewingRecipeHandler().searchPotions();
        ItemInfo.addInfiniteHandlers();
    }

    private static void addMobSpawnerItem() {
        yr.e[pb.as.bO] = null;
        new ItemMobSpawner(NEIUtils.getMinecraft().f);
        if (ReflectionManager.classExists("forge.IItemRenderer")) {
            try {
                ReflectionManager.callMethod(ReflectionManager.findClass("forge.MinecraftForgeClient"), "registerItemRenderer", pb.as.bO, ReflectionManager.newInstance(ReflectionManager.findClass("codechicken.nei.SpawnerRenderer"), new Object[0]));
            }
            catch (Exception e2) {
                ModLoader.throwException("NEI", e2);
            }
        }
    }

    private static void addInfiniteHandlers() {
        API.addInfiniteItemHandler(new InfiniteStackSizeHandler());
        API.addInfiniteItemHandler(new InfiniteToolHandler());
    }

    private static void searchCreativeMenu() {
        ArrayList creativeItems = mod_NotEnoughItems.getCreativeItemList();
        HashSet<Integer> itemsToDamageCalc = new HashSet<Integer>();
        for (aan item : creativeItems) {
            if (item.n()) {
                API.setMaxDamageException(item.c, -1);
                API.addNBTItem(item);
                continue;
            }
            if (item.i() == 0 || item.c == yr.bs.bQ || item.c == yr.bC.bQ) continue;
            itemsToDamageCalc.add(item.c);
        }
        HashMap<Integer, ArrayList<Integer>> itemDamages = new HashMap<Integer, ArrayList<Integer>>();
        for (aan aan2 : creativeItems) {
            if (!itemsToDamageCalc.contains(aan2.c) || aan2.n()) continue;
            ArrayList<Integer> damages = (ArrayList<Integer>)itemDamages.get(aan2.c);
            if (damages == null) {
                damages = new ArrayList<Integer>();
                itemDamages.put(aan2.c, damages);
            }
            damages.add(aan2.i());
        }
        for (Map.Entry entry : itemDamages.entrySet()) {
            API.setItemDamageVariants((int)((Integer)entry.getKey()), NEIUtils.concatIntegersToRanges((List)entry.getValue()));
        }
    }

    private static void addVanillaBlockProperties() {
        API.setOverrideName(pb.A.bO, 0, "Water Source");
        API.setMaxDamageException(pb.A.bO, 0);
        API.setOverrideName(pb.B.bO, 0, "Water Still");
        API.setMaxDamageException(pb.B.bO, 0);
        API.setOverrideName(pb.C.bO, 0, "Lava Source");
        API.setMaxDamageException(pb.C.bO, 0);
        API.setOverrideName(pb.D.bO, 0, "Lava Still");
        API.setMaxDamageException(pb.D.bO, 0);
        API.setOverrideName(pb.bJ.bO, 0, "White Stone");
        API.setOverrideName(pb.bJ.bO, 0, "White Stone");
        API.setOverrideName(pb.bl.bO, 0, "Silverfish Stone");
        API.setOverrideName(pb.aj.bO, 0, "Double Slab");
        API.setOverrideName(pb.aj.bO, 1, "Double Sandstone Slab");
        API.setOverrideName(pb.aj.bO, 2, "Double Wooden Slab");
        API.setOverrideName(pb.aj.bO, 3, "Double Cobblestone Slab");
        API.setOverrideName(pb.aj.bO, 4, "Double Bricks Slab");
        API.setOverrideName(pb.aj.bO, 5, "Double Stone Bricks Slab");
        API.setOverrideName(pb.by.bO, 0, "Mycelium");
        API.setOverrideName(pb.bz.bO, 0, "Lily Pad");
        API.setOverrideName(pb.bH.bO, 0, "End Portal");
        API.setOverrideName(pb.bI.bO, 0, "End Portal Frame");
        API.setOverrideName(pb.bJ.bO, 0, "White Stone");
        API.hideItem(pb.S.bO);
        API.hideItem(pb.av.bO);
        API.hideItem(pb.az.bO);
        API.hideItem(pb.aD.bO);
        API.hideItem(pb.aE.bO);
        API.hideItem(pb.aI.bO);
        API.hideItem(pb.aL.bO);
        API.hideItem(pb.aO.bO);
        API.hideItem(pb.aP.bO);
        API.hideItem(pb.aX.bO);
        API.hideItem(pb.bh.bO);
        API.hideItem(pb.bi.bO);
        API.hideItem(pb.bG.bO);
    }

    private static void addDefaultDropDowns() {
        API.addSetRange("Blocks", new MultiItemRange("[0-32000]"){

            @Override
            public void addItemIfInRange(int item, int damage, ady compound) {
                if (item < pb.m.length && pb.m[item] != null) {
                    super.addItemIfInRange(item, damage, compound);
                }
            }
        });
        API.addSetRange("Items", new MultiItemRange("[0-32000]"){

            @Override
            public void addItemIfInRange(int item, int damage, ady compound) {
                if (item >= pb.m.length || pb.m[item] == null) {
                    super.addItemIfInRange(item, damage, compound);
                }
            }
        });
        API.addSetRange("Vanilla.Blocks", new MultiItemRange("[1-124]"));
        API.addSetRange("Blocks.MobSpawners", new MultiItemRange("[52]"));
        API.addSetRange("Vanilla.Items", new MultiItemRange("[256-385],[2256-2266]"));
    }

    private static void searchItems() {
        MultiItemRange tools = new MultiItemRange();
        MultiItemRange picks = new MultiItemRange();
        MultiItemRange shovels = new MultiItemRange();
        MultiItemRange axes = new MultiItemRange();
        MultiItemRange hoes = new MultiItemRange();
        MultiItemRange swords = new MultiItemRange();
        MultiItemRange chest = new MultiItemRange();
        MultiItemRange helmets = new MultiItemRange();
        MultiItemRange legs = new MultiItemRange();
        MultiItemRange boots = new MultiItemRange();
        MultiItemRange other = new MultiItemRange();
        MultiItemRange ranged = new MultiItemRange();
        MultiItemRange food = new MultiItemRange();
        MultiItemRange potioningredients = new MultiItemRange();
        yr[] yrArray = yr.e;
        int n2 = yr.e.length;
        int n3 = 0;
        while (n3 < n2) {
            yr item = yrArray[n3];
            if (item != null) {
                if (item.i()) {
                    tools.add(item);
                    if (item instanceof au) {
                        picks.add(item);
                    } else if (item instanceof akd) {
                        shovels.add(item);
                    } else if (item instanceof nx) {
                        axes.add(item);
                    } else if (item instanceof ic) {
                        hoes.add(item);
                    } else if (item instanceof lx) {
                        swords.add(item);
                    } else if (item instanceof ql) {
                        switch (((ql)item).a) {
                            case 0: {
                                helmets.add(item);
                                break;
                            }
                            case 1: {
                                chest.add(item);
                                break;
                            }
                            case 2: {
                                legs.add(item);
                                break;
                            }
                            case 3: {
                                boots.add(item);
                            }
                        }
                    } else if (item == yr.l || item == yr.k) {
                        ranged.add(item);
                    } else if (item == yr.aR || item == yr.i || item == yr.be) {
                        other.add(item);
                    }
                }
                if (item instanceof amm) {
                    food.add(item);
                }
                if (item.p()) {
                    BrewingRecipeHandler.ingredientIDs.add(item.bQ);
                    potioningredients.add(item);
                }
            }
            ++n3;
        }
        API.addSetRange("Items.Tools.Pickaxes", picks);
        API.addSetRange("Items.Tools.Shovels", shovels);
        API.addSetRange("Items.Tools.Axes", axes);
        API.addSetRange("Items.Tools.Hoes", hoes);
        API.addSetRange("Items.Tools.Other", other);
        API.addSetRange("Items.Weapons.Swords", swords);
        API.addSetRange("Items.Weapons.Ranged", ranged);
        API.addSetRange("Items.Armor.ChestPlates", chest);
        API.addSetRange("Items.Armor.Leggings", legs);
        API.addSetRange("Items.Armor.Helmets", helmets);
        API.addSetRange("Items.Armor.Boots", boots);
        API.addSetRange("Items.Food", food);
        API.addSetRange("Items.Potions.Ingredients", potioningredients);
    }

    private static void addSpawnEggs() {
        ArrayList<Integer> damages = new ArrayList<Integer>();
        try {
            HashMap classToIDMapping = (HashMap)ModLoader.getPrivateValue(aao.class, null, 3);
            damages.add((Integer)classToIDMapping.get(of.class));
            damages.add((Integer)classToIDMapping.get(xr.class));
            damages.add((Integer)classToIDMapping.get(yd.class));
            damages.add((Integer)classToIDMapping.get(aja.class));
            damages.add((Integer)classToIDMapping.get(ajg.class));
            damages.add((Integer)classToIDMapping.get(cb.class));
            damages.add((Integer)classToIDMapping.get(rd.class));
            damages.add((Integer)classToIDMapping.get(fn.class));
            damages.add((Integer)classToIDMapping.get(un.class));
            damages.add((Integer)classToIDMapping.get(jg.class));
            damages.add((Integer)classToIDMapping.get(yo.class));
            damages.add((Integer)classToIDMapping.get(alt.class));
            damages.add((Integer)classToIDMapping.get(all.class));
            damages.add((Integer)classToIDMapping.get(ui.class));
            damages.add((Integer)classToIDMapping.get(aic.class));
            damages.add((Integer)classToIDMapping.get(cu.class));
            damages.add((Integer)classToIDMapping.get(adg.class));
            damages.add((Integer)classToIDMapping.get(ed.class));
            damages.add((Integer)classToIDMapping.get(qn.class));
            damages.add((Integer)classToIDMapping.get(qr.class));
            damages.add((Integer)classToIDMapping.get(uo.class));
            ItemInfo.addEntityEgg(damages, (Integer)classToIDMapping.get(q.class), 0xEEFFFF, 16753185);
            ItemInfo.addEntityEgg(damages, (Integer)classToIDMapping.get(tl.class), 12960449, 16769484);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        API.setItemDamageVariants(yr.bC.bQ, damages);
    }

    private static void addEntityEgg(ArrayList damages, Integer ID2, int i2, int j2) {
        damages.add(ID2);
        aao.a.put(ID2, new hr(ID2, i2, j2));
    }
}

