/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.DefaultOverlayRenderer;
import codechicken.nei.GuiManager;
import codechicken.nei.ICraftingHandler;
import codechicken.nei.IRecipeOverlayRenderer;
import codechicken.nei.IUsageHandler;
import codechicken.nei.PositionedStack;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;

public abstract class TemplateRecipeHandler
implements ICraftingHandler,
IUsageHandler {
    public int cycleticks = Math.abs((int)System.currentTimeMillis());
    public ArrayList arecipes = new ArrayList();

    @Override
    public abstract String getRecipeName();

    public abstract void loadCraftingRecipes(aan var1);

    public abstract void loadUsageRecipes(aan var1);

    public abstract String getGuiTexture();

    public String getOverlayIdentifier() {
        return "";
    }

    public void drawExtras(GuiManager gui, int recipe) {
    }

    public void drawProgressBar(GuiManager gui, int x2, int y2, int tx2, int ty2, int w2, int h2, int ticks, int direction) {
        this.drawProgressBar(gui, x2, y2, tx2, ty2, w2, h2, (float)(this.cycleticks % ticks) / (float)ticks, direction);
    }

    public void drawProgressBar(GuiManager gui, int x2, int y2, int tx2, int ty2, int w2, int h2, float completion, int direction) {
        if (direction > 3) {
            completion = 1.0f - completion;
            direction %= 4;
        }
        int var = (int)(completion * (float)(direction % 2 == 0 ? w2 : h2));
        switch (direction) {
            case 0: {
                gui.drawTexturedModalRect(x2, y2, tx2, ty2, var, h2);
                break;
            }
            case 1: {
                gui.drawTexturedModalRect(x2, y2, tx2, ty2, w2, var);
                break;
            }
            case 2: {
                gui.drawTexturedModalRect(x2 + w2 - var, y2, tx2 + w2 - var, ty2, var, h2);
                break;
            }
            case 3: {
                gui.drawTexturedModalRect(x2, y2 + h2 - var, tx2, ty2 + h2 - var, w2, var);
            }
        }
    }

    private TemplateRecipeHandler newInstance() {
        try {
            return (TemplateRecipeHandler)this.getClass().newInstance();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public ICraftingHandler getRecipeHandler(aan result) {
        TemplateRecipeHandler handler = this.newInstance();
        handler.loadCraftingRecipes(result);
        return handler;
    }

    @Override
    public IUsageHandler getUsageHandler(aan ingredient) {
        TemplateRecipeHandler handler = this.newInstance();
        handler.loadUsageRecipes(ingredient);
        return handler;
    }

    @Override
    public int getNumRecipes() {
        return this.arecipes.size();
    }

    @Override
    public void drawBackground(GuiManager gui, int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.bindTextureByName(this.getGuiTexture());
        gui.drawTexturedModalRect(0, 0, 5, 11, 166, 65);
    }

    @Override
    public void drawForeground(GuiManager gui, int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.bindTextureByName(this.getGuiTexture());
        this.drawExtras(gui, recipe);
    }

    @Override
    public ArrayList getIngredientStacks(int recipe) {
        return ((CachedRecipe)this.arecipes.get(recipe)).getIngredients();
    }

    @Override
    public PositionedStack getResultStack(int recipe) {
        return ((CachedRecipe)this.arecipes.get(recipe)).getResult();
    }

    @Override
    public ArrayList getOtherStacks(int recipe) {
        return ((CachedRecipe)this.arecipes.get(recipe)).getOtherStacks();
    }

    @Override
    public void onUpdate() {
        ++this.cycleticks;
    }

    @Override
    public boolean hasOverlay(gb gui, dd container, int recipe) {
        return DefaultOverlayRenderer.getOverlayIdent(gui).equals(this.getOverlayIdentifier());
    }

    @Override
    public IRecipeOverlayRenderer getOverlayRenderer(gb gui, int recipe) {
        return new DefaultOverlayRenderer(this.getIngredientStacks(recipe), gui);
    }

    public abstract class CachedRecipe {
        public abstract PositionedStack getResult();

        public ArrayList getIngredients() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            PositionedStack stack = this.getIngredient();
            if (stack != null) {
                stacks.add(stack);
            }
            return stacks;
        }

        public PositionedStack getIngredient() {
            return null;
        }

        public ArrayList getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            PositionedStack stack = this.getOtherStack();
            if (stack != null) {
                stacks.add(stack);
            }
            return stacks;
        }

        public PositionedStack getOtherStack() {
            return null;
        }
    }
}

