/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.IKeyHandler;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.ProxyInjector;
import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.SingleIntervalHandler;
import cpw.mods.fml.common.TickType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FMLCommonHandler {
    private static final FMLCommonHandler INSTANCE = new FMLCommonHandler();
    private static final Pattern metadataFile = Pattern.compile("$/modinfo.json$");
    private Map<ModContainer, Set<String>> channelList = new HashMap<ModContainer, Set<String>>();
    private Map<String, ModContainer> modChannels = new HashMap<String, ModContainer>();
    private Map<Object, Set<String>> activeChannels = new HashMap<Object, Set<String>>();
    private IFMLSidedHandler sidedDelegate;
    private int uniqueEntityListId = 220;
    private List<ModContainer> auxilliaryContainers = new ArrayList<ModContainer>();
    private Map<String, Properties> modLanguageData = new HashMap<String, Properties>();
    private PriorityQueue<TickQueueElement> tickHandlers = new PriorityQueue();
    private List<IScheduledTickHandler> scheduledTicks = new ArrayList<IScheduledTickHandler>();
    private Set<IWorldGenerator> worldGenerators = new HashSet<IWorldGenerator>();
    private Class<?> forge;
    private boolean noForge;

    public void beginLoading(IFMLSidedHandler handler) {
        this.sidedDelegate = handler;
        this.getFMLLogger().info("Attempting early MinecraftForge initialization");
        this.callForgeMethod("initialize");
        this.getFMLLogger().info("Completed early MinecraftForge initialization");
    }

    public void rescheduleTicks() {
        this.sidedDelegate.profileStart("modTickScheduling");
        ++TickQueueElement.tickCounter;
        this.scheduledTicks.clear();
        while (this.tickHandlers.size() != 0 && this.tickHandlers.peek().scheduledNow()) {
            TickQueueElement tickQueueElement = this.tickHandlers.poll();
            tickQueueElement.update();
            this.tickHandlers.offer(tickQueueElement);
            this.scheduledTicks.add(tickQueueElement.ticker);
        }
        this.sidedDelegate.profileEnd();
    }

    public void tickStart(EnumSet<TickType> ticks, Object ... data) {
        if (this.scheduledTicks.size() == 0) {
            return;
        }
        this.sidedDelegate.profileStart("modTickStart$" + ticks);
        for (IScheduledTickHandler ticker : this.scheduledTicks) {
            EnumSet<TickType> ticksToRun = EnumSet.copyOf(ticker.ticks());
            ticksToRun.removeAll(EnumSet.complementOf(ticks));
            if (ticksToRun.isEmpty()) continue;
            this.sidedDelegate.profileStart(ticker.getLabel());
            ticker.tickStart(ticksToRun, data);
            this.sidedDelegate.profileEnd();
        }
        this.sidedDelegate.profileEnd();
    }

    public void tickEnd(EnumSet<TickType> ticks, Object ... data) {
        if (this.scheduledTicks.size() == 0) {
            return;
        }
        this.sidedDelegate.profileStart("modTickEnd$" + ticks);
        for (IScheduledTickHandler ticker : this.scheduledTicks) {
            EnumSet<TickType> ticksToRun = EnumSet.copyOf(ticker.ticks());
            ticksToRun.removeAll(EnumSet.complementOf(ticks));
            if (ticksToRun.isEmpty()) continue;
            this.sidedDelegate.profileStart(ticker.getLabel());
            ticker.tickEnd(ticksToRun, data);
            this.sidedDelegate.profileEnd();
        }
        this.sidedDelegate.profileEnd();
    }

    public List<IKeyHandler> gatherKeyBindings() {
        ArrayList<IKeyHandler> allKeys = new ArrayList<IKeyHandler>();
        for (ModContainer mod : Loader.getModList()) {
            allKeys.addAll(mod.getKeys());
        }
        for (ModContainer mod : this.auxilliaryContainers) {
            allKeys.addAll(mod.getKeys());
        }
        return allKeys;
    }

    public static FMLCommonHandler instance() {
        return INSTANCE;
    }

    public ModContainer findContainerFor(Object mod) {
        for (ModContainer mc2 : Loader.getModList()) {
            if (!mc2.matches(mod)) continue;
            return mc2;
        }
        return null;
    }

    public ModContainer getModForChannel(String channel) {
        return this.modChannels.get(channel);
    }

    public Set<String> getChannelListFor(ModContainer container) {
        return this.channelList.get(container);
    }

    public void registerChannel(ModContainer container, String channelName) {
        Set<String> list;
        if (this.modChannels.containsKey(channelName)) {
            // empty if block
        }
        if ((list = this.channelList.get(container)) == null) {
            list = new HashSet<String>();
            this.channelList.put(container, list);
        }
        list.add(channelName);
        this.modChannels.put(channelName, container);
    }

    public void activateChannel(Object player, String channel) {
        Set<String> active = this.activeChannels.get(player);
        if (active == null) {
            active = new HashSet<String>();
            this.activeChannels.put(player, active);
        }
        active.add(channel);
    }

    public void deactivateChannel(Object player, String channel) {
        Set<String> active = this.activeChannels.get(player);
        if (active == null) {
            active = new HashSet<String>();
            this.activeChannels.put(player, active);
        }
        active.remove(channel);
    }

    public byte[] getPacketRegistry() {
        StringBuffer sb2 = new StringBuffer();
        for (String chan : this.modChannels.keySet()) {
            sb2.append(chan).append("\u0000");
        }
        try {
            return sb2.toString().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e2) {
            Loader.log.warning("Error building registration list");
            Loader.log.throwing("FMLHooks", "getPacketRegistry", e2);
            return new byte[0];
        }
    }

    public boolean isChannelActive(String channel, Object player) {
        return this.activeChannels.get(player).contains(channel);
    }

    public Logger getFMLLogger() {
        return Loader.log;
    }

    public Logger getMinecraftLogger() {
        if (this.sidedDelegate == null) {
            throw new RuntimeException("sidedDelegate null when attempting to getMinecraftLogger, this is generally caused by you not installing FML properly, or installing some other mod that edits Minecraft.class on top of FML such as ModLoader, do not do this. Reinstall FML properly and try again.");
        }
        return this.sidedDelegate.getMinecraftLogger();
    }

    public boolean isModLoaderMod(Class<?> clazz) {
        return this.sidedDelegate.isModLoaderMod(clazz);
    }

    public ModContainer loadBaseModMod(Class<?> clazz, File canonicalFile) {
        return this.sidedDelegate.loadBaseModMod(clazz, canonicalFile);
    }

    public File getMinecraftRootDirectory() {
        return this.sidedDelegate.getMinecraftRootDirectory();
    }

    public Object getMinecraftInstance() {
        return this.sidedDelegate.getMinecraftInstance();
    }

    public int nextUniqueEntityListId() {
        return this.uniqueEntityListId++;
    }

    public void addStringLocalization(String key, String lang, String value) {
        Properties langPack = this.modLanguageData.get(lang);
        if (langPack == null) {
            langPack = new Properties();
            this.modLanguageData.put(lang, langPack);
        }
        langPack.put(key, value);
        this.handleLanguageLoad(this.sidedDelegate.getCurrentLanguageTable(), lang);
    }

    public void handleLanguageLoad(Properties languagePack, String lang) {
        Properties langPack;
        Properties usPack = this.modLanguageData.get("en_US");
        if (usPack != null) {
            languagePack.putAll((Map<?, ?>)usPack);
        }
        if ((langPack = this.modLanguageData.get(lang)) == null) {
            return;
        }
        languagePack.putAll((Map<?, ?>)langPack);
    }

    public Side getSide() {
        return this.sidedDelegate.getSide();
    }

    public void addAuxilliaryModContainer(ModContainer ticker) {
        this.auxilliaryContainers.add(ticker);
    }

    public int fuelLookup(int itemId, int itemDamage) {
        int fv2 = 0;
        for (ModContainer mod : Loader.getModList()) {
            fv2 = Math.max(fv2, mod.lookupFuelValue(itemId, itemDamage));
        }
        return fv2;
    }

    public void addNameForObject(Object minecraftObject, String lang, String name) {
        String label = this.sidedDelegate.getObjectName(minecraftObject);
        this.addStringLocalization(label, lang, name);
    }

    public void raiseException(Throwable exception, String message, boolean stopGame) {
        FMLCommonHandler.instance().getFMLLogger().throwing("FMLHandler", "raiseException", exception);
        if (stopGame) {
            this.getSidedDelegate().haltGame(message, exception);
        }
    }

    private Class<?> findMinecraftForge() {
        if (this.forge == null && !this.noForge) {
            try {
                this.forge = Class.forName("forge.MinecraftForge");
            }
            catch (Exception ex2) {
                try {
                    this.forge = Class.forName("forge.MinecraftForge");
                }
                catch (Exception ex22) {
                    this.noForge = true;
                }
            }
        }
        return this.forge;
    }

    private Object callForgeMethod(String method) {
        if (this.noForge) {
            return null;
        }
        try {
            return this.findMinecraftForge().getMethod(method, new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e2) {
            return null;
        }
    }

    public String[] getBrandingStrings(String mcVersion) {
        ArrayList<String> brandings = new ArrayList<String>();
        brandings.add(mcVersion);
        brandings.add(Loader.instance().getFMLVersionString());
        String forgeVersion = (String)this.callForgeMethod("getVersionString");
        if (forgeVersion != null) {
            brandings.add(forgeVersion);
        }
        brandings.addAll(this.sidedDelegate.getAdditionalBrandingInformation());
        try {
            Properties props = new Properties();
            props.load(FMLCommonHandler.class.getClassLoader().getResourceAsStream("fmlbranding.properties"));
            brandings.add(props.getProperty("fmlbranding"));
        }
        catch (Exception ex2) {
            // empty catch block
        }
        brandings.add(String.format("%d mod%s loaded", Loader.getModList().size(), Loader.getModList().size() != 1 ? "s" : ""));
        Collections.reverse(brandings);
        return brandings.toArray(new String[brandings.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMetadataFor(ModContainer mod) {
        if (mod.getSourceType() == ModContainer.SourceType.JAR) {
            ZipFile jar = null;
            try {
                jar = new ZipFile(mod.getSource());
                ZipEntry infoFile = jar.getEntry("mcmod.info");
                if (infoFile != null) {
                    InputStream input = jar.getInputStream(infoFile);
                    ModMetadata data = this.sidedDelegate.readMetadataFrom(input, mod);
                    mod.setMetadata(data);
                }
                this.getFMLLogger().fine(String.format("Failed to find mcmod.info file in %s for %s", mod.getSource().getName(), mod.getName()));
            }
            catch (Exception e2) {
                this.getFMLLogger().fine(String.format("Failed to find mcmod.info file in %s for %s", mod.getSource().getName(), mod.getName()));
                this.getFMLLogger().throwing("FMLCommonHandler", "loadMetadataFor", e2);
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e3) {}
                }
            }
        } else {
            try {
                InputStream input = Loader.instance().getModClassLoader().getResourceAsStream(mod.getName() + ".info");
                if (input == null) {
                    input = Loader.instance().getModClassLoader().getResourceAsStream("net/minecraft/src/" + mod.getName() + ".info");
                }
                if (input != null) {
                    ModMetadata data = this.sidedDelegate.readMetadataFrom(input, mod);
                    mod.setMetadata(data);
                }
            }
            catch (Exception e4) {
                this.getFMLLogger().fine(String.format("Failed to find %s.info file in %s for %s", mod.getName(), mod.getSource().getName(), mod.getName()));
                this.getFMLLogger().throwing("FMLCommonHandler", "loadMetadataFor", e4);
            }
        }
    }

    public IFMLSidedHandler getSidedDelegate() {
        return this.sidedDelegate;
    }

    public void injectSidedProxyDelegate(ModContainer mod) {
        ProxyInjector injector = mod.findSidedProxy();
        if (injector != null) {
            injector.inject(mod, this.sidedDelegate.getSide());
        }
    }

    public void handleWorldGeneration(int chunkX, int chunkZ, long worldSeed, Object ... data) {
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        fmlRandom.setSeed(xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed);
        for (IWorldGenerator generator : this.worldGenerators) {
            generator.generate(fmlRandom, chunkX, chunkZ, data);
        }
    }

    public void registerTickHandler(ITickHandler handler) {
        this.registerScheduledTickHandler(new SingleIntervalHandler(handler));
    }

    public void registerScheduledTickHandler(IScheduledTickHandler handler) {
        this.tickHandlers.add(new TickQueueElement(handler));
    }

    public void registerWorldGenerator(IWorldGenerator generator) {
        this.worldGenerators.add(generator);
    }

    private static class TickQueueElement
    implements Comparable<TickQueueElement> {
        static long tickCounter = 0L;
        private long next;
        private IScheduledTickHandler ticker;

        public TickQueueElement(IScheduledTickHandler ticker) {
            this.ticker = ticker;
            this.update();
        }

        @Override
        public int compareTo(TickQueueElement o2) {
            return (int)(this.next - o2.next);
        }

        public void update() {
            this.next = tickCounter + (long)Math.max(this.ticker.nextTickSpacing(), 1);
        }

        public boolean scheduledNow() {
            return tickCounter >= this.next;
        }
    }
}

