/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.modloader;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.modloader.BaseMod;
import java.util.EnumSet;

public class BaseModTicker
implements ITickHandler {
    private BaseMod mod;
    private EnumSet<TickType> ticks;
    private boolean clockTickTrigger;
    private boolean sendGuiTicks;

    BaseModTicker(BaseMod mod, boolean guiTicker) {
        this.mod = mod;
        this.ticks = EnumSet.of(TickType.WORLDLOAD);
        this.sendGuiTicks = guiTicker;
    }

    BaseModTicker(EnumSet<TickType> ticks, boolean guiTicker) {
        this.ticks = ticks;
        this.sendGuiTicks = guiTicker;
    }

    @Override
    public void tickStart(EnumSet<TickType> types, Object ... tickData) {
        this.tickBaseMod(types, false, tickData);
    }

    @Override
    public void tickEnd(EnumSet<TickType> types, Object ... tickData) {
        this.tickBaseMod(types, true, tickData);
    }

    private void tickBaseMod(EnumSet<TickType> types, boolean end, Object ... tickData) {
        if (FMLCommonHandler.instance().getSide().isClient() && (this.ticks.contains((Object)TickType.GAME) || this.ticks.contains((Object)TickType.WORLDLOAD))) {
            EnumSet<TickType> cTypes = EnumSet.copyOf(types);
            if (end && types.contains((Object)TickType.GAME) || types.contains((Object)TickType.WORLDLOAD)) {
                this.clockTickTrigger = true;
                cTypes.remove((Object)TickType.GAME);
                cTypes.remove((Object)TickType.WORLDLOAD);
            }
            if (end && this.clockTickTrigger && types.contains((Object)TickType.RENDER)) {
                this.clockTickTrigger = false;
                cTypes.remove((Object)TickType.RENDER);
                cTypes.add(TickType.GAME);
            }
            this.sendTick(cTypes, end, tickData);
        } else {
            this.sendTick(types, end, tickData);
        }
    }

    private void sendTick(EnumSet<TickType> types, boolean end, Object ... tickData) {
        for (TickType type : types) {
            if (!this.ticks.contains((Object)type)) continue;
            boolean keepTicking = true;
            keepTicking = this.sendGuiTicks ? this.mod.doTickInGUI(type, end, FMLCommonHandler.instance().getMinecraftInstance(), tickData) : this.mod.doTickInGame(type, end, FMLCommonHandler.instance().getMinecraftInstance(), tickData);
            if (keepTicking) continue;
            this.ticks.remove((Object)type);
            this.ticks.removeAll(type.partnerTicks());
        }
    }

    @Override
    public EnumSet<TickType> ticks() {
        return this.clockTickTrigger ? EnumSet.of(TickType.RENDER) : this.ticks;
    }

    @Override
    public String getLabel() {
        return this.mod.getClass().getSimpleName();
    }

    public void setMod(BaseMod mod) {
        this.mod = mod;
    }
}

