/*
 * Decompiled with CFR 0.152.
 */
package wecui;

import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import wecui.InitializationFactory;
import wecui.WorldEditCUI;
import wecui.exception.InitializationException;
import wecui.obfuscation.Obfuscation;
import wecui.util.ConsoleLogFormatter;

public class CUIDebug
implements InitializationFactory {
    protected WorldEditCUI controller;
    protected File debugFile;
    protected boolean debugMode = false;
    protected static final Logger logger = Logger.getLogger("WorldEditCUI");

    public CUIDebug(WorldEditCUI controller) {
        this.controller = controller;
    }

    public void initialize() throws InitializationException {
        ConsoleLogFormatter formatter = new ConsoleLogFormatter();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(formatter);
        logger.setUseParentHandlers(false);
        logger.addHandler(handler);
        try {
            this.debugFile = new File(Obfuscation.getWorldEditCUIDir(), "WorldEditCUI-debug.txt");
            this.debugMode = this.controller.getConfiguration().isDebugMode();
            if (this.debugMode) {
                FileHandler newHandler = new FileHandler(this.debugFile.getAbsolutePath());
                newHandler.setFormatter(formatter);
                logger.addHandler(newHandler);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace(System.err);
            throw new InitializationException();
        }
    }

    public void debug(String message) {
        if (this.debugMode) {
            logger.info("WorldEditCUI Debug - " + message);
        }
    }

    public void info(String message) {
        logger.info(message);
    }

    public void info(String message, Throwable e2) {
        logger.log(Level.INFO, message, e2);
    }
}

