/*
 * Decompiled with CFR 0.152.
 */
package wecui;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import wecui.WorldEditCUI;
import wecui.config.ConfigurationNode;
import wecui.exception.ConfigurationException;
import wecui.util.ChatColor;
import wecui.vendor.org.yaml.snakeyaml.Yaml;
import wecui.vendor.org.yaml.snakeyaml.reader.UnicodeReader;

public class Updater
extends Thread {
    protected WorldEditCUI controller;
    protected final int updaterVersion = 1;

    public Updater(WorldEditCUI controller) {
        this.controller = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        InputStream is2 = null;
        ConfigurationNode node = new ConfigurationNode(new HashMap<String, Object>());
        try {
            URL url = new URL(this.controller.getConfiguration().getUpdateFile());
            url.openConnection();
            is2 = url.openStream();
            Yaml yaml = new Yaml();
            Object out = yaml.load(new UnicodeReader(is2));
            try {
                if (null != out) {
                    node.setRoot((Map)out);
                }
            }
            catch (ClassCastException e2) {
                throw new ConfigurationException("Root document must be an key-value structure");
            }
            String currentVersion = node.getString("updaterVersion" + this.updaterVersion + ".current");
            List<String> supportedVersions = node.getStringList("updaterVersion" + this.updaterVersion + ".supported", new ArrayList<String>());
            if (!(currentVersion == null || currentVersion.equals("1.2.5") || (currentVersion + "beta").equals("1.2.5") || supportedVersions == null || supportedVersions.contains("1.2.5"))) {
                this.controller.getObfuscation().showChatMessage((Object)((Object)ChatColor.RED) + "Your WorldEditCUI version is out of date! ");
                this.controller.getObfuscation().showChatMessage((Object)((Object)ChatColor.RED) + "The latest version is " + currentVersion + ". http://bit.ly/wecui");
            }
        }
        catch (Exception e3) {
            this.controller.getDebugger().info("Error in fetching update file!", e3);
        }
        finally {
            if (is2 != null) {
                try {
                    is2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

