/*
 * Decompiled with CFR 0.152.
 */
package wecui.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import wecui.config.ConfigurationNode;
import wecui.config.EmptyNullRepresenter;
import wecui.exception.ConfigurationException;
import wecui.vendor.org.yaml.snakeyaml.DumperOptions;
import wecui.vendor.org.yaml.snakeyaml.Yaml;
import wecui.vendor.org.yaml.snakeyaml.constructor.SafeConstructor;
import wecui.vendor.org.yaml.snakeyaml.reader.UnicodeReader;

public class Configuration
extends ConfigurationNode {
    private Yaml yaml;
    private File file;
    private String header = null;

    public Configuration(File file) {
        super(new HashMap<String, Object>());
        DumperOptions options = new DumperOptions();
        options.setIndent(4);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yaml = new Yaml(new SafeConstructor(), new EmptyNullRepresenter(), options);
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(this.file);
            this.read(this.yaml.load(new UnicodeReader(stream)));
        }
        catch (IOException e2) {
            this.root = new HashMap();
        }
        catch (ConfigurationException e3) {
            this.root = new HashMap();
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e4) {}
        }
    }

    public void setHeader(String ... headerLines) {
        StringBuilder headerTemp = new StringBuilder();
        for (String line : headerLines) {
            if (headerTemp.length() > 0) {
                headerTemp.append("\r\n");
            }
            headerTemp.append(line);
        }
        this.setHeader(headerTemp.toString());
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        FileOutputStream stream = null;
        File parent = this.file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        try {
            stream = new FileOutputStream(this.file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
            if (this.header != null) {
                writer.append(this.header);
                writer.append("\r\n");
            }
            this.yaml.dump(this.root, writer);
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException e2) {
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e3) {}
        }
        return false;
    }

    private void read(Object input) throws ConfigurationException {
        try {
            this.root = null == input ? new HashMap() : (Map)input;
        }
        catch (ClassCastException e2) {
            throw new ConfigurationException("Root document must be an key-value structure");
        }
    }

    public static ConfigurationNode getEmptyNode() {
        return new ConfigurationNode(new HashMap<String, Object>());
    }
}

