/*
 * Decompiled with CFR 0.152.
 */
package wecui.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationNode {
    protected Map<String, Object> root;

    public ConfigurationNode(Map<String, Object> root) {
        this.root = root;
    }

    public Object getProperty(String path) {
        if (!path.contains(".")) {
            Object val = this.root.get(path);
            if (val == null) {
                return null;
            }
            return val;
        }
        String[] parts = path.split("\\.");
        Map node = this.root;
        for (int i2 = 0; i2 < parts.length; ++i2) {
            Object o2 = node.get(parts[i2]);
            if (o2 == null) {
                return null;
            }
            if (i2 == parts.length - 1) {
                return o2;
            }
            try {
                node = (Map)o2;
                continue;
            }
            catch (ClassCastException e2) {
                return null;
            }
        }
        return null;
    }

    public void setProperty(String path, Object value) {
        if (!path.contains(".")) {
            this.root.put(path, value);
            return;
        }
        String[] parts = path.split("\\.");
        Map node = this.root;
        for (int i2 = 0; i2 < parts.length; ++i2) {
            HashMap o2 = node.get(parts[i2]);
            if (i2 == parts.length - 1) {
                node.put((String)parts[i2], (Object)value);
                return;
            }
            if (o2 == null || !(o2 instanceof Map)) {
                o2 = new HashMap();
                node.put(parts[i2], o2);
            }
            node = o2;
        }
    }

    public String getString(String path) {
        Object o2 = this.getProperty(path);
        if (o2 == null) {
            return null;
        }
        return o2.toString();
    }

    public String getString(String path, String def) {
        String o2 = this.getString(path);
        if (o2 == null) {
            return def;
        }
        return o2;
    }

    public int getInt(String path, int def) {
        Integer o2 = ConfigurationNode.castInt(this.getProperty(path));
        if (o2 == null) {
            return def;
        }
        return o2;
    }

    public double getDouble(String path, double def) {
        Double o2 = ConfigurationNode.castDouble(this.getProperty(path));
        if (o2 == null) {
            return def;
        }
        return o2;
    }

    public boolean getBoolean(String path, boolean def) {
        Boolean o2 = ConfigurationNode.castBoolean(this.getProperty(path));
        if (o2 == null) {
            return def;
        }
        return o2;
    }

    public List<String> getKeys(String path) {
        if (path == null) {
            return new ArrayList<String>(this.root.keySet());
        }
        Object o2 = this.getProperty(path);
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof Map) {
            return new ArrayList<String>(((Map)o2).keySet());
        }
        return null;
    }

    public List<Object> getList(String path) {
        Object o2 = this.getProperty(path);
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof List) {
            return (List)o2;
        }
        return null;
    }

    public List<String> getStringList(String path, List<String> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object o2 : raw) {
            if (o2 == null) continue;
            list.add(o2.toString());
        }
        return list;
    }

    public List<Integer> getIntList(String path, List<Integer> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Object o2 : raw) {
            Integer i2 = ConfigurationNode.castInt(o2);
            if (i2 == null) continue;
            list.add(i2);
        }
        return list;
    }

    public List<Double> getDoubleList(String path, List<Double> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<Double> list = new ArrayList<Double>();
        for (Object o2 : raw) {
            Double i2 = ConfigurationNode.castDouble(o2);
            if (i2 == null) continue;
            list.add(i2);
        }
        return list;
    }

    public List<Boolean> getBooleanList(String path, List<Boolean> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        for (Object o2 : raw) {
            Boolean tetsu = ConfigurationNode.castBoolean(o2);
            if (tetsu == null) continue;
            list.add(tetsu);
        }
        return list;
    }

    public List<ConfigurationNode> getNodeList(String path, List<ConfigurationNode> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<ConfigurationNode> list = new ArrayList<ConfigurationNode>();
        for (Object o2 : raw) {
            if (!(o2 instanceof Map)) continue;
            list.add(new ConfigurationNode((Map)o2));
        }
        return list;
    }

    public ConfigurationNode getNode(String path) {
        Object raw = this.getProperty(path);
        if (raw instanceof Map) {
            return new ConfigurationNode((Map)raw);
        }
        return null;
    }

    public Map<String, ConfigurationNode> getNodes(String path) {
        Object o2 = this.getProperty(path);
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof Map) {
            HashMap<String, ConfigurationNode> nodes = new HashMap<String, ConfigurationNode>();
            for (Map.Entry entry : ((Map)o2).entrySet()) {
                if (!(entry.getValue() instanceof Map)) continue;
                nodes.put((String)entry.getKey(), new ConfigurationNode((Map)entry.getValue()));
            }
            return nodes;
        }
        return null;
    }

    private static Integer castInt(Object o2) {
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof Byte) {
            return (int)((Byte)o2);
        }
        if (o2 instanceof Integer) {
            return (Integer)o2;
        }
        if (o2 instanceof Double) {
            return (int)((Double)o2).doubleValue();
        }
        if (o2 instanceof Float) {
            return (int)((Float)o2).floatValue();
        }
        if (o2 instanceof Long) {
            return (int)((Long)o2).longValue();
        }
        return null;
    }

    private static Double castDouble(Object o2) {
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof Float) {
            return ((Float)o2).floatValue();
        }
        if (o2 instanceof Double) {
            return (Double)o2;
        }
        if (o2 instanceof Byte) {
            return (double)((Byte)o2);
        }
        if (o2 instanceof Integer) {
            return (double)((Integer)o2);
        }
        if (o2 instanceof Long) {
            return (double)((Long)o2);
        }
        return null;
    }

    private static Boolean castBoolean(Object o2) {
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof Boolean) {
            return (Boolean)o2;
        }
        return null;
    }

    public void removeProperty(String path) {
        if (!path.contains(".")) {
            this.root.remove(path);
            return;
        }
        String[] parts = path.split("\\.");
        Map node = this.root;
        for (int i2 = 0; i2 < parts.length; ++i2) {
            Object o2 = node.get(parts[i2]);
            if (i2 == parts.length - 1) {
                node.remove(parts[i2]);
                return;
            }
            node = (Map)o2;
        }
    }

    public Map<String, Object> getRoot() {
        return this.root;
    }

    public void setRoot(Map<String, Object> root) {
        this.root = root;
    }
}

