/*
 * Decompiled with CFR 0.152.
 */
package wecui.event.cui;

import wecui.WorldEditCUI;
import wecui.event.cui.CUIEventType;

public abstract class CUIBaseEvent {
    protected WorldEditCUI controller;
    protected String[] args;

    public CUIBaseEvent(WorldEditCUI controller, String[] args) {
        this.controller = controller;
        this.args = args;
    }

    public abstract String run();

    public abstract CUIEventType getEventType();

    public String getEventName() {
        String name = this.getEventType().name().toLowerCase();
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        return name;
    }

    public boolean isValid() {
        int min;
        int max = this.getEventType().getMaxParameters();
        return !(max == (min = this.getEventType().getMinParameters()) ? this.args.length != max : this.args.length > max || this.args.length < min);
    }

    public final String doRun() {
        if (this.controller == null || this.args == null) {
            throw new RuntimeException("Controller and parameters must both be set.");
        }
        if (!this.isValid()) {
            String message = "Invalid number of parameters. " + this.getEventName() + " event requires ";
            message = this.getEventType().getMaxParameters() == this.getEventType().getMinParameters() ? message + this.getEventType().getMaxParameters() + " parameters. " : message + "between " + this.getEventType().getMinParameters() + " and " + this.getEventType().getMaxParameters() + " parameters. ";
            message = message + "Received " + this.args.length + " parameters instead. ";
            for (String arg : this.args) {
                message = message + arg + " ";
            }
            throw new RuntimeException(message);
        }
        return this.run();
    }

    public int getInt(int index) {
        return (int)Float.parseFloat(this.args[index]);
    }

    public double getDouble(int index) {
        return Double.parseDouble(this.args[index]);
    }

    public String getString(int index) {
        return this.args[index];
    }
}

