/*
 * Decompiled with CFR 0.152.
 */
package wecui.plugin;

import wecui.InitializationFactory;
import wecui.WorldEditCUI;
import wecui.plugin.CUIPlayer;
import wecui.plugin.CUIServerInterface;
import wecui.plugin.CUIWEConfiguration;
import wecui.plugin.CUIWorld;
import wecui.vendor.com.sk89q.worldedit.LocalSession;
import wecui.vendor.com.sk89q.worldedit.WorldEdit;

public class LocalPlugin
implements InitializationFactory {
    protected WorldEditCUI controller;
    protected boolean enabled = false;
    protected boolean initialized = false;
    protected WorldEdit plugin;
    protected CUIWEConfiguration conf;
    protected CUIServerInterface serv;
    protected CUIWorld world;
    protected LocalSession session;

    public LocalPlugin(WorldEditCUI controller) {
        this.controller = controller;
    }

    public void initialize() {
        this.controller.setLocalPlugin(new LocalPlugin(this.controller));
    }

    public String onVersionEvent(String plugin) {
        if (this.controller.getLocalPlugin().isInitialized()) {
            return null;
        }
        this.controller.getLocalPlugin().setInitialized(true);
        this.setConfiguration(new CUIWEConfiguration(this.controller));
        this.setServerInterface(new CUIServerInterface(this.controller));
        this.setWorld(new CUIWorld(this.controller));
        this.setPlugin(new WorldEdit(this.getServerInterface(), this.getConfiguration()));
        this.setSession(this.getPlugin().getSession(new CUIPlayer(this.getServerInterface(), this.controller)));
        this.controller.getLocalPlugin().setEnabled(true);
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public WorldEdit getPlugin() {
        return this.plugin;
    }

    public void setPlugin(WorldEdit plugin) {
        this.plugin = plugin;
    }

    public String throwError(String message) {
        this.enabled = false;
        this.controller.getDebugger().info(message);
        this.controller.getObfuscation().showChatMessage(message);
        return message;
    }

    public CUIWEConfiguration getConfiguration() {
        return this.conf;
    }

    public CUIServerInterface getServerInterface() {
        return this.serv;
    }

    public void setConfiguration(CUIWEConfiguration conf) {
        this.conf = conf;
    }

    public void setServerInterface(CUIServerInterface serv) {
        this.serv = serv;
    }

    public CUIWorld getWorld() {
        return this.world;
    }

    public void setWorld(CUIWorld world) {
        this.world = world;
    }

    public LocalSession getSession() {
        return this.session;
    }

    public void setSession(LocalSession session) {
        this.session = session;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

