/*
 * Decompiled with CFR 0.152.
 */
package wecui.render;

import wecui.render.LineInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LineColor {
    CUBOIDGRID(0.8f, 0.2f, 0.2f),
    CUBOIDBOX(0.8f, 0.3f, 0.3f),
    CUBOIDPOINT1(0.2f, 0.8f, 0.2f),
    CUBOIDPOINT2(0.2f, 0.2f, 0.8f),
    POLYGRID(0.8f, 0.2f, 0.2f),
    POLYBOX(0.8f, 0.3f, 0.3f),
    POLYPOINT(0.2f, 0.8f, 0.8f),
    ELLIPSOIDGRID(0.8f, 0.3f, 0.3f),
    ELLIPSOIDCENTER(0.8f, 0.8f, 0.2f),
    CYLINDERGRID(0.8f, 0.2f, 0.2f),
    CYLINDERBOX(0.8f, 0.3f, 0.3f),
    CYLINDERCENTER(0.8f, 0.2f, 0.8f);

    protected LineInfo normal;
    protected LineInfo hidden;

    private LineColor(float r2, float g2, float b2) {
        this.normal = new LineInfo(3.0f, r2, g2, b2, 0.8f, 513);
        this.hidden = new LineInfo(3.0f, r2, g2, b2, 0.2f, 518);
    }

    private LineColor(String hex) {
        this.setColor(hex);
    }

    public LineInfo getHidden() {
        return this.hidden;
    }

    public LineInfo getNormal() {
        return this.normal;
    }

    public LineInfo[] getColors() {
        return new LineInfo[]{this.hidden, this.normal};
    }

    public void setColor(String hex) {
        Integer r2 = Integer.parseInt(hex.substring(1, 3), 16);
        Integer g2 = Integer.parseInt(hex.substring(3, 5), 16);
        Integer b2 = Integer.parseInt(hex.substring(5, 7), 16);
        float rF = r2.floatValue() / 256.0f;
        float gF = g2.floatValue() / 256.0f;
        float bF = b2.floatValue() / 256.0f;
        this.normal = new LineInfo(3.0f, rF, gF, bF, 0.8f, 513);
        this.hidden = new LineInfo(3.0f, rF, gF, bF, 0.2f, 518);
    }
}

