/*
 * Decompiled with CFR 0.152.
 */
package wecui.render.region;

import wecui.WorldEditCUI;
import wecui.render.LineColor;
import wecui.render.points.PointCube;
import wecui.render.region.BaseRegion;
import wecui.render.region.RegionType;
import wecui.render.shapes.RenderEllipsoid;
import wecui.util.Vector3;

public class EllipsoidRegion
extends BaseRegion {
    protected PointCube center;
    protected Vector3 radii;

    public EllipsoidRegion(WorldEditCUI controller) {
        super(controller);
    }

    public void render() {
        if (this.center != null && this.radii != null) {
            this.center.render();
            new RenderEllipsoid(LineColor.ELLIPSOIDGRID, this.center, this.radii).render();
        } else if (this.center != null) {
            this.center.render();
        }
    }

    public void setEllipsoidCenter(int x2, int y2, int z2) {
        this.center = new PointCube(x2, y2, z2);
        this.center.setColor(LineColor.ELLIPSOIDCENTER);
    }

    public void setEllipsoidRadii(double x2, double y2, double z2) {
        this.radii = new Vector3(x2, y2, z2);
    }

    public RegionType getType() {
        return RegionType.ELLIPSOID;
    }
}

