/*
 * Decompiled with CFR 0.152.
 */
package wecui.render.shapes;

import wecui.obfuscation.RenderObfuscation;
import wecui.render.LineColor;
import wecui.render.LineInfo;
import wecui.util.Vector3;

public class Render3DGrid {
    protected RenderObfuscation obf = RenderObfuscation.getInstance();
    protected LineColor color;
    protected Vector3 first;
    protected Vector3 second;

    public Render3DGrid(LineColor color, Vector3 first, Vector3 second) {
        this.color = color;
        this.first = first;
        this.second = second;
    }

    public void render() {
        double x1 = this.first.getX();
        double y1 = this.first.getY();
        double z1 = this.first.getZ();
        double x2 = this.second.getX();
        double y2 = this.second.getY();
        double z2 = this.second.getZ();
        for (LineInfo tempColor : this.color.getColors()) {
            double zoff;
            double xoff;
            double yoff;
            tempColor.prepareRender();
            RenderObfuscation o2 = RenderObfuscation.getInstance();
            o2.startDrawing(1);
            tempColor.prepareColor();
            double offsetSize = 1.0;
            double z3 = z2;
            double y3 = y1;
            int msize = 150;
            if (y2 - y3 / offsetSize < (double)msize) {
                yoff = 0.0;
                while (yoff + y3 <= y2) {
                    o2.addVertex(x1, y3 + yoff, z3);
                    o2.addVertex(x2, y3 + yoff, z3);
                    yoff += offsetSize;
                }
            }
            z3 = z1;
            if (y2 - y3 / offsetSize < (double)msize) {
                yoff = 0.0;
                while (yoff + y3 <= y2) {
                    o2.addVertex(x1, y3 + yoff, z3);
                    o2.addVertex(x2, y3 + yoff, z3);
                    yoff += offsetSize;
                }
            }
            double x3 = x1;
            if (y2 - y3 / offsetSize < (double)msize) {
                yoff = 0.0;
                while (yoff + y3 <= y2) {
                    o2.addVertex(x3, y3 + yoff, z1);
                    o2.addVertex(x3, y3 + yoff, z2);
                    yoff += offsetSize;
                }
            }
            x3 = x2;
            if (y2 - y3 / offsetSize < (double)msize) {
                yoff = 0.0;
                while (yoff + y3 <= y2) {
                    o2.addVertex(x3, y3 + yoff, z1);
                    o2.addVertex(x3, y3 + yoff, z2);
                    yoff += offsetSize;
                }
            }
            x3 = x1;
            z3 = z1;
            if (x2 - x3 / offsetSize < (double)msize) {
                xoff = 0.0;
                while (xoff + x3 <= x2) {
                    o2.addVertex(x3 + xoff, y1, z3);
                    o2.addVertex(x3 + xoff, y2, z3);
                    xoff += offsetSize;
                }
            }
            z3 = z2;
            if (x2 - x3 / offsetSize < (double)msize) {
                xoff = 0.0;
                while (xoff + x3 <= x2) {
                    o2.addVertex(x3 + xoff, y1, z3);
                    o2.addVertex(x3 + xoff, y2, z3);
                    xoff += offsetSize;
                }
            }
            y3 = y2;
            if (x2 - x3 / offsetSize < (double)msize) {
                xoff = 0.0;
                while (xoff + x3 <= x2) {
                    o2.addVertex(x3 + xoff, y3, z1);
                    o2.addVertex(x3 + xoff, y3, z2);
                    xoff += offsetSize;
                }
            }
            y3 = y1;
            if (x2 - x3 / offsetSize < (double)msize) {
                xoff = 0.0;
                while (xoff + x3 <= x2) {
                    o2.addVertex(x3 + xoff, y3, z1);
                    o2.addVertex(x3 + xoff, y3, z2);
                    xoff += offsetSize;
                }
            }
            z3 = z1;
            y3 = y1;
            if (z2 - z3 / offsetSize < (double)msize) {
                zoff = 0.0;
                while (zoff + z3 <= z2) {
                    o2.addVertex(x1, y3, z3 + zoff);
                    o2.addVertex(x2, y3, z3 + zoff);
                    zoff += offsetSize;
                }
            }
            y3 = y2;
            if (z2 - z3 / offsetSize < (double)msize) {
                zoff = 0.0;
                while (zoff + z3 <= z2) {
                    o2.addVertex(x1, y3, z3 + zoff);
                    o2.addVertex(x2, y3, z3 + zoff);
                    zoff += offsetSize;
                }
            }
            x3 = x2;
            if (z2 - z3 / offsetSize < (double)msize) {
                zoff = 0.0;
                while (zoff + z3 <= z2) {
                    o2.addVertex(x3, y1, z3 + zoff);
                    o2.addVertex(x3, y2, z3 + zoff);
                    zoff += offsetSize;
                }
            }
            x3 = x1;
            if (z2 - z3 / offsetSize < (double)msize) {
                zoff = 0.0;
                while (zoff + z3 <= z2) {
                    o2.addVertex(x3, y1, z3 + zoff);
                    o2.addVertex(x3, y2, z3 + zoff);
                    zoff += offsetSize;
                }
            }
            o2.finishDrawing();
        }
    }
}

