/*
 * Decompiled with CFR 0.152.
 */
package wecui.render.shapes;

import wecui.obfuscation.RenderObfuscation;
import wecui.render.LineColor;
import wecui.render.LineInfo;
import wecui.render.points.PointCube;

public class RenderCylinderCircles {
    protected LineColor color;
    protected double radX = 0.0;
    protected double radZ = 0.0;
    protected int minY;
    protected int maxY;
    protected RenderObfuscation obf = RenderObfuscation.getInstance();
    protected double centerX;
    protected double centerZ;

    public RenderCylinderCircles(LineColor color, PointCube center, double radX, double radZ, int minY, int maxY) {
        this.color = color;
        this.radX = radX;
        this.radZ = radZ;
        this.minY = minY;
        this.maxY = maxY;
        this.centerX = (double)center.getPoint().getX() + 0.5;
        this.centerZ = (double)center.getPoint().getZ() + 0.5;
    }

    public void render() {
        for (LineInfo tempColor : this.color.getColors()) {
            tempColor.prepareRender();
            double twoPi = Math.PI * 2;
            for (int yBlock = this.minY + 1; yBlock <= this.maxY; ++yBlock) {
                this.obf.startDrawing(2);
                tempColor.prepareColor();
                for (int i2 = 0; i2 <= 75; ++i2) {
                    double tempTheta = (double)i2 * twoPi / 75.0;
                    double tempX = this.radX * Math.cos(tempTheta);
                    double tempZ = this.radZ * Math.sin(tempTheta);
                    this.obf.addVertex(this.centerX + tempX, yBlock, this.centerZ + tempZ);
                }
                this.obf.finishDrawing();
            }
        }
    }
}

