/*
 * Decompiled with CFR 0.152.
 */
package wecui.render.shapes;

import wecui.obfuscation.RenderObfuscation;
import wecui.render.LineColor;
import wecui.render.LineInfo;
import wecui.render.points.PointCube;

public class RenderCylinderGrid {
    protected LineColor color;
    protected double radX = 0.0;
    protected double radZ = 0.0;
    protected int minY;
    protected int maxY;
    protected RenderObfuscation obf = RenderObfuscation.getInstance();
    protected double centerX;
    protected double centerZ;

    public RenderCylinderGrid(LineColor color, PointCube center, double radX, double radZ, int minY, int maxY) {
        this.color = color;
        this.radX = radX;
        this.radZ = radZ;
        this.minY = minY;
        this.maxY = maxY;
        this.centerX = (double)center.getPoint().getX() + 0.5;
        this.centerZ = (double)center.getPoint().getZ() + 0.5;
    }

    public void render() {
        for (LineInfo tempColor : this.color.getColors()) {
            tempColor.prepareRender();
            int tmaxY = this.maxY + 1;
            int tminY = this.minY;
            int posRadiusX = (int)Math.ceil(this.radX);
            int negRadiusX = (int)(-Math.ceil(this.radX));
            int posRadiusZ = (int)Math.ceil(this.radZ);
            int negRadiusZ = (int)(-Math.ceil(this.radZ));
            for (double tempX = (double)negRadiusX; tempX <= (double)posRadiusX; tempX += 1.0) {
                double tempZ = this.radZ * Math.cos(Math.asin(tempX / this.radX));
                this.obf.startDrawing(2);
                tempColor.prepareColor();
                this.obf.addVertex(this.centerX + tempX, tmaxY, this.centerZ + tempZ);
                this.obf.addVertex(this.centerX + tempX, tmaxY, this.centerZ - tempZ);
                this.obf.addVertex(this.centerX + tempX, tminY, this.centerZ - tempZ);
                this.obf.addVertex(this.centerX + tempX, tminY, this.centerZ + tempZ);
                this.obf.finishDrawing();
            }
            for (double tempZ = (double)negRadiusZ; tempZ <= (double)posRadiusZ; tempZ += 1.0) {
                double tempX = this.radX * Math.sin(Math.acos(tempZ / this.radZ));
                this.obf.startDrawing(2);
                tempColor.prepareColor();
                this.obf.addVertex(this.centerX + tempX, tmaxY, this.centerZ + tempZ);
                this.obf.addVertex(this.centerX - tempX, tmaxY, this.centerZ + tempZ);
                this.obf.addVertex(this.centerX - tempX, tminY, this.centerZ + tempZ);
                this.obf.addVertex(this.centerX + tempX, tminY, this.centerZ + tempZ);
                this.obf.finishDrawing();
            }
        }
    }
}

