/*
 * Decompiled with CFR 0.152.
 */
package wecui.util;

import wecui.util.Vector2;
import wecui.util.Vector2m;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vector3
implements Comparable<Vector3> {
    public static final Vector3 ZERO = new Vector3(0.0f, 0.0f, 0.0f);
    public static final Vector3 UNIT_X;
    public static final Vector3 Forward;
    public static final Vector3 UNIT_Y;
    public static final Vector3 Up;
    public static final Vector3 UNIT_Z;
    public static final Vector3 Right;
    public static final Vector3 ONE;
    protected float x;
    protected float y;
    protected float z;

    public Vector3(float x2, float y2, float z2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
    }

    public Vector3(Double x2, Double y2, Double z2) {
        this(x2.floatValue(), y2.floatValue(), z2.floatValue());
    }

    public Vector3() {
        this(0.0f, 0.0f, 0.0f);
    }

    public Vector3(Vector3 clone) {
        this(clone.getX(), clone.getY(), clone.getZ());
    }

    public Vector3(Vector2 vector, float z2) {
        this(vector.getX(), vector.getY(), z2);
    }

    public Vector3(Vector2 vector) {
        this(vector, 0.0f);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public Vector3 add(Vector3 that) {
        return Vector3.add(this, that);
    }

    public Vector3 subtract(Vector3 that) {
        return Vector3.subtract(this, that);
    }

    public Vector3 scale(float scale) {
        return Vector3.scale(this, scale);
    }

    public float dot(Vector3 that) {
        return Vector3.dot(this, that);
    }

    public Vector3 cross(Vector3 that) {
        return Vector3.cross(this, that);
    }

    public Vector2 toVector2() {
        return Vector3.toVector2(this);
    }

    public Vector2m toVector2m() {
        return Vector3.toVector2m(this);
    }

    public Vector3 ceil() {
        return new Vector3(Math.ceil(this.x), Math.ceil(this.y), Math.ceil(this.z));
    }

    public Vector3 floor() {
        return new Vector3(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public Vector3 round() {
        return new Vector3(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    public Vector3 abs() {
        return new Vector3(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    public double distance(Vector3 a2) {
        return Vector3.distance(a2, this);
    }

    public Vector3 pow(double power) {
        return Vector3.pow(this, power);
    }

    public float lengthSquared() {
        return Vector3.lengthSquared(this);
    }

    public float length() {
        return Vector3.length(this);
    }

    public float fastLength() {
        return Vector3.fastLength(this);
    }

    public Vector3 normalize() {
        return Vector3.normalize(this);
    }

    public float[] toArray() {
        return Vector3.toArray(this);
    }

    @Override
    public int compareTo(Vector3 o2) {
        return Vector3.compareTo(this, o2);
    }

    public boolean equals(Object o2) {
        return Vector3.equals(this, o2);
    }

    public String toString() {
        return String.format("{ %f, %f, %f }", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    public static float length(Vector3 a2) {
        return (float)Math.sqrt(Vector3.lengthSquared(a2));
    }

    public static float fastLength(Vector3 a2) {
        return (float)Math.sqrt(Vector3.lengthSquared(a2));
    }

    public static float lengthSquared(Vector3 a2) {
        return Vector3.dot(a2, a2);
    }

    public static Vector3 normalize(Vector3 a2) {
        return Vector3.scale(a2, 1.0f / a2.length());
    }

    public static Vector3 subtract(Vector3 a2, Vector3 b2) {
        return new Vector3(a2.getX() - b2.getX(), a2.getY() - b2.getY(), a2.getZ() - b2.getZ());
    }

    public static Vector3 add(Vector3 a2, Vector3 b2) {
        return new Vector3(a2.getX() + b2.getX(), a2.getY() + b2.getY(), a2.getZ() + b2.getZ());
    }

    public static Vector3 scale(Vector3 a2, float b2) {
        return new Vector3(a2.getX() * b2, a2.getY() * b2, a2.getZ() * b2);
    }

    public static float dot(Vector3 a2, Vector3 b2) {
        return a2.getX() * b2.getX() + a2.getY() * b2.getY() + a2.getZ() * b2.getZ();
    }

    public static Vector3 cross(Vector3 a2, Vector3 b2) {
        return new Vector3(a2.getY() * b2.getZ() - a2.getZ() * b2.getY(), a2.getZ() * b2.getX() - a2.getX() * b2.getZ(), a2.getX() * b2.getY() - a2.getY() * b2.getX());
    }

    public static Vector3 ceil(Vector3 o2) {
        return new Vector3(Math.ceil(o2.x), Math.ceil(o2.y), Math.ceil(o2.z));
    }

    public static Vector3 floor(Vector3 o2) {
        return new Vector3(Math.floor(o2.x), Math.floor(o2.y), Math.floor(o2.z));
    }

    public static Vector3 round(Vector3 o2) {
        return new Vector3(Math.round(o2.x), Math.round(o2.y), Math.round(o2.z));
    }

    public static Vector3 abs(Vector3 o2) {
        return new Vector3(Math.abs(o2.x), Math.abs(o2.y), Math.abs(o2.z));
    }

    public static Vector3 min(Vector3 o1, Vector3 o2) {
        return new Vector3(Math.min(o1.x, o2.x), Math.min(o1.y, o2.y), Math.min(o1.z, o2.z));
    }

    public static Vector3 max(Vector3 o1, Vector3 o2) {
        return new Vector3(Math.max(o1.x, o2.x), Math.max(o1.y, o2.y), Math.max(o1.z, o2.z));
    }

    public static Vector3 rand() {
        return new Vector3(Math.random(), Math.random(), Math.random());
    }

    public static double distance(Vector3 a2, Vector3 b2) {
        double xzDist = Vector2.distance(a2.toVector2(), b2.toVector2());
        return Math.sqrt(Math.pow(xzDist, 2.0) + Math.pow(Math.abs(Vector3.subtract(a2, b2).getY()), 2.0));
    }

    public static Vector3 pow(Vector3 o2, double power) {
        return new Vector3(Math.pow(o2.x, power), Math.pow(o2.y, power), Math.pow(o2.z, power));
    }

    public static Vector2 toVector2(Vector3 o2) {
        return new Vector2(o2.x, o2.z);
    }

    public static Vector2m toVector2m(Vector3 o2) {
        return new Vector2m(o2.x, o2.z);
    }

    public static float[] toArray(Vector3 a2) {
        return new float[]{a2.getX(), a2.getY(), a2.getZ()};
    }

    public static int compareTo(Vector3 a2, Vector3 b2) {
        return (int)a2.lengthSquared() - (int)b2.lengthSquared();
    }

    public static boolean equals(Object a2, Object b2) {
        if (!(a2 instanceof Vector3) || !(b2 instanceof Vector3)) {
            return false;
        }
        if (a2 == b2) {
            return true;
        }
        Vector3 x2 = (Vector3)a2;
        Vector3 y2 = (Vector3)b2;
        return x2.getX() == y2.getX() && x2.getY() == y2.getY() && x2.getZ() == y2.getZ();
    }

    static {
        Forward = UNIT_X = new Vector3(1.0f, 0.0f, 0.0f);
        Up = UNIT_Y = new Vector3(0.0f, 1.0f, 0.0f);
        Right = UNIT_Z = new Vector3(0.0f, 0.0f, 1.0f);
        ONE = new Vector3(1.0f, 1.0f, 1.0f);
    }
}

