/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.jchronic.tags;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import wecui.vendor.com.sk89q.jchronic.Options;
import wecui.vendor.com.sk89q.jchronic.tags.OrdinalDay;
import wecui.vendor.com.sk89q.jchronic.tags.Tag;
import wecui.vendor.com.sk89q.jchronic.utils.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ordinal
extends Tag<Integer> {
    public static Pattern ORDINAL_PATTERN = Pattern.compile("^(\\d*)(st|nd|rd|th)$");

    public Ordinal(Integer type) {
        super(type);
    }

    public static List<com.sk89q.jchronic.utils.Token> scan(List<com.sk89q.jchronic.utils.Token> tokens, Options options) {
        for (Token token : tokens) {
            Ordinal t2 = Ordinal.scan(token, options);
            if (t2 != null) {
                token.tag(t2);
            }
            if ((t2 = OrdinalDay.scan(token)) == null) continue;
            token.tag(t2);
        }
        return tokens;
    }

    public static Ordinal scan(Token token, Options options) {
        Matcher ordinalMatcher = ORDINAL_PATTERN.matcher(token.getWord());
        if (ordinalMatcher.find()) {
            return new Ordinal(Integer.valueOf(ordinalMatcher.group(1)));
        }
        return null;
    }

    public String toString() {
        return "ordinal";
    }
}

