/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.jchronic.tags;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import wecui.vendor.com.sk89q.jchronic.Options;
import wecui.vendor.com.sk89q.jchronic.tags.ScalarDay;
import wecui.vendor.com.sk89q.jchronic.tags.ScalarMonth;
import wecui.vendor.com.sk89q.jchronic.tags.ScalarYear;
import wecui.vendor.com.sk89q.jchronic.tags.Tag;
import wecui.vendor.com.sk89q.jchronic.utils.StringUtils;
import wecui.vendor.com.sk89q.jchronic.utils.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scalar
extends Tag<Integer> {
    private static final Pattern SCALAR_PATTERN = Pattern.compile("^\\d*$");
    public static Set<String> TIMES = new HashSet<String>();

    static {
        TIMES.add("am");
        TIMES.add("pm");
        TIMES.add("morning");
        TIMES.add("afternoon");
        TIMES.add("evening");
        TIMES.add("night");
    }

    public Scalar(Integer type) {
        super(type);
    }

    public static List<com.sk89q.jchronic.utils.Token> scan(List<com.sk89q.jchronic.utils.Token> tokens, Options options) {
        int i2 = 0;
        while (i2 < tokens.size()) {
            Scalar t2;
            Token token = (Token)tokens.get(i2);
            Token postToken = null;
            if (i2 < tokens.size() - 1) {
                postToken = (Token)tokens.get(i2 + 1);
            }
            if ((t2 = Scalar.scan(token, postToken, options)) != null) {
                token.tag(t2);
            }
            if ((t2 = ScalarDay.scan(token, postToken, options)) != null) {
                token.tag(t2);
            }
            if ((t2 = ScalarMonth.scan(token, postToken, options)) != null) {
                token.tag(t2);
            }
            if ((t2 = ScalarYear.scan(token, postToken, options)) != null) {
                token.tag(t2);
            }
            ++i2;
        }
        return tokens;
    }

    public static Scalar scan(Token token, Token postToken, Options options) {
        if (SCALAR_PATTERN.matcher(token.getWord()).matches()) {
            if (!(token.getWord() == null || token.getWord().length() <= 0 || postToken != null && TIMES.contains(postToken.getWord()))) {
                return new Scalar(Integer.valueOf(token.getWord()));
            }
        } else {
            Integer intStrValue = StringUtils.integerValue(token.getWord());
            if (intStrValue != null) {
                return new Scalar(intStrValue);
            }
        }
        return null;
    }

    public String toString() {
        return "scalar";
    }
}

