/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.minecraft.util.commands;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import wecui.vendor.com.sk89q.minecraft.util.commands.Injector;

public class SimpleInjector
implements Injector {
    private static final Logger logger = Logger.getLogger(SimpleInjector.class.getCanonicalName());
    private Object[] args;
    private Class<?>[] argClasses;

    public SimpleInjector(Object ... args) {
        this.args = args;
        this.argClasses = new Class[args.length];
        for (int i2 = 0; i2 < args.length; ++i2) {
            this.argClasses[i2] = args[i2].getClass();
        }
    }

    @Override
    public Object getInstance(Class<?> clazz) {
        try {
            Constructor<?> ctr = clazz.getConstructor(this.argClasses);
            ctr.setAccessible(true);
            return ctr.newInstance(this.args);
        }
        catch (NoSuchMethodException e2) {
            logger.severe("Error initializing commands class " + clazz + ": ");
            e2.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e3) {
            logger.severe("Error initializing commands class " + clazz + ": ");
            e3.printStackTrace();
            return null;
        }
        catch (InstantiationException e4) {
            logger.severe("Error initializing commands class " + clazz + ": ");
            e4.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e5) {
            logger.severe("Error initializing commands class " + clazz + ": ");
            e5.printStackTrace();
            return null;
        }
    }
}

