/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.util;

import java.util.Collection;
import java.util.Map;

public class StringUtil {
    public static String trimLength(String str, int len) {
        if (str.length() > len) {
            return str.substring(0, len);
        }
        return str;
    }

    public static String joinString(String[] str, String delimiter, int initialIndex) {
        if (str.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(str[initialIndex]);
        for (int i2 = initialIndex + 1; i2 < str.length; ++i2) {
            buffer.append(delimiter).append(str[i2]);
        }
        return buffer.toString();
    }

    public static String joinQuotedString(String[] str, String delimiter, int initialIndex, String quote) {
        if (str.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(quote);
        buffer.append(str[initialIndex]);
        buffer.append(quote);
        for (int i2 = initialIndex + 1; i2 < str.length; ++i2) {
            buffer.append(delimiter).append(quote).append(str[i2]).append(quote);
        }
        return buffer.toString();
    }

    public static String joinString(String[] str, String delimiter) {
        return StringUtil.joinString(str, delimiter, 0);
    }

    public static String joinString(Object[] str, String delimiter, int initialIndex) {
        if (str.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(str[initialIndex].toString());
        for (int i2 = initialIndex + 1; i2 < str.length; ++i2) {
            buffer.append(delimiter).append(str[i2].toString());
        }
        return buffer.toString();
    }

    public static String joinString(int[] str, String delimiter, int initialIndex) {
        if (str.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(Integer.toString(str[initialIndex]));
        for (int i2 = initialIndex + 1; i2 < str.length; ++i2) {
            buffer.append(delimiter).append(Integer.toString(str[i2]));
        }
        return buffer.toString();
    }

    public static String joinString(Collection<?> str, String delimiter, int initialIndex) {
        if (str.size() == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        int i2 = 0;
        for (Object o2 : str) {
            if (i2 >= initialIndex) {
                if (i2 > 0) {
                    buffer.append(delimiter);
                }
                buffer.append(o2.toString());
            }
            ++i2;
        }
        return buffer.toString();
    }

    public static int getLevenshteinDistance(String s2, String t2) {
        int i2;
        if (s2 == null || t2 == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n2 = s2.length();
        int m2 = t2.length();
        if (n2 == 0) {
            return m2;
        }
        if (m2 == 0) {
            return n2;
        }
        int[] p2 = new int[n2 + 1];
        int[] d2 = new int[n2 + 1];
        for (i2 = 0; i2 <= n2; ++i2) {
            p2[i2] = i2;
        }
        for (int j2 = 1; j2 <= m2; ++j2) {
            char t_j = t2.charAt(j2 - 1);
            d2[0] = j2;
            for (i2 = 1; i2 <= n2; ++i2) {
                int cost = s2.charAt(i2 - 1) == t_j ? 0 : 1;
                d2[i2] = Math.min(Math.min(d2[i2 - 1] + 1, p2[i2] + 1), p2[i2 - 1] + cost);
            }
            int[] _d = p2;
            p2 = d2;
            d2 = _d;
        }
        return p2[n2];
    }

    public static <T extends Enum<?>> T lookup(Map<String, T> lookup, String name, boolean fuzzy) {
        String testName = name.replaceAll("[ _]", "").toLowerCase();
        Enum type = (Enum)lookup.get(testName);
        if (type != null) {
            return (T)type;
        }
        if (!fuzzy) {
            return null;
        }
        int minDist = Integer.MAX_VALUE;
        for (Map.Entry<String, T> entry : lookup.entrySet()) {
            int dist;
            String key = entry.getKey();
            if (key.charAt(0) != testName.charAt(0) || (dist = StringUtil.getLevenshteinDistance(key, testName)) < minDist) continue;
            minDist = dist;
            type = (Enum)entry.getValue();
        }
        if (minDist > 1) {
            return null;
        }
        return (T)type;
    }
}

