/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.util.yaml;

import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.Vector;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import wecui.vendor.com.sk89q.worldedit.Vector2D;

public class YAMLNode {
    protected Map<String, Object> root;
    private boolean writeDefaults;

    public YAMLNode(Map<String, Object> root, boolean writeDefaults) {
        this.root = root;
        this.writeDefaults = writeDefaults;
    }

    public Map<String, Object> getMap() {
        return this.root;
    }

    public void clear() {
        this.root.clear();
    }

    public Object getProperty(String path) {
        if (!path.contains(".")) {
            Object val = this.root.get(path);
            if (val == null) {
                return null;
            }
            return val;
        }
        String[] parts = path.split("\\.");
        Map node = this.root;
        for (int i2 = 0; i2 < parts.length; ++i2) {
            Object o2 = node.get(parts[i2]);
            if (o2 == null) {
                return null;
            }
            if (i2 == parts.length - 1) {
                return o2;
            }
            try {
                node = (Map)o2;
                continue;
            }
            catch (ClassCastException e2) {
                return null;
            }
        }
        return null;
    }

    private Object prepareSerialization(Object value) {
        if (value instanceof wecui.vendor.com.sk89q.worldedit.Vector) {
            LinkedHashMap<String, Double> out = new LinkedHashMap<String, Double>();
            wecui.vendor.com.sk89q.worldedit.Vector vec = (wecui.vendor.com.sk89q.worldedit.Vector)value;
            out.put("x", vec.getX());
            out.put("y", vec.getY());
            out.put("z", vec.getZ());
            return out;
        }
        return value;
    }

    public void setProperty(String path, Object value) {
        value = this.prepareSerialization(value);
        if (!path.contains(".")) {
            this.root.put(path, value);
            return;
        }
        String[] parts = path.split("\\.");
        Map node = this.root;
        for (int i2 = 0; i2 < parts.length; ++i2) {
            LinkedHashMap o2 = node.get(parts[i2]);
            if (i2 == parts.length - 1) {
                node.put((String)parts[i2], (Object)value);
                return;
            }
            if (o2 == null || !(o2 instanceof Map)) {
                o2 = new LinkedHashMap();
                node.put(parts[i2], o2);
            }
            node = o2;
        }
    }

    public YAMLNode addNode(String path) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        YAMLNode node = new YAMLNode(map, this.writeDefaults);
        this.setProperty(path, map);
        return node;
    }

    public String getString(String path) {
        Object o2 = this.getProperty(path);
        if (o2 == null) {
            return null;
        }
        return o2.toString();
    }

    public wecui.vendor.com.sk89q.worldedit.Vector getVector(String path) {
        YAMLNode o2 = this.getNode(path);
        if (o2 == null) {
            return null;
        }
        Double x2 = o2.getDouble("x");
        Double y2 = o2.getDouble("y");
        Double z2 = o2.getDouble("z");
        if (x2 == null || y2 == null || z2 == null) {
            return null;
        }
        return new wecui.vendor.com.sk89q.worldedit.Vector(x2, y2, z2);
    }

    public Vector2D getVector2d(String path) {
        YAMLNode o2 = this.getNode(path);
        if (o2 == null) {
            return null;
        }
        Double x2 = o2.getDouble("x");
        Double z2 = o2.getDouble("z");
        if (x2 == null || z2 == null) {
            return null;
        }
        return new Vector2D(x2, z2);
    }

    public wecui.vendor.com.sk89q.worldedit.Vector getVector(String path, wecui.vendor.com.sk89q.worldedit.Vector def) {
        wecui.vendor.com.sk89q.worldedit.Vector v2 = this.getVector(path);
        if (v2 == null) {
            if (this.writeDefaults) {
                this.setProperty(path, def);
            }
            return def;
        }
        return v2;
    }

    public String getString(String path, String def) {
        String o2 = this.getString(path);
        if (o2 == null) {
            if (this.writeDefaults) {
                this.setProperty(path, def);
            }
            return def;
        }
        return o2;
    }

    public Integer getInt(String path) {
        Integer o2 = YAMLNode.castInt(this.getProperty(path));
        if (o2 == null) {
            return null;
        }
        return o2;
    }

    public int getInt(String path, int def) {
        Integer o2 = YAMLNode.castInt(this.getProperty(path));
        if (o2 == null) {
            if (this.writeDefaults) {
                this.setProperty(path, def);
            }
            return def;
        }
        return o2;
    }

    public Double getDouble(String path) {
        Double o2 = YAMLNode.castDouble(this.getProperty(path));
        if (o2 == null) {
            return null;
        }
        return o2;
    }

    public double getDouble(String path, double def) {
        Double o2 = YAMLNode.castDouble(this.getProperty(path));
        if (o2 == null) {
            if (this.writeDefaults) {
                this.setProperty(path, def);
            }
            return def;
        }
        return o2;
    }

    public Boolean getBoolean(String path) {
        Boolean o2 = YAMLNode.castBoolean(this.getProperty(path));
        if (o2 == null) {
            return null;
        }
        return o2;
    }

    public boolean getBoolean(String path, boolean def) {
        Boolean o2 = YAMLNode.castBoolean(this.getProperty(path));
        if (o2 == null) {
            if (this.writeDefaults) {
                this.setProperty(path, def);
            }
            return def;
        }
        return o2;
    }

    public List<String> getKeys(String path) {
        if (path == null) {
            return new ArrayList<String>(this.root.keySet());
        }
        Object o2 = this.getProperty(path);
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof Map) {
            return new ArrayList<String>(((Map)o2).keySet());
        }
        return null;
    }

    public List<Object> getList(String path) {
        Object o2 = this.getProperty(path);
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof List) {
            return (List)o2;
        }
        return null;
    }

    public List<String> getStringList(String path, List<String> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object o2 : raw) {
            if (o2 == null) continue;
            list.add(o2.toString());
        }
        return list;
    }

    public List<Integer> getIntList(String path, List<Integer> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Object o2 : raw) {
            Integer i2 = YAMLNode.castInt(o2);
            if (i2 == null) continue;
            list.add(i2);
        }
        return list;
    }

    public List<Double> getDoubleList(String path, List<Double> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<Double> list = new ArrayList<Double>();
        for (Object o2 : raw) {
            Double i2 = YAMLNode.castDouble(o2);
            if (i2 == null) continue;
            list.add(i2);
        }
        return list;
    }

    public List<Boolean> getBooleanList(String path, List<Boolean> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        for (Object o2 : raw) {
            Boolean tetsu = YAMLNode.castBoolean(o2);
            if (tetsu == null) continue;
            list.add(tetsu);
        }
        return list;
    }

    public List<Vector> getVectorList(String path, List<Vector> def) {
        List<com.sk89q.util.yaml.YAMLNode> raw = this.getNodeList(path, null);
        ArrayList<Vector> list = new ArrayList<Vector>();
        for (YAMLNode yAMLNode : raw) {
            Double x2 = yAMLNode.getDouble("x");
            Double y2 = yAMLNode.getDouble("y");
            Double z2 = yAMLNode.getDouble("z");
            if (x2 == null || y2 == null || z2 == null) continue;
            list.add((Vector)new wecui.vendor.com.sk89q.worldedit.Vector(x2, y2, z2));
        }
        return list;
    }

    public List<com.sk89q.worldedit.Vector2D> getVector2dList(String path, List<com.sk89q.worldedit.Vector2D> def) {
        List<com.sk89q.util.yaml.YAMLNode> raw = this.getNodeList(path, null);
        ArrayList<com.sk89q.worldedit.Vector2D> list = new ArrayList<com.sk89q.worldedit.Vector2D>();
        for (YAMLNode yAMLNode : raw) {
            Double x2 = yAMLNode.getDouble("x");
            Double z2 = yAMLNode.getDouble("z");
            if (x2 == null || z2 == null) continue;
            list.add((com.sk89q.worldedit.Vector2D)new Vector2D(x2, z2));
        }
        return list;
    }

    public List<BlockVector2D> getBlockVector2dList(String path, List<BlockVector2D> def) {
        List<com.sk89q.util.yaml.YAMLNode> raw = this.getNodeList(path, null);
        ArrayList<BlockVector2D> list = new ArrayList<BlockVector2D>();
        for (YAMLNode yAMLNode : raw) {
            Double x2 = yAMLNode.getDouble("x");
            Double z2 = yAMLNode.getDouble("z");
            if (x2 == null || z2 == null) continue;
            list.add((BlockVector2D)new wecui.vendor.com.sk89q.worldedit.BlockVector2D(x2, z2));
        }
        return list;
    }

    public List<com.sk89q.util.yaml.YAMLNode> getNodeList(String path, List<com.sk89q.util.yaml.YAMLNode> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<com.sk89q.util.yaml.YAMLNode> list = new ArrayList<com.sk89q.util.yaml.YAMLNode>();
        for (Object o2 : raw) {
            if (!(o2 instanceof Map)) continue;
            list.add((com.sk89q.util.yaml.YAMLNode)new YAMLNode((Map)o2, this.writeDefaults));
        }
        return list;
    }

    public YAMLNode getNode(String path) {
        Object raw = this.getProperty(path);
        if (raw instanceof Map) {
            return new YAMLNode((Map)raw, this.writeDefaults);
        }
        return null;
    }

    public Map<String, com.sk89q.util.yaml.YAMLNode> getNodes(String path) {
        Object o2 = this.getProperty(path);
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof Map) {
            LinkedHashMap<String, com.sk89q.util.yaml.YAMLNode> nodes = new LinkedHashMap<String, com.sk89q.util.yaml.YAMLNode>();
            for (Map.Entry entry : ((Map)o2).entrySet()) {
                if (!(entry.getValue() instanceof Map)) continue;
                nodes.put((String)entry.getKey(), (com.sk89q.util.yaml.YAMLNode)new YAMLNode((Map)entry.getValue(), this.writeDefaults));
            }
            return nodes;
        }
        return null;
    }

    private static Integer castInt(Object o2) {
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof Number) {
            return ((Number)o2).intValue();
        }
        return null;
    }

    private static Double castDouble(Object o2) {
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof Number) {
            return ((Number)o2).doubleValue();
        }
        return null;
    }

    private static Boolean castBoolean(Object o2) {
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof Boolean) {
            return (Boolean)o2;
        }
        return null;
    }

    public void removeProperty(String path) {
        if (!path.contains(".")) {
            this.root.remove(path);
            return;
        }
        String[] parts = path.split("\\.");
        Map node = this.root;
        for (int i2 = 0; i2 < parts.length; ++i2) {
            Object o2 = node.get(parts[i2]);
            if (i2 == parts.length - 1) {
                node.remove(parts[i2]);
                return;
            }
            node = (Map)o2;
        }
    }

    public boolean writeDefaults() {
        return this.writeDefaults;
    }

    public void setWriteDefaults(boolean writeDefaults) {
        this.writeDefaults = writeDefaults;
    }
}

