/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit;

import com.sk89q.worldedit.CuboidClipboard;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import wecui.vendor.com.sk89q.worldedit.EditSession;
import wecui.vendor.com.sk89q.worldedit.LocalEntity;
import wecui.vendor.com.sk89q.worldedit.MaxChangedBlocksException;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseBlock;
import wecui.vendor.com.sk89q.worldedit.data.DataException;
import wecui.vendor.com.sk89q.worldedit.schematic.SchematicFormat;

public class CuboidClipboard {
    private BaseBlock[][][] data;
    private Vector offset;
    private Vector origin;
    private Vector size;
    private List<CuboidClipboard.CopiedEntity> entities = new ArrayList<CuboidClipboard.CopiedEntity>();

    public CuboidClipboard(Vector size) {
        this.size = size;
        this.data = new BaseBlock[size.getBlockX()][size.getBlockY()][size.getBlockZ()];
        this.origin = new Vector();
        this.offset = new Vector();
    }

    public CuboidClipboard(Vector size, Vector origin) {
        this.size = size;
        this.data = new BaseBlock[size.getBlockX()][size.getBlockY()][size.getBlockZ()];
        this.origin = origin;
        this.offset = new Vector();
    }

    public CuboidClipboard(Vector size, Vector origin, Vector offset) {
        this.size = size;
        this.data = new BaseBlock[size.getBlockX()][size.getBlockY()][size.getBlockZ()];
        this.origin = origin;
        this.offset = offset;
    }

    public int getWidth() {
        return this.size.getBlockX();
    }

    public int getLength() {
        return this.size.getBlockZ();
    }

    public int getHeight() {
        return this.size.getBlockY();
    }

    public void rotate2D(int angle) {
        if ((angle %= 360) % 90 != 0) {
            return;
        }
        boolean reverse = angle < 0;
        int numRotations = Math.abs((int)Math.floor((double)angle / 90.0));
        int width = this.getWidth();
        int length = this.getLength();
        int height = this.getHeight();
        Vector sizeRotated = this.size.transform2D(angle, 0.0, 0.0, 0.0, 0.0);
        int shiftX = sizeRotated.getX() < 0.0 ? -sizeRotated.getBlockX() - 1 : 0;
        int shiftZ = sizeRotated.getZ() < 0.0 ? -sizeRotated.getBlockZ() - 1 : 0;
        BaseBlock[][][] newData = new BaseBlock[Math.abs(sizeRotated.getBlockX())][Math.abs(sizeRotated.getBlockY())][Math.abs(sizeRotated.getBlockZ())];
        for (int x2 = 0; x2 < width; ++x2) {
            for (int z2 = 0; z2 < length; ++z2) {
                Vector v2 = new Vector(x2, 0, z2).transform2D(angle, 0.0, 0.0, 0.0, 0.0);
                int newX = v2.getBlockX();
                int newZ = v2.getBlockZ();
                for (int y2 = 0; y2 < height; ++y2) {
                    int i2;
                    BaseBlock block;
                    newData[shiftX + newX][y2][shiftZ + newZ] = block = this.data[x2][y2][z2];
                    if (reverse) {
                        for (i2 = 0; i2 < numRotations; ++i2) {
                            block.rotate90Reverse();
                        }
                        continue;
                    }
                    for (i2 = 0; i2 < numRotations; ++i2) {
                        block.rotate90();
                    }
                }
            }
        }
        this.data = newData;
        this.size = new Vector(Math.abs(sizeRotated.getBlockX()), Math.abs(sizeRotated.getBlockY()), Math.abs(sizeRotated.getBlockZ()));
        this.offset = this.offset.transform2D(angle, 0.0, 0.0, 0.0, 0.0).subtract(shiftX, 0, shiftZ);
    }

    public void flip(FlipDirection dir) {
        this.flip(dir, false);
    }

    public void flip(FlipDirection dir, boolean aroundPlayer) {
        int width = this.getWidth();
        int length = this.getLength();
        int height = this.getHeight();
        switch (dir) {
            case NORTH_SOUTH: {
                int wid = (int)Math.ceil((float)width / 2.0f);
                for (int xs2 = 0; xs2 < wid; ++xs2) {
                    for (int z2 = 0; z2 < length; ++z2) {
                        for (int y2 = 0; y2 < height; ++y2) {
                            BaseBlock old = this.data[xs2][y2][z2].flip(dir);
                            if (xs2 == width - xs2 - 1) continue;
                            this.data[xs2][y2][z2] = this.data[width - xs2 - 1][y2][z2].flip(dir);
                            this.data[width - xs2 - 1][y2][z2] = old;
                        }
                    }
                }
                if (!aroundPlayer) break;
                this.offset = this.offset.setX(1.0 - this.offset.getX() - (double)width);
                break;
            }
            case WEST_EAST: {
                int len = (int)Math.ceil((float)length / 2.0f);
                for (int zs2 = 0; zs2 < len; ++zs2) {
                    for (int x2 = 0; x2 < width; ++x2) {
                        for (int y3 = 0; y3 < height; ++y3) {
                            BaseBlock old = this.data[x2][y3][zs2].flip(dir);
                            if (zs2 == length - zs2 - 1) continue;
                            this.data[x2][y3][zs2] = this.data[x2][y3][length - zs2 - 1].flip(dir);
                            this.data[x2][y3][length - zs2 - 1] = old;
                        }
                    }
                }
                if (!aroundPlayer) break;
                this.offset = this.offset.setZ(1.0 - this.offset.getZ() - (double)length);
                break;
            }
            case UP_DOWN: {
                int hei = (int)Math.ceil((float)height / 2.0f);
                for (int ys2 = 0; ys2 < hei; ++ys2) {
                    for (int x3 = 0; x3 < width; ++x3) {
                        for (int z3 = 0; z3 < length; ++z3) {
                            BaseBlock old = this.data[x3][ys2][z3].flip(dir);
                            if (ys2 == height - ys2 - 1) continue;
                            this.data[x3][ys2][z3] = this.data[x3][height - ys2 - 1][z3].flip(dir);
                            this.data[x3][height - ys2 - 1][z3] = old;
                        }
                    }
                }
                if (!aroundPlayer) break;
                this.offset = this.offset.setY(1.0 - this.offset.getY() - (double)height);
            }
        }
    }

    public void copy(EditSession editSession) {
        for (int x2 = 0; x2 < this.size.getBlockX(); ++x2) {
            for (int y2 = 0; y2 < this.size.getBlockY(); ++y2) {
                for (int z2 = 0; z2 < this.size.getBlockZ(); ++z2) {
                    this.data[x2][y2][z2] = editSession.getBlock(new Vector(x2, y2, z2).add(this.getOrigin()));
                }
            }
        }
    }

    public void paste(EditSession editSession, Vector newOrigin, boolean noAir) throws MaxChangedBlocksException {
        this.paste(editSession, newOrigin, noAir, false);
    }

    public void paste(EditSession editSession, Vector newOrigin, boolean noAir, boolean entities) throws MaxChangedBlocksException {
        this.place(editSession, newOrigin.add(this.offset), noAir);
        if (entities) {
            this.pasteEntities(newOrigin.add(this.offset));
        }
    }

    public void place(EditSession editSession, Vector pos, boolean noAir) throws MaxChangedBlocksException {
        for (int x2 = 0; x2 < this.size.getBlockX(); ++x2) {
            for (int y2 = 0; y2 < this.size.getBlockY(); ++y2) {
                for (int z2 = 0; z2 < this.size.getBlockZ(); ++z2) {
                    if (noAir && this.data[x2][y2][z2].isAir()) continue;
                    editSession.setBlock(new Vector(x2, y2, z2).add(pos), this.data[x2][y2][z2]);
                }
            }
        }
    }

    public LocalEntity[] pasteEntities(Vector pos) {
        LocalEntity[] entities = new LocalEntity[this.entities.size()];
        for (int i2 = 0; i2 < this.entities.size(); ++i2) {
            CopiedEntity copied = (CopiedEntity)this.entities.get(i2);
            if (!copied.entity.spawn(copied.entity.getPosition().setPosition(copied.relativePosition.add(pos)))) continue;
            entities[i2] = copied.entity;
        }
        return entities;
    }

    public void storeEntity(LocalEntity entity) {
        this.entities.add((CuboidClipboard.CopiedEntity)new CopiedEntity(entity));
    }

    public BaseBlock getPoint(Vector pos) throws ArrayIndexOutOfBoundsException {
        return this.data[pos.getBlockX()][pos.getBlockY()][pos.getBlockZ()];
    }

    public void setBlock(Vector pt2, BaseBlock block) {
        this.data[pt2.getBlockX()][pt2.getBlockY()][pt2.getBlockZ()] = block;
    }

    public Vector getSize() {
        return this.size;
    }

    @Deprecated
    public void saveSchematic(File path) throws IOException, DataException {
        SchematicFormat.MCEDIT.save(this, path);
    }

    @Deprecated
    public static CuboidClipboard loadSchematic(File path) throws DataException, IOException {
        return SchematicFormat.MCEDIT.load(path);
    }

    public Vector getOrigin() {
        return this.origin;
    }

    public void setOrigin(Vector origin) {
        this.origin = origin;
    }

    public Vector getOffset() {
        return this.offset;
    }

    public void setOffset(Vector offset) {
        this.offset = offset;
    }

    private class CopiedEntity {
        private final LocalEntity entity;
        private final Vector relativePosition;

        public CopiedEntity(LocalEntity entity) {
            this.entity = entity;
            this.relativePosition = entity.getPosition().getPosition().subtract(CuboidClipboard.this.getOrigin());
        }
    }

    public static enum FlipDirection {
        NORTH_SOUTH,
        WEST_EAST,
        UP_DOWN;

    }
}

