/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import wecui.vendor.com.sk89q.worldedit.ArbitraryShape;
import wecui.vendor.com.sk89q.worldedit.BlockVector;
import wecui.vendor.com.sk89q.worldedit.BlockVector2D;
import wecui.vendor.com.sk89q.worldedit.Countable;
import wecui.vendor.com.sk89q.worldedit.DoubleArrayList;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.MaxChangedBlocksException;
import wecui.vendor.com.sk89q.worldedit.PlayerDirection;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.bags.BlockBag;
import wecui.vendor.com.sk89q.worldedit.bags.BlockBagException;
import wecui.vendor.com.sk89q.worldedit.bags.UnplaceableBlockException;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.BlockType;
import wecui.vendor.com.sk89q.worldedit.blocks.ChestBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.ContainerBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.DispenserBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.FurnaceBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.MobSpawnerBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.NoteBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.SignBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.TileEntityBlock;
import wecui.vendor.com.sk89q.worldedit.expression.Expression;
import wecui.vendor.com.sk89q.worldedit.expression.ExpressionException;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.RValue;
import wecui.vendor.com.sk89q.worldedit.masks.Mask;
import wecui.vendor.com.sk89q.worldedit.patterns.Pattern;
import wecui.vendor.com.sk89q.worldedit.regions.CuboidRegion;
import wecui.vendor.com.sk89q.worldedit.regions.Region;
import wecui.vendor.com.sk89q.worldedit.util.TreeGenerator;

public class EditSession {
    private static Random prng = new Random();
    protected LocalWorld world;
    private DoubleArrayList<com.sk89q.worldedit.BlockVector, com.sk89q.worldedit.blocks.BaseBlock> original = new DoubleArrayList(true);
    private DoubleArrayList<com.sk89q.worldedit.BlockVector, com.sk89q.worldedit.blocks.BaseBlock> current = new DoubleArrayList(false);
    private DoubleArrayList<com.sk89q.worldedit.BlockVector, com.sk89q.worldedit.blocks.BaseBlock> queueAfter = new DoubleArrayList(false);
    private DoubleArrayList<com.sk89q.worldedit.BlockVector, com.sk89q.worldedit.blocks.BaseBlock> queueLast = new DoubleArrayList(false);
    private DoubleArrayList<com.sk89q.worldedit.BlockVector, com.sk89q.worldedit.blocks.BaseBlock> queueFinal = new DoubleArrayList(false);
    private int maxBlocks = -1;
    private boolean queued = false;
    private boolean fastMode = false;
    private BlockBag blockBag;
    private Set<Integer> missingBlocks = new HashSet<Integer>();
    private Mask mask;
    Vector[] recurseDirections = new Vector[]{PlayerDirection.NORTH.vector(), PlayerDirection.EAST.vector(), PlayerDirection.SOUTH.vector(), PlayerDirection.WEST.vector(), PlayerDirection.UP.vector(), PlayerDirection.DOWN.vector()};

    public EditSession(LocalWorld world, int maxBlocks) {
        if (maxBlocks < -1) {
            throw new IllegalArgumentException("Max blocks must be >= -1");
        }
        this.maxBlocks = maxBlocks;
        this.world = world;
    }

    public EditSession(LocalWorld world, int maxBlocks, BlockBag blockBag) {
        if (maxBlocks < -1) {
            throw new IllegalArgumentException("Max blocks must be >= -1");
        }
        this.maxBlocks = maxBlocks;
        this.blockBag = blockBag;
        this.world = world;
    }

    public boolean rawSetBlock(Vector pt2, BaseBlock block) {
        int y2 = pt2.getBlockY();
        int type = block.getType();
        if (y2 < 0 || y2 > this.world.getMaxY()) {
            return false;
        }
        this.world.checkLoadedChunk(pt2);
        if (!this.world.isValidBlockType(type)) {
            return false;
        }
        if (this.mask != null && !this.mask.matches(this, pt2)) {
            return false;
        }
        int existing = this.world.getBlockType(pt2);
        if (BlockType.isContainerBlock(existing) && this.blockBag == null) {
            this.world.clearContainerBlockContents(pt2);
        } else if (existing == 79) {
            this.world.setBlockType(pt2, 0);
        }
        if (this.blockBag != null) {
            if (type > 0) {
                try {
                    this.blockBag.fetchPlacedBlock(type, 0);
                }
                catch (UnplaceableBlockException e2) {
                    return false;
                }
                catch (BlockBagException e3) {
                    this.missingBlocks.add(type);
                    return false;
                }
            }
            if (existing > 0) {
                try {
                    this.blockBag.storeDroppedBlock(existing, this.world.getBlockData(pt2));
                }
                catch (BlockBagException e4) {
                    // empty catch block
                }
            }
        }
        boolean result = this.world.usesBlockData(type) ? (this.fastMode ? this.world.setTypeIdAndDataFast(pt2, type, block.getData() > -1 ? block.getData() : 0) : this.world.setTypeIdAndData(pt2, type, block.getData() > -1 ? block.getData() : 0)) : (this.fastMode ? this.world.setBlockTypeFast(pt2, type) : this.world.setBlockType(pt2, type));
        if (type != 0) {
            if (block instanceof ContainerBlock) {
                if (this.blockBag == null) {
                    this.world.copyToWorld(pt2, block);
                }
            } else if (block instanceof TileEntityBlock) {
                this.world.copyToWorld(pt2, block);
            }
        }
        return result;
    }

    public boolean setBlock(Vector pt2, BaseBlock block) throws MaxChangedBlocksException {
        BlockVector blockPt = pt2.toBlockVector();
        this.original.put((com.sk89q.worldedit.BlockVector)blockPt, (com.sk89q.worldedit.blocks.BaseBlock)this.getBlock(pt2));
        if (this.maxBlocks != -1 && this.original.size() > this.maxBlocks) {
            throw new MaxChangedBlocksException(this.maxBlocks);
        }
        this.current.put((com.sk89q.worldedit.BlockVector)pt2.toBlockVector(), (com.sk89q.worldedit.blocks.BaseBlock)block);
        return this.smartSetBlock(pt2, block);
    }

    public void rememberChange(Vector pt2, BaseBlock existing, BaseBlock block) {
        BlockVector blockPt = pt2.toBlockVector();
        this.original.put((com.sk89q.worldedit.BlockVector)blockPt, (com.sk89q.worldedit.blocks.BaseBlock)existing);
        this.current.put((com.sk89q.worldedit.BlockVector)pt2.toBlockVector(), (com.sk89q.worldedit.blocks.BaseBlock)block);
    }

    public boolean setBlock(Vector pt2, Pattern pat) throws MaxChangedBlocksException {
        return this.setBlock(pt2, pat.next(pt2));
    }

    public boolean setBlockIfAir(Vector pt2, BaseBlock block) throws MaxChangedBlocksException {
        if (!this.getBlock(pt2).isAir()) {
            return false;
        }
        return this.setBlock(pt2, block);
    }

    public boolean smartSetBlock(Vector pt2, BaseBlock block) {
        if (this.queued) {
            if (BlockType.shouldPlaceLast(block.getType())) {
                this.queueLast.put((com.sk89q.worldedit.BlockVector)pt2.toBlockVector(), (com.sk89q.worldedit.blocks.BaseBlock)block);
                return this.getBlockType(pt2) != block.getType() || this.getBlockData(pt2) != block.getData();
            }
            if (BlockType.shouldPlaceFinal(block.getType())) {
                this.queueFinal.put((com.sk89q.worldedit.BlockVector)pt2.toBlockVector(), (com.sk89q.worldedit.blocks.BaseBlock)block);
                return this.getBlockType(pt2) != block.getType() || this.getBlockData(pt2) != block.getData();
            }
            if (BlockType.shouldPlaceLast(this.getBlockType(pt2))) {
                this.rawSetBlock(pt2, new BaseBlock(0));
            } else {
                this.queueAfter.put((com.sk89q.worldedit.BlockVector)pt2.toBlockVector(), (com.sk89q.worldedit.blocks.BaseBlock)block);
                return this.getBlockType(pt2) != block.getType() || this.getBlockData(pt2) != block.getData();
            }
        }
        return this.rawSetBlock(pt2, block);
    }

    public BaseBlock getBlock(Vector pt2) {
        if (this.queued) {
            // empty if block
        }
        return this.rawGetBlock(pt2);
    }

    public int getBlockType(Vector pt2) {
        if (this.queued) {
            // empty if block
        }
        return this.world.getBlockType(pt2);
    }

    public int getBlockData(Vector pt2) {
        if (this.queued) {
            // empty if block
        }
        return this.world.getBlockData(pt2);
    }

    public BaseBlock rawGetBlock(Vector pt2) {
        this.world.checkLoadedChunk(pt2);
        int type = this.world.getBlockType(pt2);
        int data = this.world.getBlockData(pt2);
        switch (type) {
            case 63: 
            case 68: {
                SignBlock block = new SignBlock(type, data);
                this.world.copyFromWorld(pt2, block);
                return block;
            }
            case 54: {
                ChestBlock block = new ChestBlock(data);
                this.world.copyFromWorld(pt2, block);
                return block;
            }
            case 61: 
            case 62: {
                FurnaceBlock block = new FurnaceBlock(type, data);
                this.world.copyFromWorld(pt2, block);
                return block;
            }
            case 23: {
                DispenserBlock block = new DispenserBlock(data);
                this.world.copyFromWorld(pt2, block);
                return block;
            }
            case 52: {
                MobSpawnerBlock block = new MobSpawnerBlock(data);
                this.world.copyFromWorld(pt2, block);
                return block;
            }
            case 25: {
                NoteBlock block = new NoteBlock(data);
                this.world.copyFromWorld(pt2, block);
                return block;
            }
        }
        return new BaseBlock(type, data);
    }

    public void undo(EditSession sess) {
        for (Map.Entry<com.sk89q.worldedit.BlockVector, com.sk89q.worldedit.blocks.BaseBlock> entry : this.original) {
            BlockVector pt2 = (BlockVector)entry.getKey();
            sess.smartSetBlock(pt2, (BaseBlock)entry.getValue());
        }
        sess.flushQueue();
    }

    public void redo(EditSession sess) {
        for (Map.Entry<com.sk89q.worldedit.BlockVector, com.sk89q.worldedit.blocks.BaseBlock> entry : this.current) {
            BlockVector pt2 = (BlockVector)entry.getKey();
            sess.smartSetBlock(pt2, (BaseBlock)entry.getValue());
        }
        sess.flushQueue();
    }

    public int size() {
        return this.original.size();
    }

    public int getBlockChangeLimit() {
        return this.maxBlocks;
    }

    public void setBlockChangeLimit(int maxBlocks) {
        if (maxBlocks < -1) {
            throw new IllegalArgumentException("Max blocks must be >= -1");
        }
        this.maxBlocks = maxBlocks;
    }

    public boolean isQueueEnabled() {
        return this.queued;
    }

    public void enableQueue() {
        this.queued = true;
    }

    public void disableQueue() {
        if (this.queued) {
            this.flushQueue();
        }
        this.queued = false;
    }

    public void setFastMode(boolean fastMode) {
        this.fastMode = fastMode;
    }

    public boolean hasFastMode() {
        return this.fastMode;
    }

    public boolean setChanceBlockIfAir(Vector pos, BaseBlock block, double c2) throws MaxChangedBlocksException {
        if (Math.random() <= c2) {
            return this.setBlockIfAir(pos, block);
        }
        return false;
    }

    public int countBlocks(Region region, Set<Integer> searchIDs) {
        int count = 0;
        if (region instanceof CuboidRegion) {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            int minX = min.getBlockX();
            int minY = min.getBlockY();
            int minZ = min.getBlockZ();
            int maxX = max.getBlockX();
            int maxY = max.getBlockY();
            int maxZ = max.getBlockZ();
            for (int x2 = minX; x2 <= maxX; ++x2) {
                for (int y2 = minY; y2 <= maxY; ++y2) {
                    for (int z2 = minZ; z2 <= maxZ; ++z2) {
                        Vector pt2 = new Vector(x2, y2, z2);
                        if (!searchIDs.contains(this.getBlockType(pt2))) continue;
                        ++count;
                    }
                }
            }
        } else {
            for (BlockVector pt3 : region) {
                if (!searchIDs.contains(this.getBlockType(pt3))) continue;
                ++count;
            }
        }
        return count;
    }

    public int getHighestTerrainBlock(int x2, int z2, int minY, int maxY) {
        return this.getHighestTerrainBlock(x2, z2, minY, maxY, false);
    }

    public int getHighestTerrainBlock(int x2, int z2, int minY, int maxY, boolean naturalOnly) {
        for (int y2 = maxY; y2 >= minY; --y2) {
            Vector pt2 = new Vector(x2, y2, z2);
            int id2 = this.getBlockType(pt2);
            if (!(naturalOnly ? BlockType.isNaturalTerrainBlock(id2) : !BlockType.canPassThrough(id2))) continue;
            return y2;
        }
        return minY;
    }

    public Set<Integer> popMissingBlocks() {
        Set<Integer> missingBlocks = this.missingBlocks;
        this.missingBlocks = new HashSet<Integer>();
        return missingBlocks;
    }

    public BlockBag getBlockBag() {
        return this.blockBag;
    }

    public void setBlockBag(BlockBag blockBag) {
        this.blockBag = blockBag;
    }

    public LocalWorld getWorld() {
        return this.world;
    }

    public int getBlockChangeCount() {
        return this.original.size();
    }

    public Mask getMask() {
        return this.mask;
    }

    public void setMask(Mask mask) {
        this.mask = mask;
    }

    public void flushQueue() {
        if (!this.queued) {
            return;
        }
        HashSet<com.sk89q.worldedit.BlockVector2D> dirtyChunks = new HashSet<com.sk89q.worldedit.BlockVector2D>();
        for (Map.Entry<com.sk89q.worldedit.BlockVector, com.sk89q.worldedit.blocks.BaseBlock> entry : this.queueAfter) {
            BlockVector pt2 = (BlockVector)entry.getKey();
            this.rawSetBlock(pt2, (BaseBlock)entry.getValue());
            if (!this.fastMode) continue;
            dirtyChunks.add((com.sk89q.worldedit.BlockVector2D)new BlockVector2D(pt2.getBlockX() >> 4, pt2.getBlockZ() >> 4));
        }
        if (this.blockBag == null || this.missingBlocks.size() == 0) {
            for (Map.Entry<com.sk89q.worldedit.BlockVector, com.sk89q.worldedit.blocks.BaseBlock> entry : this.queueLast) {
                BlockVector pt2 = (BlockVector)entry.getKey();
                this.rawSetBlock(pt2, (BaseBlock)entry.getValue());
                if (!this.fastMode) continue;
                dirtyChunks.add((com.sk89q.worldedit.BlockVector2D)new BlockVector2D(pt2.getBlockX() >> 4, pt2.getBlockZ() >> 4));
            }
            HashSet<BlockVector> blocks = new HashSet<BlockVector>();
            HashMap<BlockVector, com.sk89q.worldedit.blocks.BaseBlock> hashMap = new HashMap<BlockVector, com.sk89q.worldedit.blocks.BaseBlock>();
            for (Map.Entry<com.sk89q.worldedit.BlockVector, com.sk89q.worldedit.blocks.BaseBlock> entry : this.queueFinal) {
                BlockVector pt3 = (BlockVector)entry.getKey();
                blocks.add(pt3);
                hashMap.put(pt3, entry.getValue());
            }
            while (!blocks.isEmpty()) {
                int data;
                int type;
                PlayerDirection attachment;
                BlockVector current = (BlockVector)blocks.iterator().next();
                if (!blocks.contains(current)) continue;
                LinkedList<BlockVector> linkedList = new LinkedList<BlockVector>();
                block7: do {
                    linkedList.addFirst(current);
                    assert (hashMap.containsKey(current));
                    BaseBlock baseBlock = (BaseBlock)hashMap.get(current);
                    type = baseBlock.getType();
                    data = baseBlock.getData();
                    switch (type) {
                        case 64: 
                        case 71: {
                            BlockVector upperBlock;
                            if ((data & 8) != 0 || !blocks.contains(upperBlock = current.add(0, 1, 0).toBlockVector()) || linkedList.contains(upperBlock)) continue block7;
                            linkedList.addFirst(upperBlock);
                        }
                    }
                } while ((attachment = BlockType.getAttachment(type, data)) != null && blocks.contains(current = current.add(attachment.vector()).toBlockVector()) && !linkedList.contains(current));
                for (BlockVector pt4 : linkedList) {
                    this.rawSetBlock(pt4, (BaseBlock)hashMap.get(pt4));
                    blocks.remove(pt4);
                    if (!this.fastMode) continue;
                    dirtyChunks.add((com.sk89q.worldedit.BlockVector2D)new BlockVector2D(pt4.getBlockX() >> 4, pt4.getBlockZ() >> 4));
                }
            }
        }
        if (!dirtyChunks.isEmpty()) {
            this.world.fixAfterFastMode(dirtyChunks);
        }
        this.queueAfter.clear();
        this.queueLast.clear();
        this.queueFinal.clear();
    }

    public int fillXZ(Vector origin, BaseBlock block, double radius, int depth, boolean recursive) throws MaxChangedBlocksException {
        int affected = 0;
        int originX = origin.getBlockX();
        int originY = origin.getBlockY();
        int originZ = origin.getBlockZ();
        HashSet<BlockVector> visited = new HashSet<BlockVector>();
        Stack<BlockVector> queue = new Stack<BlockVector>();
        queue.push(new BlockVector(originX, originY, originZ));
        while (!queue.empty()) {
            BlockVector pt2 = (BlockVector)queue.pop();
            int cx2 = pt2.getBlockX();
            int cy2 = pt2.getBlockY();
            int cz2 = pt2.getBlockZ();
            if (cy2 < 0 || cy2 > originY || visited.contains(pt2)) continue;
            visited.add(pt2);
            if (recursive) {
                if (origin.distance(pt2) > radius || !this.getBlock(pt2).isAir()) continue;
                if (this.setBlock((Vector)pt2, block)) {
                    ++affected;
                }
                queue.push(new BlockVector(cx2, cy2 - 1, cz2));
                queue.push(new BlockVector(cx2, cy2 + 1, cz2));
            } else {
                double dist = Math.sqrt(Math.pow(originX - cx2, 2.0) + Math.pow(originZ - cz2, 2.0));
                int minY = originY - depth + 1;
                if (dist > radius || !this.getBlock(pt2).isAir()) continue;
                affected += this.fillY(cx2, originY, cz2, block, minY);
            }
            queue.push(new BlockVector(cx2 + 1, cy2, cz2));
            queue.push(new BlockVector(cx2 - 1, cy2, cz2));
            queue.push(new BlockVector(cx2, cy2, cz2 + 1));
            queue.push(new BlockVector(cx2, cy2, cz2 - 1));
        }
        return affected;
    }

    private int fillY(int x2, int cy2, int z2, BaseBlock block, int minY) throws MaxChangedBlocksException {
        Vector pt2;
        int affected = 0;
        for (int y2 = cy2; y2 >= minY && this.getBlock(pt2 = new Vector(x2, y2, z2)).isAir(); --y2) {
            this.setBlock(pt2, block);
            ++affected;
        }
        return affected;
    }

    public int fillXZ(Vector origin, Pattern pattern, double radius, int depth, boolean recursive) throws MaxChangedBlocksException {
        int affected = 0;
        int originX = origin.getBlockX();
        int originY = origin.getBlockY();
        int originZ = origin.getBlockZ();
        HashSet<BlockVector> visited = new HashSet<BlockVector>();
        Stack<BlockVector> queue = new Stack<BlockVector>();
        queue.push(new BlockVector(originX, originY, originZ));
        while (!queue.empty()) {
            BlockVector pt2 = (BlockVector)queue.pop();
            int cx2 = pt2.getBlockX();
            int cy2 = pt2.getBlockY();
            int cz2 = pt2.getBlockZ();
            if (cy2 < 0 || cy2 > originY || visited.contains(pt2)) continue;
            visited.add(pt2);
            if (recursive) {
                if (origin.distance(pt2) > radius || !this.getBlock(pt2).isAir()) continue;
                if (this.setBlock((Vector)pt2, pattern.next(pt2))) {
                    ++affected;
                }
                queue.push(new BlockVector(cx2, cy2 - 1, cz2));
                queue.push(new BlockVector(cx2, cy2 + 1, cz2));
            } else {
                double dist = Math.sqrt(Math.pow(originX - cx2, 2.0) + Math.pow(originZ - cz2, 2.0));
                int minY = originY - depth + 1;
                if (dist > radius || !this.getBlock(pt2).isAir()) continue;
                affected += this.fillY(cx2, originY, cz2, pattern, minY);
            }
            queue.push(new BlockVector(cx2 + 1, cy2, cz2));
            queue.push(new BlockVector(cx2 - 1, cy2, cz2));
            queue.push(new BlockVector(cx2, cy2, cz2 + 1));
            queue.push(new BlockVector(cx2, cy2, cz2 - 1));
        }
        return affected;
    }

    private int fillY(int x2, int cy2, int z2, Pattern pattern, int minY) throws MaxChangedBlocksException {
        Vector pt2;
        int affected = 0;
        for (int y2 = cy2; y2 >= minY && this.getBlock(pt2 = new Vector(x2, y2, z2)).isAir(); --y2) {
            this.setBlock(pt2, pattern.next(pt2));
            ++affected;
        }
        return affected;
    }

    public int removeAbove(Vector pos, int size, int height) throws MaxChangedBlocksException {
        int maxY = Math.min(this.world.getMaxY(), pos.getBlockY() + height - 1);
        int affected = 0;
        int oX = pos.getBlockX();
        int oY = pos.getBlockY();
        int oZ = pos.getBlockZ();
        for (int x2 = oX - --size; x2 <= oX + size; ++x2) {
            for (int z2 = oZ - size; z2 <= oZ + size; ++z2) {
                for (int y2 = oY; y2 <= maxY; ++y2) {
                    Vector pt2 = new Vector(x2, y2, z2);
                    if (this.getBlockType(pt2) == 0) continue;
                    this.setBlock(pt2, new BaseBlock(0));
                    ++affected;
                }
            }
        }
        return affected;
    }

    public int removeBelow(Vector pos, int size, int height) throws MaxChangedBlocksException {
        int minY = Math.max(0, pos.getBlockY() - height);
        int affected = 0;
        int oX = pos.getBlockX();
        int oY = pos.getBlockY();
        int oZ = pos.getBlockZ();
        for (int x2 = oX - --size; x2 <= oX + size; ++x2) {
            for (int z2 = oZ - size; z2 <= oZ + size; ++z2) {
                for (int y2 = oY; y2 >= minY; --y2) {
                    Vector pt2 = new Vector(x2, y2, z2);
                    if (this.getBlockType(pt2) == 0) continue;
                    this.setBlock(pt2, new BaseBlock(0));
                    ++affected;
                }
            }
        }
        return affected;
    }

    public int removeNear(Vector pos, int blockType, int size) throws MaxChangedBlocksException {
        int affected = 0;
        BaseBlock air2 = new BaseBlock(0);
        int minX = pos.getBlockX() - size;
        int maxX = pos.getBlockX() + size;
        int minY = Math.max(0, pos.getBlockY() - size);
        int maxY = Math.min(this.world.getMaxY(), pos.getBlockY() + size);
        int minZ = pos.getBlockZ() - size;
        int maxZ = pos.getBlockZ() + size;
        for (int x2 = minX; x2 <= maxX; ++x2) {
            for (int y2 = minY; y2 <= maxY; ++y2) {
                for (int z2 = minZ; z2 <= maxZ; ++z2) {
                    Vector p2 = new Vector(x2, y2, z2);
                    if (this.getBlockType(p2) != blockType || !this.setBlock(p2, air2)) continue;
                    ++affected;
                }
            }
        }
        return affected;
    }

    public int setBlocks(Region region, BaseBlock block) throws MaxChangedBlocksException {
        int affected = 0;
        if (region instanceof CuboidRegion) {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            int minX = min.getBlockX();
            int minY = min.getBlockY();
            int minZ = min.getBlockZ();
            int maxX = max.getBlockX();
            int maxY = max.getBlockY();
            int maxZ = max.getBlockZ();
            for (int x2 = minX; x2 <= maxX; ++x2) {
                for (int y2 = minY; y2 <= maxY; ++y2) {
                    for (int z2 = minZ; z2 <= maxZ; ++z2) {
                        Vector pt2 = new Vector(x2, y2, z2);
                        if (!this.setBlock(pt2, block)) continue;
                        ++affected;
                    }
                }
            }
        } else {
            for (BlockVector pt3 : region) {
                if (!this.setBlock((Vector)pt3, block)) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int setBlocks(Region region, Pattern pattern) throws MaxChangedBlocksException {
        int affected = 0;
        if (region instanceof CuboidRegion) {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            int minX = min.getBlockX();
            int minY = min.getBlockY();
            int minZ = min.getBlockZ();
            int maxX = max.getBlockX();
            int maxY = max.getBlockY();
            int maxZ = max.getBlockZ();
            for (int x2 = minX; x2 <= maxX; ++x2) {
                for (int y2 = minY; y2 <= maxY; ++y2) {
                    for (int z2 = minZ; z2 <= maxZ; ++z2) {
                        Vector pt2 = new Vector(x2, y2, z2);
                        if (!this.setBlock(pt2, pattern.next(pt2))) continue;
                        ++affected;
                    }
                }
            }
        } else {
            for (BlockVector pt3 : region) {
                if (!this.setBlock((Vector)pt3, pattern.next(pt3))) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int replaceBlocks(Region region, Set<com.sk89q.worldedit.blocks.BaseBlock> fromBlockTypes, BaseBlock toBlock) throws MaxChangedBlocksException {
        HashSet<BaseBlock> definiteBlockTypes = new HashSet<BaseBlock>();
        HashSet<Integer> fuzzyBlockTypes = new HashSet<Integer>();
        if (fromBlockTypes != null) {
            for (BaseBlock baseBlock : fromBlockTypes) {
                if (baseBlock.getData() == -1) {
                    fuzzyBlockTypes.add(baseBlock.getType());
                    continue;
                }
                definiteBlockTypes.add(baseBlock);
            }
        }
        int affected = 0;
        if (region instanceof CuboidRegion) {
            Vector vector = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            int minX = vector.getBlockX();
            int minY = vector.getBlockY();
            int minZ = vector.getBlockZ();
            int maxX = max.getBlockX();
            int maxY = max.getBlockY();
            int maxZ = max.getBlockZ();
            for (int x2 = minX; x2 <= maxX; ++x2) {
                for (int y2 = minY; y2 <= maxY; ++y2) {
                    for (int z2 = minZ; z2 <= maxZ; ++z2) {
                        Vector pt2 = new Vector(x2, y2, z2);
                        BaseBlock curBlockType = this.getBlock(pt2);
                        if (fromBlockTypes != null ? !definiteBlockTypes.contains(curBlockType) && !fuzzyBlockTypes.contains(curBlockType.getType()) : curBlockType.isAir()) continue;
                        if (!this.setBlock(pt2, toBlock)) continue;
                        ++affected;
                    }
                }
            }
        } else {
            for (BlockVector pt3 : region) {
                BaseBlock curBlockType = this.getBlock(pt3);
                if (fromBlockTypes != null ? !definiteBlockTypes.contains(curBlockType) && !fuzzyBlockTypes.contains(curBlockType.getType()) : curBlockType.isAir()) continue;
                if (!this.setBlock((Vector)pt3, toBlock)) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int replaceBlocks(Region region, Set<com.sk89q.worldedit.blocks.BaseBlock> fromBlockTypes, Pattern pattern) throws MaxChangedBlocksException {
        HashSet<BaseBlock> definiteBlockTypes = new HashSet<BaseBlock>();
        HashSet<Integer> fuzzyBlockTypes = new HashSet<Integer>();
        if (fromBlockTypes != null) {
            for (BaseBlock baseBlock : fromBlockTypes) {
                if (baseBlock.getData() == -1) {
                    fuzzyBlockTypes.add(baseBlock.getType());
                    continue;
                }
                definiteBlockTypes.add(baseBlock);
            }
        }
        int affected = 0;
        if (region instanceof CuboidRegion) {
            Vector vector = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            int minX = vector.getBlockX();
            int minY = vector.getBlockY();
            int minZ = vector.getBlockZ();
            int maxX = max.getBlockX();
            int maxY = max.getBlockY();
            int maxZ = max.getBlockZ();
            for (int x2 = minX; x2 <= maxX; ++x2) {
                for (int y2 = minY; y2 <= maxY; ++y2) {
                    for (int z2 = minZ; z2 <= maxZ; ++z2) {
                        Vector pt2 = new Vector(x2, y2, z2);
                        BaseBlock curBlockType = this.getBlock(pt2);
                        if (fromBlockTypes != null ? !definiteBlockTypes.contains(curBlockType) && !fuzzyBlockTypes.contains(curBlockType.getType()) : curBlockType.isAir()) continue;
                        if (!this.setBlock(pt2, pattern.next(pt2))) continue;
                        ++affected;
                    }
                }
            }
        } else {
            for (BlockVector pt3 : region) {
                BaseBlock curBlockType = this.getBlock(pt3);
                if (fromBlockTypes != null ? !definiteBlockTypes.contains(curBlockType) && !fuzzyBlockTypes.contains(curBlockType.getType()) : curBlockType.isAir()) continue;
                if (!this.setBlock((Vector)pt3, pattern.next(pt3))) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int makeCuboidFaces(Region region, BaseBlock block) throws MaxChangedBlocksException {
        int affected = 0;
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int minX = min.getBlockX();
        int minY = min.getBlockY();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxY = max.getBlockY();
        int maxZ = max.getBlockZ();
        for (int x2 = minX; x2 <= maxX; ++x2) {
            for (int y2 = minY; y2 <= maxY; ++y2) {
                if (this.setBlock(new Vector(x2, y2, minZ), block)) {
                    ++affected;
                }
                if (this.setBlock(new Vector(x2, y2, maxZ), block)) {
                    ++affected;
                }
                ++affected;
            }
        }
        for (int y3 = minY; y3 <= maxY; ++y3) {
            for (int z2 = minZ; z2 <= maxZ; ++z2) {
                if (this.setBlock(new Vector(minX, y3, z2), block)) {
                    ++affected;
                }
                if (!this.setBlock(new Vector(maxX, y3, z2), block)) continue;
                ++affected;
            }
        }
        for (int z3 = minZ; z3 <= maxZ; ++z3) {
            for (int x3 = minX; x3 <= maxX; ++x3) {
                if (this.setBlock(new Vector(x3, minY, z3), block)) {
                    ++affected;
                }
                if (!this.setBlock(new Vector(x3, maxY, z3), block)) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int makeCuboidFaces(Region region, Pattern pattern) throws MaxChangedBlocksException {
        Vector maxV;
        Vector minV;
        int affected = 0;
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int minX = min.getBlockX();
        int minY = min.getBlockY();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxY = max.getBlockY();
        int maxZ = max.getBlockZ();
        for (int x2 = minX; x2 <= maxX; ++x2) {
            for (int y2 = minY; y2 <= maxY; ++y2) {
                minV = new Vector(x2, y2, minZ);
                if (this.setBlock(minV, pattern.next(minV))) {
                    ++affected;
                }
                if (this.setBlock(maxV = new Vector(x2, y2, maxZ), pattern.next(maxV))) {
                    ++affected;
                }
                ++affected;
            }
        }
        for (int y3 = minY; y3 <= maxY; ++y3) {
            for (int z2 = minZ; z2 <= maxZ; ++z2) {
                minV = new Vector(minX, y3, z2);
                if (this.setBlock(minV, pattern.next(minV))) {
                    ++affected;
                }
                if (!this.setBlock(maxV = new Vector(maxX, y3, z2), pattern.next(maxV))) continue;
                ++affected;
            }
        }
        for (int z3 = minZ; z3 <= maxZ; ++z3) {
            for (int x3 = minX; x3 <= maxX; ++x3) {
                minV = new Vector(x3, minY, z3);
                if (this.setBlock(minV, pattern.next(minV))) {
                    ++affected;
                }
                if (!this.setBlock(maxV = new Vector(x3, maxY, z3), pattern.next(maxV))) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int makeCuboidWalls(Region region, BaseBlock block) throws MaxChangedBlocksException {
        int affected = 0;
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int minX = min.getBlockX();
        int minY = min.getBlockY();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxY = max.getBlockY();
        int maxZ = max.getBlockZ();
        for (int x2 = minX; x2 <= maxX; ++x2) {
            for (int y2 = minY; y2 <= maxY; ++y2) {
                if (this.setBlock(new Vector(x2, y2, minZ), block)) {
                    ++affected;
                }
                if (this.setBlock(new Vector(x2, y2, maxZ), block)) {
                    ++affected;
                }
                ++affected;
            }
        }
        for (int y3 = minY; y3 <= maxY; ++y3) {
            for (int z2 = minZ; z2 <= maxZ; ++z2) {
                if (this.setBlock(new Vector(minX, y3, z2), block)) {
                    ++affected;
                }
                if (!this.setBlock(new Vector(maxX, y3, z2), block)) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int makeCuboidWalls(Region region, Pattern pattern) throws MaxChangedBlocksException {
        Vector maxV;
        Vector minV;
        int affected = 0;
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int minX = min.getBlockX();
        int minY = min.getBlockY();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxY = max.getBlockY();
        int maxZ = max.getBlockZ();
        for (int x2 = minX; x2 <= maxX; ++x2) {
            for (int y2 = minY; y2 <= maxY; ++y2) {
                minV = new Vector(x2, y2, minZ);
                if (this.setBlock(minV, pattern.next(minV))) {
                    ++affected;
                }
                if (this.setBlock(maxV = new Vector(x2, y2, maxZ), pattern.next(maxV))) {
                    ++affected;
                }
                ++affected;
            }
        }
        for (int y3 = minY; y3 <= maxY; ++y3) {
            for (int z2 = minZ; z2 <= maxZ; ++z2) {
                minV = new Vector(minX, y3, z2);
                if (this.setBlock(minV, pattern.next(minV))) {
                    ++affected;
                }
                if (!this.setBlock(maxV = new Vector(maxX, y3, z2), pattern.next(maxV))) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int overlayCuboidBlocks(Region region, BaseBlock block) throws MaxChangedBlocksException {
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int upperY = Math.min(this.world.getMaxY(), max.getBlockY() + 1);
        int lowerY = Math.max(0, min.getBlockY() - 1);
        int affected = 0;
        int minX = min.getBlockX();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxZ = max.getBlockZ();
        for (int x2 = minX; x2 <= maxX; ++x2) {
            block1: for (int z2 = minZ; z2 <= maxZ; ++z2) {
                for (int y2 = upperY; y2 >= lowerY; --y2) {
                    Vector above = new Vector(x2, y2 + 1, z2);
                    if (y2 + 1 > this.world.getMaxY() || this.getBlock(new Vector(x2, y2, z2)).isAir() || !this.getBlock(above).isAir()) continue;
                    if (!this.setBlock(above, block)) continue block1;
                    ++affected;
                    continue block1;
                }
            }
        }
        return affected;
    }

    public int overlayCuboidBlocks(Region region, Pattern pattern) throws MaxChangedBlocksException {
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int upperY = Math.min(this.world.getMaxY(), max.getBlockY() + 1);
        int lowerY = Math.max(0, min.getBlockY() - 1);
        int affected = 0;
        int minX = min.getBlockX();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxZ = max.getBlockZ();
        for (int x2 = minX; x2 <= maxX; ++x2) {
            block1: for (int z2 = minZ; z2 <= maxZ; ++z2) {
                for (int y2 = upperY; y2 >= lowerY; --y2) {
                    Vector above = new Vector(x2, y2 + 1, z2);
                    if (y2 + 1 > this.world.getMaxY() || this.getBlock(new Vector(x2, y2, z2)).isAir() || !this.getBlock(above).isAir()) continue;
                    if (!this.setBlock(above, pattern.next(above))) continue block1;
                    ++affected;
                    continue block1;
                }
            }
        }
        return affected;
    }

    public int naturalizeCuboidBlocks(Region region) throws MaxChangedBlocksException {
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int upperY = Math.min(this.world.getMaxY(), max.getBlockY() + 1);
        int lowerY = Math.max(0, min.getBlockY() - 1);
        int affected = 0;
        int minX = min.getBlockX();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxZ = max.getBlockZ();
        BaseBlock grass = new BaseBlock(2);
        BaseBlock dirt = new BaseBlock(3);
        BaseBlock stone = new BaseBlock(1);
        for (int x2 = minX; x2 <= maxX; ++x2) {
            for (int z2 = minZ; z2 <= maxZ; ++z2) {
                int level = -1;
                for (int y2 = upperY; y2 >= lowerY; --y2) {
                    boolean isTransformable;
                    Vector pt2 = new Vector(x2, y2, z2);
                    int blockType = this.getBlockType(pt2);
                    boolean bl2 = isTransformable = blockType == 2 || blockType == 3 || blockType == 1;
                    if (level == -1) {
                        if (!isTransformable) continue;
                        level = 0;
                    }
                    if (level < 0) continue;
                    if (isTransformable) {
                        if (level == 0) {
                            this.setBlock(pt2, grass);
                            ++affected;
                        } else if (level <= 2) {
                            this.setBlock(pt2, dirt);
                            ++affected;
                        } else {
                            this.setBlock(pt2, stone);
                            ++affected;
                        }
                    }
                    ++level;
                }
            }
        }
        return affected;
    }

    public int stackCuboidRegion(Region region, Vector dir, int count, boolean copyAir) throws MaxChangedBlocksException {
        int affected = 0;
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int minX = min.getBlockX();
        int minY = min.getBlockY();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxY = max.getBlockY();
        int maxZ = max.getBlockZ();
        int xs2 = region.getWidth();
        int ys2 = region.getHeight();
        int zs2 = region.getLength();
        for (int x2 = minX; x2 <= maxX; ++x2) {
            for (int z2 = minZ; z2 <= maxZ; ++z2) {
                for (int y2 = minY; y2 <= maxY; ++y2) {
                    BaseBlock block = this.getBlock(new Vector(x2, y2, z2));
                    if (block.isAir() && !copyAir) continue;
                    for (int i2 = 1; i2 <= count; ++i2) {
                        Vector pos = new Vector(x2 + xs2 * dir.getBlockX() * i2, y2 + ys2 * dir.getBlockY() * i2, z2 + zs2 * dir.getBlockZ() * i2);
                        if (!this.setBlock(pos, block)) continue;
                        ++affected;
                    }
                }
            }
        }
        return affected;
    }

    public int moveCuboidRegion(Region region, Vector dir, int distance, boolean copyAir, BaseBlock replace) throws MaxChangedBlocksException {
        int affected = 0;
        Vector shift = dir.multiply(distance);
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int minX = min.getBlockX();
        int minY = min.getBlockY();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxY = max.getBlockY();
        int maxZ = max.getBlockZ();
        Vector newMin = min.add(shift);
        Vector newMax = min.add(shift);
        LinkedHashMap<Vector, BaseBlock> delayed = new LinkedHashMap<Vector, BaseBlock>();
        for (int x2 = minX; x2 <= maxX; ++x2) {
            for (int z2 = minZ; z2 <= maxZ; ++z2) {
                for (int y2 = minY; y2 <= maxY; ++y2) {
                    Vector pos = new Vector(x2, y2, z2);
                    BaseBlock block = this.getBlock(pos);
                    if (block.isAir() && !copyAir) continue;
                    Vector newPos = pos.add(shift);
                    delayed.put(newPos, this.getBlock(pos));
                    if (x2 >= newMin.getBlockX() && x2 <= newMax.getBlockX() && y2 >= newMin.getBlockY() && y2 <= newMax.getBlockY() && z2 >= newMin.getBlockZ() && z2 <= newMax.getBlockZ()) continue;
                    this.setBlock(pos, replace);
                }
            }
        }
        for (Map.Entry entry : delayed.entrySet()) {
            this.setBlock((Vector)entry.getKey(), (BaseBlock)entry.getValue());
            ++affected;
        }
        return affected;
    }

    public int drainArea(Vector pos, double radius) throws MaxChangedBlocksException {
        int affected = 0;
        HashSet<BlockVector> visited = new HashSet<BlockVector>();
        Stack<BlockVector> queue = new Stack<BlockVector>();
        for (int x2 = pos.getBlockX() - 1; x2 <= pos.getBlockX() + 1; ++x2) {
            for (int z2 = pos.getBlockZ() - 1; z2 <= pos.getBlockZ() + 1; ++z2) {
                for (int y2 = pos.getBlockY() - 1; y2 <= pos.getBlockY() + 1; ++y2) {
                    queue.push(new BlockVector(x2, y2, z2));
                }
            }
        }
        while (!queue.empty()) {
            BlockVector cur = (BlockVector)queue.pop();
            int type = this.getBlockType(cur);
            if (type != 8 && type != 9 && type != 10 && type != 11 || visited.contains(cur)) continue;
            visited.add(cur);
            if (pos.distance(cur) > radius) continue;
            for (int x3 = cur.getBlockX() - 1; x3 <= cur.getBlockX() + 1; ++x3) {
                for (int z3 = cur.getBlockZ() - 1; z3 <= cur.getBlockZ() + 1; ++z3) {
                    for (int y3 = cur.getBlockY() - 1; y3 <= cur.getBlockY() + 1; ++y3) {
                        BlockVector newPos = new BlockVector(x3, y3, z3);
                        if (cur.equals(newPos)) continue;
                        queue.push(newPos);
                    }
                }
            }
            if (!this.setBlock((Vector)cur, new BaseBlock(0))) continue;
            ++affected;
        }
        return affected;
    }

    public int fixLiquid(Vector pos, double radius, int moving, int stationary) throws MaxChangedBlocksException {
        int affected = 0;
        HashSet<BlockVector> visited = new HashSet<BlockVector>();
        Stack<BlockVector> queue = new Stack<BlockVector>();
        for (int x2 = pos.getBlockX() - 1; x2 <= pos.getBlockX() + 1; ++x2) {
            for (int z2 = pos.getBlockZ() - 1; z2 <= pos.getBlockZ() + 1; ++z2) {
                for (int y2 = pos.getBlockY() - 1; y2 <= pos.getBlockY() + 1; ++y2) {
                    int type = this.getBlock(new Vector(x2, y2, z2)).getType();
                    if (type != moving && type != stationary) continue;
                    queue.push(new BlockVector(x2, y2, z2));
                }
            }
        }
        BaseBlock stationaryBlock = new BaseBlock(stationary);
        while (!queue.empty()) {
            BlockVector cur = (BlockVector)queue.pop();
            int type = this.getBlockType(cur);
            if (type != moving && type != stationary && type != 0 || visited.contains(cur)) continue;
            visited.add(cur);
            if (this.setBlock((Vector)cur, stationaryBlock)) {
                ++affected;
            }
            if (pos.distance(cur) > radius) continue;
            queue.push(cur.add(1, 0, 0).toBlockVector());
            queue.push(cur.add(-1, 0, 0).toBlockVector());
            queue.push(cur.add(0, 0, 1).toBlockVector());
            queue.push(cur.add(0, 0, -1).toBlockVector());
        }
        return affected;
    }

    public int makeCylinder(Vector pos, Pattern block, double radius, int height, boolean filled) throws MaxChangedBlocksException {
        return this.makeCylinder(pos, block, radius, radius, height, filled);
    }

    public int makeCylinder(Vector pos, Pattern block, double radiusX, double radiusZ, int height, boolean filled) throws MaxChangedBlocksException {
        int affected = 0;
        radiusX += 0.5;
        radiusZ += 0.5;
        if (height == 0) {
            return 0;
        }
        if (height < 0) {
            height = -height;
            pos = pos.subtract(0, height, 0);
        }
        if (pos.getBlockY() < 0) {
            pos = pos.setY(0);
        } else if (pos.getBlockY() + height - 1 > this.world.getMaxY()) {
            height = this.world.getMaxY() - pos.getBlockY() + 1;
        }
        double invRadiusX = 1.0 / radiusX;
        double invRadiusZ = 1.0 / radiusZ;
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        double nextXn = 0.0;
        block0: for (int x2 = 0; x2 <= ceilRadiusX; ++x2) {
            double xn2 = nextXn;
            nextXn = (double)(x2 + 1) * invRadiusX;
            double nextZn = 0.0;
            for (int z2 = 0; z2 <= ceilRadiusZ; ++z2) {
                double zn2 = nextZn;
                nextZn = (double)(z2 + 1) * invRadiusZ;
                double distanceSq = EditSession.lengthSq(xn2, zn2);
                if (distanceSq > 1.0) {
                    if (z2 != 0) continue block0;
                    break block0;
                }
                if (!filled && EditSession.lengthSq(nextXn, zn2) <= 1.0 && EditSession.lengthSq(xn2, nextZn) <= 1.0) continue;
                for (int y2 = 0; y2 < height; ++y2) {
                    if (this.setBlock(pos.add(x2, y2, z2), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(-x2, y2, z2), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(x2, y2, -z2), block)) {
                        ++affected;
                    }
                    if (!this.setBlock(pos.add(-x2, y2, -z2), block)) continue;
                    ++affected;
                }
            }
        }
        return affected;
    }

    public int makeSphere(Vector pos, Pattern block, double radius, boolean filled) throws MaxChangedBlocksException {
        return this.makeSphere(pos, block, radius, radius, radius, filled);
    }

    public int makeSphere(Vector pos, Pattern block, double radiusX, double radiusY, double radiusZ, boolean filled) throws MaxChangedBlocksException {
        int affected = 0;
        double invRadiusX = 1.0 / (radiusX += 0.5);
        double invRadiusY = 1.0 / (radiusY += 0.5);
        double invRadiusZ = 1.0 / (radiusZ += 0.5);
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusY = (int)Math.ceil(radiusY);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        double nextXn = 0.0;
        block0: for (int x2 = 0; x2 <= ceilRadiusX; ++x2) {
            double xn2 = nextXn;
            nextXn = (double)(x2 + 1) * invRadiusX;
            double nextYn = 0.0;
            block1: for (int y2 = 0; y2 <= ceilRadiusY; ++y2) {
                double yn2 = nextYn;
                nextYn = (double)(y2 + 1) * invRadiusY;
                double nextZn = 0.0;
                for (int z2 = 0; z2 <= ceilRadiusZ; ++z2) {
                    double zn2 = nextZn;
                    nextZn = (double)(z2 + 1) * invRadiusZ;
                    double distanceSq = EditSession.lengthSq(xn2, yn2, zn2);
                    if (distanceSq > 1.0) {
                        if (z2 != 0) continue block1;
                        if (y2 != 0) continue block0;
                        break block0;
                    }
                    if (!filled && EditSession.lengthSq(nextXn, yn2, zn2) <= 1.0 && EditSession.lengthSq(xn2, nextYn, zn2) <= 1.0 && EditSession.lengthSq(xn2, yn2, nextZn) <= 1.0) continue;
                    if (this.setBlock(pos.add(x2, y2, z2), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(-x2, y2, z2), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(x2, -y2, z2), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(x2, y2, -z2), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(-x2, -y2, z2), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(x2, -y2, -z2), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(-x2, y2, -z2), block)) {
                        ++affected;
                    }
                    if (!this.setBlock(pos.add(-x2, -y2, -z2), block)) continue;
                    ++affected;
                }
            }
        }
        return affected;
    }

    private static final double lengthSq(double x2, double y2, double z2) {
        return x2 * x2 + y2 * y2 + z2 * z2;
    }

    private static final double lengthSq(double x2, double z2) {
        return x2 * x2 + z2 * z2;
    }

    public int makePyramid(Vector pos, Pattern block, int size, boolean filled) throws MaxChangedBlocksException {
        int affected = 0;
        int height = size;
        for (int y2 = 0; y2 <= height; ++y2) {
            --size;
            for (int x2 = 0; x2 <= size; ++x2) {
                for (int z2 = 0; z2 <= size; ++z2) {
                    if ((!filled || z2 > size || x2 > size) && z2 != size && x2 != size) continue;
                    if (this.setBlock(pos.add(x2, y2, z2), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(-x2, y2, z2), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(x2, y2, -z2), block)) {
                        ++affected;
                    }
                    if (!this.setBlock(pos.add(-x2, y2, -z2), block)) continue;
                    ++affected;
                }
            }
        }
        return affected;
    }

    public int thaw(Vector pos, double radius) throws MaxChangedBlocksException {
        int affected = 0;
        double radiusSq = radius * radius;
        int ox2 = pos.getBlockX();
        int oy2 = pos.getBlockY();
        int oz2 = pos.getBlockZ();
        BaseBlock air2 = new BaseBlock(0);
        BaseBlock water = new BaseBlock(9);
        int ceilRadius = (int)Math.ceil(radius);
        for (int x2 = ox2 - ceilRadius; x2 <= ox2 + ceilRadius; ++x2) {
            block6: for (int z2 = oz2 - ceilRadius; z2 <= oz2 + ceilRadius; ++z2) {
                if (new Vector(x2, oy2, z2).distanceSq(pos) > radiusSq) continue;
                block7: for (int y2 = this.world.getMaxY(); y2 >= 1; --y2) {
                    Vector pt2 = new Vector(x2, y2, z2);
                    int id2 = this.getBlockType(pt2);
                    switch (id2) {
                        case 79: {
                            if (!this.setBlock(pt2, water)) continue block6;
                            ++affected;
                            continue block6;
                        }
                        case 78: {
                            if (!this.setBlock(pt2, air2)) continue block6;
                            ++affected;
                            continue block6;
                        }
                        case 0: {
                            continue block7;
                        }
                        default: {
                            continue block6;
                        }
                    }
                }
            }
        }
        return affected;
    }

    public int simulateSnow(Vector pos, double radius) throws MaxChangedBlocksException {
        int affected = 0;
        double radiusSq = radius * radius;
        int ox2 = pos.getBlockX();
        int oy2 = pos.getBlockY();
        int oz2 = pos.getBlockZ();
        BaseBlock ice = new BaseBlock(79);
        BaseBlock snow = new BaseBlock(78);
        int ceilRadius = (int)Math.ceil(radius);
        for (int x2 = ox2 - ceilRadius; x2 <= ox2 + ceilRadius; ++x2) {
            block1: for (int z2 = oz2 - ceilRadius; z2 <= oz2 + ceilRadius; ++z2) {
                if (new Vector(x2, oy2, z2).distanceSq(pos) > radiusSq) continue;
                for (int y2 = this.world.getMaxY(); y2 >= 1; --y2) {
                    Vector pt2 = new Vector(x2, y2, z2);
                    int id2 = this.getBlockType(pt2);
                    if (id2 == 0) continue;
                    if (id2 == 8 || id2 == 9) {
                        if (!this.setBlock(pt2, ice)) continue block1;
                        ++affected;
                        continue block1;
                    }
                    if (BlockType.canPassThrough(id2) || y2 == this.world.getMaxY() || !this.setBlock(pt2.add(0, 1, 0), snow)) continue block1;
                    ++affected;
                    continue block1;
                }
            }
        }
        return affected;
    }

    public int green(Vector pos, double radius) throws MaxChangedBlocksException {
        int affected = 0;
        double radiusSq = radius * radius;
        int ox2 = pos.getBlockX();
        int oy2 = pos.getBlockY();
        int oz2 = pos.getBlockZ();
        BaseBlock grass = new BaseBlock(2);
        int ceilRadius = (int)Math.ceil(radius);
        for (int x2 = ox2 - ceilRadius; x2 <= ox2 + ceilRadius; ++x2) {
            block5: for (int z2 = oz2 - ceilRadius; z2 <= oz2 + ceilRadius; ++z2) {
                if (new Vector(x2, oy2, z2).distanceSq(pos) > radiusSq) continue;
                block6: for (int y2 = this.world.getMaxY(); y2 >= 1; --y2) {
                    Vector pt2 = new Vector(x2, y2, z2);
                    int id2 = this.getBlockType(pt2);
                    switch (id2) {
                        case 3: {
                            if (!this.setBlock(pt2, grass)) continue block5;
                            ++affected;
                            continue block5;
                        }
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: {
                            continue block5;
                        }
                        default: {
                            if (!BlockType.canPassThrough(id2)) continue block5;
                            continue block6;
                        }
                    }
                }
            }
        }
        return affected;
    }

    private void makePumpkinPatch(Vector basePos) throws MaxChangedBlocksException {
        BaseBlock leavesBlock = new BaseBlock(18);
        this.setBlockIfAir(basePos, leavesBlock);
        this.makePumpkinPatchVine(basePos, basePos.add(0, 0, 1));
        this.makePumpkinPatchVine(basePos, basePos.add(0, 0, -1));
        this.makePumpkinPatchVine(basePos, basePos.add(1, 0, 0));
        this.makePumpkinPatchVine(basePos, basePos.add(-1, 0, 0));
    }

    private void makePumpkinPatchVine(Vector basePos, Vector pos) throws MaxChangedBlocksException {
        Vector testPos;
        if (pos.distance(basePos) > 4.0) {
            return;
        }
        if (this.getBlockType(pos) != 0) {
            return;
        }
        for (int i2 = -1; i2 > -3 && this.getBlockType(testPos = pos.add(0, i2, 0)) == 0; --i2) {
            pos = testPos;
        }
        this.setBlockIfAir(pos, new BaseBlock(18));
        int t2 = prng.nextInt(4);
        int h2 = prng.nextInt(3) - 1;
        BaseBlock log = new BaseBlock(17);
        BaseBlock pumpkin = new BaseBlock(86);
        switch (t2) {
            case 0: {
                if (prng.nextBoolean()) {
                    this.makePumpkinPatchVine(basePos, pos.add(1, 0, 0));
                }
                if (prng.nextBoolean()) {
                    this.setBlockIfAir(pos.add(1, h2, -1), log);
                }
                this.setBlockIfAir(pos.add(0, 0, -1), pumpkin);
                break;
            }
            case 1: {
                if (prng.nextBoolean()) {
                    this.makePumpkinPatchVine(basePos, pos.add(0, 0, 1));
                }
                if (prng.nextBoolean()) {
                    this.setBlockIfAir(pos.add(1, h2, 0), log);
                }
                this.setBlockIfAir(pos.add(1, 0, 1), pumpkin);
                break;
            }
            case 2: {
                if (prng.nextBoolean()) {
                    this.makePumpkinPatchVine(basePos, pos.add(0, 0, -1));
                }
                if (prng.nextBoolean()) {
                    this.setBlockIfAir(pos.add(-1, h2, 0), log);
                }
                this.setBlockIfAir(pos.add(-1, 0, 1), pumpkin);
                break;
            }
            case 3: {
                if (prng.nextBoolean()) {
                    this.makePumpkinPatchVine(basePos, pos.add(-1, 0, 0));
                }
                if (prng.nextBoolean()) {
                    this.setBlockIfAir(pos.add(-1, h2, -1), log);
                }
                this.setBlockIfAir(pos.add(-1, 0, -1), pumpkin);
            }
        }
    }

    public int makePumpkinPatches(Vector basePos, int size) throws MaxChangedBlocksException {
        int affected = 0;
        for (int x2 = basePos.getBlockX() - size; x2 <= basePos.getBlockX() + size; ++x2) {
            block1: for (int z2 = basePos.getBlockZ() - size; z2 <= basePos.getBlockZ() + size; ++z2) {
                if (!this.getBlock(new Vector(x2, basePos.getBlockY(), z2)).isAir() || Math.random() < 0.98) continue;
                for (int y2 = basePos.getBlockY(); y2 >= basePos.getBlockY() - 10; --y2) {
                    int t2 = this.getBlock(new Vector(x2, y2, z2)).getType();
                    if (t2 == 2 || t2 == 3) {
                        this.makePumpkinPatch(new Vector(x2, y2 + 1, z2));
                        ++affected;
                        continue block1;
                    }
                    if (t2 != 0) continue block1;
                }
            }
        }
        return affected;
    }

    public int makeForest(Vector basePos, int size, double density, TreeGenerator treeGenerator) throws MaxChangedBlocksException {
        int affected = 0;
        for (int x2 = basePos.getBlockX() - size; x2 <= basePos.getBlockX() + size; ++x2) {
            block1: for (int z2 = basePos.getBlockZ() - size; z2 <= basePos.getBlockZ() + size; ++z2) {
                if (!this.getBlock(new Vector(x2, basePos.getBlockY(), z2)).isAir() || Math.random() >= density) continue;
                for (int y2 = basePos.getBlockY(); y2 >= basePos.getBlockY() - 10; --y2) {
                    int t2 = this.getBlock(new Vector(x2, y2, z2)).getType();
                    if (t2 == 2 || t2 == 3) {
                        treeGenerator.generate(this, new Vector(x2, y2 + 1, z2));
                        ++affected;
                        continue block1;
                    }
                    if (t2 != 0) continue block1;
                }
            }
        }
        return affected;
    }

    public List<com.sk89q.worldedit.Countable<Integer>> getBlockDistribution(Region region) {
        ArrayList<com.sk89q.worldedit.Countable<Integer>> distribution = new ArrayList<com.sk89q.worldedit.Countable<Integer>>();
        HashMap<Integer, Countable<Integer>> map = new HashMap<Integer, Countable<Integer>>();
        if (region instanceof CuboidRegion) {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            int minX = min.getBlockX();
            int minY = min.getBlockY();
            int minZ = min.getBlockZ();
            int maxX = max.getBlockX();
            int maxY = max.getBlockY();
            int maxZ = max.getBlockZ();
            for (int x2 = minX; x2 <= maxX; ++x2) {
                for (int y2 = minY; y2 <= maxY; ++y2) {
                    for (int z2 = minZ; z2 <= maxZ; ++z2) {
                        Vector pt2 = new Vector(x2, y2, z2);
                        int id2 = this.getBlockType(pt2);
                        if (map.containsKey(id2)) {
                            ((Countable)map.get(id2)).increment();
                            continue;
                        }
                        Countable<Integer> c2 = new Countable<Integer>(id2, 1);
                        map.put(id2, c2);
                        distribution.add((com.sk89q.worldedit.Countable<Integer>)c2);
                    }
                }
            }
        } else {
            for (BlockVector pt3 : region) {
                int id3 = this.getBlockType(pt3);
                if (map.containsKey(id3)) {
                    ((Countable)map.get(id3)).increment();
                    continue;
                }
                Countable<Integer> c3 = new Countable<Integer>(id3, 1);
                map.put(id3, c3);
            }
        }
        Collections.sort(distribution);
        return distribution;
    }

    public int makeShape(Region region, final Vector zero, final Vector unit, Pattern pattern, String expressionString, boolean hollow) throws ExpressionException, MaxChangedBlocksException {
        final Expression expression = Expression.compile(expressionString, "x", "y", "z", "type", "data");
        expression.optimize();
        final RValue typeVariable = expression.getVariable("type", false);
        final RValue dataVariable = expression.getVariable("data", false);
        ArbitraryShape shape = new ArbitraryShape(region){

            @Override
            protected BaseBlock getMaterial(int x2, int y2, int z2, BaseBlock defaultMaterial) {
                Vector scaled = new Vector(x2, y2, z2).subtract(zero).divide(unit);
                try {
                    double[] dArray = new double[]{scaled.getX(), scaled.getY(), scaled.getZ(), defaultMaterial.getType(), defaultMaterial.getData()};
                    if (expression.evaluate(dArray) <= 0.0) {
                        return null;
                    }
                    return new BaseBlock((int)typeVariable.getValue(), (int)dataVariable.getValue());
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    return null;
                }
            }
        };
        return shape.generate(this, pattern, hollow);
    }

    public int deformRegion(Region region, Vector zero, Vector unit, String expressionString) throws ExpressionException, MaxChangedBlocksException {
        Expression expression = Expression.compile(expressionString, "x", "y", "z");
        expression.optimize();
        RValue x2 = expression.getVariable("x", false);
        RValue y2 = expression.getVariable("y", false);
        RValue z2 = expression.getVariable("z", false);
        Vector zero2 = zero.add(0.5, 0.5, 0.5);
        DoubleArrayList<BlockVector, BaseBlock> queue = new DoubleArrayList<BlockVector, BaseBlock>(false);
        for (BlockVector position : region) {
            Vector scaled = position.subtract(zero).divide(unit);
            expression.evaluate(scaled.getX(), scaled.getY(), scaled.getZ());
            Vector sourceScaled = new Vector(x2.getValue(), y2.getValue(), z2.getValue());
            BlockVector sourcePosition = sourceScaled.multiply(unit).add(zero2).toBlockPoint();
            BaseBlock material = new BaseBlock(this.world.getBlockType(sourcePosition), this.world.getBlockData(sourcePosition));
            queue.put(position, material);
        }
        int affected = 0;
        for (Map.Entry entry : queue) {
            BaseBlock material;
            BlockVector position = (BlockVector)entry.getKey();
            if (!this.setBlock((Vector)position, material = (BaseBlock)entry.getValue())) continue;
            ++affected;
        }
        return affected;
    }

    public int hollowOutRegion(Region region, int thickness, Pattern pattern) throws MaxChangedBlocksException {
        int affected = 0;
        HashSet<com.sk89q.worldedit.BlockVector> outside = new HashSet<com.sk89q.worldedit.BlockVector>();
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int minX = min.getBlockX();
        int minY = min.getBlockY();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxY = max.getBlockY();
        int maxZ = max.getBlockZ();
        for (int x2 = minX; x2 <= maxX; ++x2) {
            for (int y2 = minY; y2 <= maxY; ++y2) {
                this.recurseHollow(region, new BlockVector(x2, y2, minZ), outside);
                this.recurseHollow(region, new BlockVector(x2, y2, maxZ), outside);
            }
        }
        for (int y3 = minY; y3 <= maxY; ++y3) {
            for (int z2 = minZ; z2 <= maxZ; ++z2) {
                this.recurseHollow(region, new BlockVector(minX, y3, z2), outside);
                this.recurseHollow(region, new BlockVector(maxX, y3, z2), outside);
            }
        }
        for (int z3 = minZ; z3 <= maxZ; ++z3) {
            for (int x3 = minX; x3 <= maxX; ++x3) {
                this.recurseHollow(region, new BlockVector(x3, minY, z3), outside);
                this.recurseHollow(region, new BlockVector(x3, maxY, z3), outside);
            }
        }
        for (int i2 = 1; i2 < thickness; ++i2) {
            HashSet<BlockVector> newOutside = new HashSet<BlockVector>();
            block7: for (BlockVector position : region) {
                for (Vector recurseDirection : this.recurseDirections) {
                    BlockVector neighbor = position.add(recurseDirection).toBlockVector();
                    if (!outside.contains(neighbor)) continue;
                    newOutside.add(position);
                    continue block7;
                }
            }
            outside.addAll(newOutside);
        }
        block9: for (BlockVector position : region) {
            for (Vector recurseDirection : this.recurseDirections) {
                BlockVector neighbor = position.add(recurseDirection).toBlockVector();
                if (outside.contains(neighbor)) continue block9;
            }
            if (!this.setBlock((Vector)position, pattern.next(position))) continue;
            ++affected;
        }
        return affected;
    }

    private void recurseHollow(Region region, BlockVector origin, Set<com.sk89q.worldedit.BlockVector> outside) {
        LinkedList<BlockVector> queue = new LinkedList<BlockVector>();
        queue.addLast(origin);
        while (!queue.isEmpty()) {
            BlockVector current = (BlockVector)queue.removeFirst();
            if (!BlockType.canPassThrough(this.getBlockType(current)) || !outside.add((com.sk89q.worldedit.BlockVector)current) || !region.contains(current)) continue;
            for (Vector recurseDirection : this.recurseDirections) {
                queue.addLast(current.add(recurseDirection).toBlockVector());
            }
        }
    }
}

