/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit;

import wecui.vendor.com.sk89q.worldedit.EditSession;
import wecui.vendor.com.sk89q.worldedit.MaxChangedBlocksException;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseBlock;
import wecui.vendor.com.sk89q.worldedit.filtering.HeightMapFilter;
import wecui.vendor.com.sk89q.worldedit.regions.Region;

public class HeightMap {
    private int[] data;
    private int width;
    private int height;
    private Region region;
    private EditSession session;

    public HeightMap(EditSession session, Region region) {
        this(session, region, false);
    }

    public HeightMap(EditSession session, Region region, boolean naturalOnly) {
        this.session = session;
        this.region = region;
        this.width = region.getWidth();
        this.height = region.getLength();
        int minX = region.getMinimumPoint().getBlockX();
        int minY = region.getMinimumPoint().getBlockY();
        int minZ = region.getMinimumPoint().getBlockZ();
        int maxY = region.getMaximumPoint().getBlockY();
        this.data = new int[this.width * this.height];
        for (int z2 = 0; z2 < this.height; ++z2) {
            for (int x2 = 0; x2 < this.width; ++x2) {
                this.data[z2 * this.width + x2] = session.getHighestTerrainBlock(x2 + minX, z2 + minZ, minY, maxY, naturalOnly);
            }
        }
    }

    public int applyFilter(HeightMapFilter filter, int iterations) throws MaxChangedBlocksException {
        int[] newData = new int[this.data.length];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        for (int i2 = 0; i2 < iterations; ++i2) {
            newData = filter.filter(newData, this.width, this.height);
        }
        return this.apply(newData);
    }

    public int apply(int[] data) throws MaxChangedBlocksException {
        Vector minY = this.region.getMinimumPoint();
        int originX = minY.getBlockX();
        int originY = minY.getBlockY();
        int originZ = minY.getBlockZ();
        int maxY = this.region.getMaximumPoint().getBlockY();
        BaseBlock fillerAir = new BaseBlock(0);
        int blocksChanged = 0;
        for (int z2 = 0; z2 < this.height; ++z2) {
            for (int x2 = 0; x2 < this.width; ++x2) {
                int y2;
                int index = z2 * this.width + x2;
                int curHeight = this.data[index];
                int newHeight = Math.min(maxY, data[index]);
                int X = x2 + originX;
                int Z = z2 + originZ;
                double scale = (double)(curHeight - originY) / (double)(newHeight - originY);
                if (newHeight > curHeight) {
                    BaseBlock existing = this.session.getBlock(new Vector(X, curHeight, Z));
                    if (existing.getType() == 8 || existing.getType() == 9 || existing.getType() == 10 || existing.getType() == 11) continue;
                    this.session.setBlock(new Vector(X, newHeight, Z), existing);
                    ++blocksChanged;
                    for (int y3 = newHeight - 1 - originY; y3 >= 0; --y3) {
                        int copyFrom = (int)((double)y3 * scale);
                        this.session.setBlock(new Vector(X, originY + y3, Z), this.session.getBlock(new Vector(X, originY + copyFrom, Z)));
                        ++blocksChanged;
                    }
                    continue;
                }
                if (curHeight <= newHeight) continue;
                for (y2 = 0; y2 < newHeight - originY; ++y2) {
                    int copyFrom = (int)((double)y2 * scale);
                    this.session.setBlock(new Vector(X, originY + y2, Z), this.session.getBlock(new Vector(X, originY + copyFrom, Z)));
                    ++blocksChanged;
                }
                this.session.setBlock(new Vector(X, newHeight, Z), this.session.getBlock(new Vector(X, curHeight, Z)));
                ++blocksChanged;
                for (y2 = newHeight + 1; y2 <= curHeight; ++y2) {
                    this.session.setBlock(new Vector(X, y2, Z), fillerAir);
                    ++blocksChanged;
                }
            }
        }
        return blocksChanged;
    }
}

