/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit;

import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.Vector;

public class Location {
    private final LocalWorld world;
    private final Vector position;
    private final float yaw;
    private final float pitch;

    public Location(LocalWorld world, Vector position) {
        this(world, position, 0.0f, 0.0f);
    }

    public Location(LocalWorld world, Vector position, float yaw, float pitch) {
        this.world = world;
        this.position = position;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public LocalWorld getWorld() {
        return this.world;
    }

    public Vector getPosition() {
        return this.position;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public Location setAngles(float yaw, float pitch) {
        return new Location(this.world, this.position, yaw, pitch);
    }

    public Location setPosition(Vector position) {
        return new Location(this.world, position, this.yaw, this.pitch);
    }

    public Location add(Vector other) {
        return this.setPosition(this.position.add(other));
    }

    public Location add(double x2, double y2, double z2) {
        return this.setPosition(this.position.add(x2, y2, z2));
    }

    public Vector getDirection() {
        double yawRadians = Math.toRadians(this.yaw);
        double pitchRadians = Math.toRadians(this.pitch);
        double y2 = -Math.sin(pitchRadians);
        double h2 = Math.cos(pitchRadians);
        double x2 = -h2 * Math.sin(yawRadians);
        double z2 = h2 * Math.cos(yawRadians);
        return new Vector(x2, y2, z2);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Location)) {
            return false;
        }
        Location location = (Location)obj;
        if (!this.world.equals(location.world)) {
            return false;
        }
        return this.position.equals(location.position);
    }

    public int hashCode() {
        return this.position.hashCode() + 19 * this.world.hashCode();
    }

    public static Location fromLookAt(LocalWorld world, Vector start, Vector lookAt) {
        Vector diff = lookAt.subtract(start);
        return Location.fromEye(world, start, diff);
    }

    public static Location fromEye(LocalWorld world, Vector start, Vector eye) {
        double eyeX = eye.getX();
        double eyeZ = eye.getZ();
        float yaw = (float)Math.toDegrees(Math.atan2(-eyeX, eyeZ));
        double length = Math.sqrt(eyeX * eyeX + eyeZ * eyeZ);
        float pitch = (float)Math.toDegrees(Math.atan2(-eye.getY(), length));
        return new Location(world, start, yaw, pitch);
    }
}

