/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit;

import wecui.vendor.com.sk89q.worldedit.BlockVector;
import wecui.vendor.com.sk89q.worldedit.Vector2D;

public class Vector {
    protected final double x;
    protected final double y;
    protected final double z;

    public Vector(double x2, double y2, double z2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
    }

    public Vector(int x2, int y2, int z2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
    }

    public Vector(float x2, float y2, float z2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
    }

    public Vector(Vector pt2) {
        this.x = pt2.x;
        this.y = pt2.y;
        this.z = pt2.z;
    }

    public Vector() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public double getX() {
        return this.x;
    }

    public int getBlockX() {
        return (int)Math.round(this.x);
    }

    public Vector setX(double x2) {
        return new Vector(x2, this.y, this.z);
    }

    public Vector setX(int x2) {
        return new Vector((double)x2, this.y, this.z);
    }

    public double getY() {
        return this.y;
    }

    public int getBlockY() {
        return (int)Math.round(this.y);
    }

    public Vector setY(double y2) {
        return new Vector(this.x, y2, this.z);
    }

    public Vector setY(int y2) {
        return new Vector(this.x, (double)y2, this.z);
    }

    public double getZ() {
        return this.z;
    }

    public int getBlockZ() {
        return (int)Math.round(this.z);
    }

    public Vector setZ(double z2) {
        return new Vector(this.x, this.y, z2);
    }

    public Vector setZ(int z2) {
        return new Vector(this.x, this.y, (double)z2);
    }

    public Vector add(Vector other) {
        return new Vector(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public Vector add(double x2, double y2, double z2) {
        return new Vector(this.x + x2, this.y + y2, this.z + z2);
    }

    public Vector add(int x2, int y2, int z2) {
        return new Vector(this.x + (double)x2, this.y + (double)y2, this.z + (double)z2);
    }

    public Vector add(Vector ... others) {
        double newX = this.x;
        double newY = this.y;
        double newZ = this.z;
        for (int i2 = 0; i2 < others.length; ++i2) {
            newX += others[i2].x;
            newY += others[i2].y;
            newZ += others[i2].z;
        }
        return new Vector(newX, newY, newZ);
    }

    public Vector subtract(Vector other) {
        return new Vector(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public Vector subtract(double x2, double y2, double z2) {
        return new Vector(this.x - x2, this.y - y2, this.z - z2);
    }

    public Vector subtract(int x2, int y2, int z2) {
        return new Vector(this.x - (double)x2, this.y - (double)y2, this.z - (double)z2);
    }

    public Vector subtract(Vector ... others) {
        double newX = this.x;
        double newY = this.y;
        double newZ = this.z;
        for (int i2 = 0; i2 < others.length; ++i2) {
            newX -= others[i2].x;
            newY -= others[i2].y;
            newZ -= others[i2].z;
        }
        return new Vector(newX, newY, newZ);
    }

    public Vector multiply(Vector other) {
        return new Vector(this.x * other.x, this.y * other.y, this.z * other.z);
    }

    public Vector multiply(double x2, double y2, double z2) {
        return new Vector(this.x * x2, this.y * y2, this.z * z2);
    }

    public Vector multiply(int x2, int y2, int z2) {
        return new Vector(this.x * (double)x2, this.y * (double)y2, this.z * (double)z2);
    }

    public Vector multiply(Vector ... others) {
        double newX = this.x;
        double newY = this.y;
        double newZ = this.z;
        for (int i2 = 0; i2 < others.length; ++i2) {
            newX *= others[i2].x;
            newY *= others[i2].y;
            newZ *= others[i2].z;
        }
        return new Vector(newX, newY, newZ);
    }

    public Vector multiply(double n2) {
        return new Vector(this.x * n2, this.y * n2, this.z * n2);
    }

    public Vector multiply(float n2) {
        return new Vector(this.x * (double)n2, this.y * (double)n2, this.z * (double)n2);
    }

    public Vector multiply(int n2) {
        return new Vector(this.x * (double)n2, this.y * (double)n2, this.z * (double)n2);
    }

    public Vector divide(Vector other) {
        return new Vector(this.x / other.x, this.y / other.y, this.z / other.z);
    }

    public Vector divide(double x2, double y2, double z2) {
        return new Vector(this.x / x2, this.y / y2, this.z / z2);
    }

    public Vector divide(int x2, int y2, int z2) {
        return new Vector(this.x / (double)x2, this.y / (double)y2, this.z / (double)z2);
    }

    public Vector divide(int n2) {
        return new Vector(this.x / (double)n2, this.y / (double)n2, this.z / (double)n2);
    }

    public Vector divide(double n2) {
        return new Vector(this.x / n2, this.y / n2, this.z / n2);
    }

    public Vector divide(float n2) {
        return new Vector(this.x / (double)n2, this.y / (double)n2, this.z / (double)n2);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double lengthSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double distance(Vector pt2) {
        return Math.sqrt(Math.pow(pt2.x - this.x, 2.0) + Math.pow(pt2.y - this.y, 2.0) + Math.pow(pt2.z - this.z, 2.0));
    }

    public double distanceSq(Vector pt2) {
        return Math.pow(pt2.x - this.x, 2.0) + Math.pow(pt2.y - this.y, 2.0) + Math.pow(pt2.z - this.z, 2.0);
    }

    public Vector normalize() {
        return this.divide(this.length());
    }

    public double dot(Vector other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public Vector cross(Vector other) {
        return new Vector(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }

    public boolean containedWithin(Vector min, Vector max) {
        return this.x >= min.x && this.x <= max.x && this.y >= min.y && this.y <= max.y && this.z >= min.z && this.z <= max.z;
    }

    public boolean containedWithinBlock(Vector min, Vector max) {
        return this.getBlockX() >= min.getBlockX() && this.getBlockX() <= max.getBlockX() && this.getBlockY() >= min.getBlockY() && this.getBlockY() <= max.getBlockY() && this.getBlockZ() >= min.getBlockZ() && this.getBlockZ() <= max.getBlockZ();
    }

    public Vector clampY(int min, int max) {
        return new Vector(this.x, Math.max((double)min, Math.min((double)max, this.y)), this.z);
    }

    public Vector floor() {
        return new Vector(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public Vector ceil() {
        return new Vector(Math.ceil(this.x), Math.ceil(this.y), Math.ceil(this.z));
    }

    public Vector round() {
        return new Vector(Math.floor(this.x + 0.5), Math.floor(this.y + 0.5), Math.floor(this.z + 0.5));
    }

    public Vector positive() {
        return new Vector(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    public Vector transform2D(double angle, double aboutX, double aboutZ, double translateX, double translateZ) {
        angle = Math.toRadians(angle);
        double x2 = this.x - aboutX;
        double z2 = this.z - aboutZ;
        double x22 = x2 * Math.cos(angle) - z2 * Math.sin(angle);
        double z22 = x2 * Math.sin(angle) + z2 * Math.cos(angle);
        return new Vector(x22 + aboutX + translateX, this.y, z22 + aboutZ + translateZ);
    }

    public boolean isCollinearWith(Vector other) {
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0) {
            return true;
        }
        double otherX = other.x;
        double otherY = other.y;
        double otherZ = other.z;
        if (otherX == 0.0 && otherY == 0.0 && otherZ == 0.0) {
            return true;
        }
        if (this.x == 0.0 != (otherX == 0.0)) {
            return false;
        }
        if (this.y == 0.0 != (otherY == 0.0)) {
            return false;
        }
        if (this.z == 0.0 != (otherZ == 0.0)) {
            return false;
        }
        double quotientX = otherX / this.x;
        if (!Double.isNaN(quotientX)) {
            return other.equals(this.multiply(quotientX));
        }
        double quotientY = otherY / this.y;
        if (!Double.isNaN(quotientY)) {
            return other.equals(this.multiply(quotientY));
        }
        double quotientZ = otherZ / this.z;
        if (!Double.isNaN(quotientZ)) {
            return other.equals(this.multiply(quotientZ));
        }
        throw new RuntimeException("This should not happen");
    }

    public static BlockVector toBlockPoint(double x2, double y2, double z2) {
        return new BlockVector(Math.floor(x2), Math.floor(y2), Math.floor(z2));
    }

    public BlockVector toBlockPoint() {
        return new BlockVector(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Vector)) {
            return false;
        }
        Vector other = (Vector)obj;
        return other.x == this.x && other.y == this.y && other.z == this.z;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.z) ^ Double.doubleToLongBits(this.z) >>> 32);
        return hash;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public BlockVector toBlockVector() {
        return new BlockVector(this);
    }

    public Vector2D toVector2D() {
        return new Vector2D(this.x, this.z);
    }

    public static Vector getMinimum(Vector v1, Vector v2) {
        return new Vector(Math.min(v1.x, v2.x), Math.min(v1.y, v2.y), Math.min(v1.z, v2.z));
    }

    public static Vector getMaximum(Vector v1, Vector v2) {
        return new Vector(Math.max(v1.x, v2.x), Math.max(v1.y, v2.y), Math.max(v1.z, v2.z));
    }

    public static Vector getMidpoint(Vector v1, Vector v2) {
        return new Vector((v1.x + v2.x) / 2.0, (v1.y + v2.y) / 2.0, (v1.z + v2.z) / 2.0);
    }
}

