/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit;

import wecui.vendor.com.sk89q.worldedit.BlockVector2D;
import wecui.vendor.com.sk89q.worldedit.Vector;

public class Vector2D {
    protected final double x;
    protected final double z;

    public Vector2D(double x2, double z2) {
        this.x = x2;
        this.z = z2;
    }

    public Vector2D(int x2, int z2) {
        this.x = x2;
        this.z = z2;
    }

    public Vector2D(float x2, float z2) {
        this.x = x2;
        this.z = z2;
    }

    public Vector2D(Vector2D pt2) {
        this.x = pt2.x;
        this.z = pt2.z;
    }

    public Vector2D() {
        this.x = 0.0;
        this.z = 0.0;
    }

    public double getX() {
        return this.x;
    }

    public int getBlockX() {
        return (int)Math.round(this.x);
    }

    public Vector2D setX(double x2) {
        return new Vector2D(x2, this.z);
    }

    public Vector2D setX(int x2) {
        return new Vector2D((double)x2, this.z);
    }

    public double getZ() {
        return this.z;
    }

    public int getBlockZ() {
        return (int)Math.round(this.z);
    }

    public Vector2D setZ(double z2) {
        return new Vector2D(this.x, z2);
    }

    public Vector2D setZ(int z2) {
        return new Vector2D(this.x, (double)z2);
    }

    public Vector2D add(Vector2D other) {
        return new Vector2D(this.x + other.x, this.z + other.z);
    }

    public Vector2D add(double x2, double z2) {
        return new Vector2D(this.x + x2, this.z + z2);
    }

    public Vector2D add(int x2, int z2) {
        return new Vector2D(this.x + (double)x2, this.z + (double)z2);
    }

    public Vector2D add(Vector2D ... others) {
        double newX = this.x;
        double newZ = this.z;
        for (int i2 = 0; i2 < others.length; ++i2) {
            newX += others[i2].x;
            newZ += others[i2].z;
        }
        return new Vector2D(newX, newZ);
    }

    public Vector2D subtract(Vector2D other) {
        return new Vector2D(this.x - other.x, this.z - other.z);
    }

    public Vector2D subtract(double x2, double z2) {
        return new Vector2D(this.x - x2, this.z - z2);
    }

    public Vector2D subtract(int x2, int z2) {
        return new Vector2D(this.x - (double)x2, this.z - (double)z2);
    }

    public Vector2D subtract(Vector2D ... others) {
        double newX = this.x;
        double newZ = this.z;
        for (int i2 = 0; i2 < others.length; ++i2) {
            newX -= others[i2].x;
            newZ -= others[i2].z;
        }
        return new Vector2D(newX, newZ);
    }

    public Vector2D multiply(Vector2D other) {
        return new Vector2D(this.x * other.x, this.z * other.z);
    }

    public Vector2D multiply(double x2, double z2) {
        return new Vector2D(this.x * x2, this.z * z2);
    }

    public Vector2D multiply(int x2, int z2) {
        return new Vector2D(this.x * (double)x2, this.z * (double)z2);
    }

    public Vector2D multiply(Vector2D ... others) {
        double newX = this.x;
        double newZ = this.z;
        for (int i2 = 0; i2 < others.length; ++i2) {
            newX *= others[i2].x;
            newZ *= others[i2].z;
        }
        return new Vector2D(newX, newZ);
    }

    public Vector2D multiply(double n2) {
        return new Vector2D(this.x * n2, this.z * n2);
    }

    public Vector2D multiply(float n2) {
        return new Vector2D(this.x * (double)n2, this.z * (double)n2);
    }

    public Vector2D multiply(int n2) {
        return new Vector2D(this.x * (double)n2, this.z * (double)n2);
    }

    public Vector2D divide(Vector2D other) {
        return new Vector2D(this.x / other.x, this.z / other.z);
    }

    public Vector2D divide(double x2, double z2) {
        return new Vector2D(this.x / x2, this.z / z2);
    }

    public Vector2D divide(int x2, int z2) {
        return new Vector2D(this.x / (double)x2, this.z / (double)z2);
    }

    public Vector2D divide(int n2) {
        return new Vector2D(this.x / (double)n2, this.z / (double)n2);
    }

    public Vector2D divide(double n2) {
        return new Vector2D(this.x / n2, this.z / n2);
    }

    public Vector2D divide(float n2) {
        return new Vector2D(this.x / (double)n2, this.z / (double)n2);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.z * this.z);
    }

    public double lengthSq() {
        return this.x * this.x + this.z * this.z;
    }

    public double distance(Vector2D pt2) {
        return Math.sqrt(Math.pow(pt2.x - this.x, 2.0) + Math.pow(pt2.z - this.z, 2.0));
    }

    public double distanceSq(Vector2D pt2) {
        return Math.pow(pt2.x - this.x, 2.0) + Math.pow(pt2.z - this.z, 2.0);
    }

    public Vector2D normalize() {
        return this.divide(this.length());
    }

    public double dot(Vector2D other) {
        return this.x * other.x + this.z * other.z;
    }

    public boolean containedWithin(Vector2D min, Vector2D max) {
        return this.x >= min.x && this.x <= max.x && this.z >= min.z && this.z <= max.z;
    }

    public boolean containedWithinBlock(Vector2D min, Vector2D max) {
        return this.getBlockX() >= min.getBlockX() && this.getBlockX() <= max.getBlockX() && this.getBlockZ() >= min.getBlockZ() && this.getBlockZ() <= max.getBlockZ();
    }

    public Vector2D floor() {
        return new Vector2D(Math.floor(this.x), Math.floor(this.z));
    }

    public Vector2D ceil() {
        return new Vector2D(Math.ceil(this.x), Math.ceil(this.z));
    }

    public Vector2D round() {
        return new Vector2D(Math.floor(this.x + 0.5), Math.floor(this.z + 0.5));
    }

    public Vector2D positive() {
        return new Vector2D(Math.abs(this.x), Math.abs(this.z));
    }

    public Vector2D transform2D(double angle, double aboutX, double aboutZ, double translateX, double translateZ) {
        angle = Math.toRadians(angle);
        double x2 = this.x - aboutX;
        double z2 = this.z - aboutZ;
        double x22 = x2 * Math.cos(angle) - z2 * Math.sin(angle);
        double z22 = x2 * Math.sin(angle) + z2 * Math.cos(angle);
        return new Vector2D(x22 + aboutX + translateX, z22 + aboutZ + translateZ);
    }

    public boolean isCollinearWith(Vector2D other) {
        if (this.x == 0.0 && this.z == 0.0) {
            return true;
        }
        double otherX = other.x;
        double otherZ = other.z;
        if (otherX == 0.0 && otherZ == 0.0) {
            return true;
        }
        if (this.x == 0.0 != (otherX == 0.0)) {
            return false;
        }
        if (this.z == 0.0 != (otherZ == 0.0)) {
            return false;
        }
        double quotientX = otherX / this.x;
        if (!Double.isNaN(quotientX)) {
            return other.equals(this.multiply(quotientX));
        }
        double quotientZ = otherZ / this.z;
        if (!Double.isNaN(quotientZ)) {
            return other.equals(this.multiply(quotientZ));
        }
        throw new RuntimeException("This should not happen");
    }

    public BlockVector2D toBlockVector2D() {
        return new BlockVector2D(this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Vector2D)) {
            return false;
        }
        Vector2D other = (Vector2D)obj;
        return other.x == this.x && other.z == this.z;
    }

    public int hashCode() {
        return new Double(this.x).hashCode() >> 13 ^ new Double(this.z).hashCode();
    }

    public String toString() {
        return "(" + this.x + ", " + this.z + ")";
    }

    public Vector toVector() {
        return new Vector(this.x, 0.0, this.z);
    }

    public Vector toVector(double y2) {
        return new Vector(this.x, y2, this.z);
    }

    public static Vector2D getMinimum(Vector2D v1, Vector2D v2) {
        return new Vector2D(Math.min(v1.x, v2.x), Math.min(v1.z, v2.z));
    }

    public static Vector2D getMaximum(Vector2D v1, Vector2D v2) {
        return new Vector2D(Math.max(v1.x, v2.x), Math.max(v1.z, v2.z));
    }
}

