/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.script.ScriptException;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandException;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandPermissionsException;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandUsageException;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandsManager;
import wecui.vendor.com.sk89q.minecraft.util.commands.Console;
import wecui.vendor.com.sk89q.minecraft.util.commands.Logging;
import wecui.vendor.com.sk89q.minecraft.util.commands.MissingNestedCommandException;
import wecui.vendor.com.sk89q.minecraft.util.commands.SimpleInjector;
import wecui.vendor.com.sk89q.minecraft.util.commands.UnhandledCommandException;
import wecui.vendor.com.sk89q.minecraft.util.commands.WrappedCommandException;
import wecui.vendor.com.sk89q.util.StringUtil;
import wecui.vendor.com.sk89q.worldedit.BiomeType;
import wecui.vendor.com.sk89q.worldedit.CuboidClipboard;
import wecui.vendor.com.sk89q.worldedit.DisallowedItemException;
import wecui.vendor.com.sk89q.worldedit.EditSession;
import wecui.vendor.com.sk89q.worldedit.EmptyClipboardException;
import wecui.vendor.com.sk89q.worldedit.FileSelectionAbortedException;
import wecui.vendor.com.sk89q.worldedit.FilenameException;
import wecui.vendor.com.sk89q.worldedit.FilenameResolutionException;
import wecui.vendor.com.sk89q.worldedit.IncompleteRegionException;
import wecui.vendor.com.sk89q.worldedit.InvalidFilenameException;
import wecui.vendor.com.sk89q.worldedit.InvalidItemException;
import wecui.vendor.com.sk89q.worldedit.InvalidToolBindException;
import wecui.vendor.com.sk89q.worldedit.LocalConfiguration;
import wecui.vendor.com.sk89q.worldedit.LocalPlayer;
import wecui.vendor.com.sk89q.worldedit.LocalSession;
import wecui.vendor.com.sk89q.worldedit.MaxChangedBlocksException;
import wecui.vendor.com.sk89q.worldedit.MaxRadiusException;
import wecui.vendor.com.sk89q.worldedit.MobType;
import wecui.vendor.com.sk89q.worldedit.PlayerDirection;
import wecui.vendor.com.sk89q.worldedit.ServerInterface;
import wecui.vendor.com.sk89q.worldedit.SessionCheck;
import wecui.vendor.com.sk89q.worldedit.UnknownDirectionException;
import wecui.vendor.com.sk89q.worldedit.UnknownItemException;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.WorldEditException;
import wecui.vendor.com.sk89q.worldedit.WorldVector;
import wecui.vendor.com.sk89q.worldedit.bags.BlockBag;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.BlockType;
import wecui.vendor.com.sk89q.worldedit.blocks.ClothColor;
import wecui.vendor.com.sk89q.worldedit.blocks.ItemType;
import wecui.vendor.com.sk89q.worldedit.blocks.MobSpawnerBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.NoteBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.SignBlock;
import wecui.vendor.com.sk89q.worldedit.commands.BiomeCommands;
import wecui.vendor.com.sk89q.worldedit.commands.ChunkCommands;
import wecui.vendor.com.sk89q.worldedit.commands.ClipboardCommands;
import wecui.vendor.com.sk89q.worldedit.commands.GeneralCommands;
import wecui.vendor.com.sk89q.worldedit.commands.GenerationCommands;
import wecui.vendor.com.sk89q.worldedit.commands.HistoryCommands;
import wecui.vendor.com.sk89q.worldedit.commands.InsufficientArgumentsException;
import wecui.vendor.com.sk89q.worldedit.commands.NavigationCommands;
import wecui.vendor.com.sk89q.worldedit.commands.RegionCommands;
import wecui.vendor.com.sk89q.worldedit.commands.ScriptingCommands;
import wecui.vendor.com.sk89q.worldedit.commands.SelectionCommands;
import wecui.vendor.com.sk89q.worldedit.commands.SnapshotUtilCommands;
import wecui.vendor.com.sk89q.worldedit.commands.ToolCommands;
import wecui.vendor.com.sk89q.worldedit.commands.ToolUtilCommands;
import wecui.vendor.com.sk89q.worldedit.commands.UtilityCommands;
import wecui.vendor.com.sk89q.worldedit.masks.BiomeTypeMask;
import wecui.vendor.com.sk89q.worldedit.masks.BlockTypeMask;
import wecui.vendor.com.sk89q.worldedit.masks.CombinedMask;
import wecui.vendor.com.sk89q.worldedit.masks.DynamicRegionMask;
import wecui.vendor.com.sk89q.worldedit.masks.ExistingBlockMask;
import wecui.vendor.com.sk89q.worldedit.masks.InvertedMask;
import wecui.vendor.com.sk89q.worldedit.masks.Mask;
import wecui.vendor.com.sk89q.worldedit.masks.RegionMask;
import wecui.vendor.com.sk89q.worldedit.masks.UnderOverlayMask;
import wecui.vendor.com.sk89q.worldedit.patterns.BlockChance;
import wecui.vendor.com.sk89q.worldedit.patterns.ClipboardPattern;
import wecui.vendor.com.sk89q.worldedit.patterns.Pattern;
import wecui.vendor.com.sk89q.worldedit.patterns.RandomFillPattern;
import wecui.vendor.com.sk89q.worldedit.patterns.SingleBlockPattern;
import wecui.vendor.com.sk89q.worldedit.regions.RegionSelector;
import wecui.vendor.com.sk89q.worldedit.scripting.CraftScriptContext;
import wecui.vendor.com.sk89q.worldedit.scripting.RhinoCraftScriptEngine;
import wecui.vendor.com.sk89q.worldedit.tools.BlockTool;
import wecui.vendor.com.sk89q.worldedit.tools.DoubleActionBlockTool;
import wecui.vendor.com.sk89q.worldedit.tools.DoubleActionTraceTool;
import wecui.vendor.com.sk89q.worldedit.tools.Tool;
import wecui.vendor.com.sk89q.worldedit.tools.TraceTool;

public class WorldEdit {
    public static final Logger logger = Logger.getLogger("Minecraft.WorldEdit");
    private static String version;
    private final ServerInterface server;
    private final LocalConfiguration config;
    private final CommandsManager<com.sk89q.worldedit.LocalPlayer> commands;
    private final HashMap<String, com.sk89q.worldedit.LocalSession> sessions = new HashMap();
    private static final java.util.regex.Pattern numberFormatExceptionPattern;

    public WorldEdit(ServerInterface server, final LocalConfiguration config) {
        this.server = server;
        this.config = config;
        this.commands = new CommandsManager<com.sk89q.worldedit.LocalPlayer>(){

            @Override
            protected void checkPermission(LocalPlayer player, Method method) throws CommandException {
                if (!player.isPlayer() && !method.isAnnotationPresent(Console.class)) {
                    throw new UnhandledCommandException();
                }
                super.checkPermission(player, method);
            }

            @Override
            public boolean hasPermission(LocalPlayer player, String perm) {
                return player.hasPermission(perm);
            }

            @Override
            public void invokeMethod(Method parent, String[] args, LocalPlayer player, Method method, Object instance, Object[] methodArgs, int level) throws CommandException {
                if (config.logCommands) {
                    Logging loggingAnnotation = method.getAnnotation(Logging.class);
                    Logging.LogMode logMode = loggingAnnotation == null ? null : loggingAnnotation.value();
                    String msg = "WorldEdit: " + player.getName();
                    if (player.isPlayer()) {
                        msg = msg + " (in \"" + player.getWorld().getName() + "\")";
                    }
                    msg = msg + ": " + StringUtil.joinString(args, " ");
                    if (logMode != null && player.isPlayer()) {
                        Vector position = player.getPosition();
                        LocalSession session = WorldEdit.this.getSession(player);
                        switch (logMode) {
                            case PLACEMENT: {
                                try {
                                    position = session.getPlacementPosition(player);
                                }
                                catch (IncompleteRegionException e2) {
                                    break;
                                }
                            }
                            case POSITION: {
                                msg = msg + " - Position: " + position;
                                break;
                            }
                            case ALL: {
                                msg = msg + " - Position: " + position;
                            }
                            case ORIENTATION_REGION: {
                                msg = msg + " - Orientation: " + player.getCardinalDirection().name();
                            }
                            case REGION: {
                                try {
                                    msg = msg + " - Region: " + session.getSelection(player.getWorld());
                                }
                                catch (IncompleteRegionException e3) {}
                                break;
                            }
                        }
                    }
                    logger.info(msg);
                }
                super.invokeMethod(parent, args, player, method, instance, methodArgs, level);
            }
        };
        this.commands.setInjector(new SimpleInjector(this));
        this.reg(BiomeCommands.class);
        this.reg(ChunkCommands.class);
        this.reg(ClipboardCommands.class);
        this.reg(GeneralCommands.class);
        this.reg(GenerationCommands.class);
        this.reg(HistoryCommands.class);
        this.reg(NavigationCommands.class);
        this.reg(RegionCommands.class);
        this.reg(ScriptingCommands.class);
        this.reg(SelectionCommands.class);
        this.reg(SnapshotUtilCommands.class);
        this.reg(ToolUtilCommands.class);
        this.reg(ToolCommands.class);
        this.reg(UtilityCommands.class);
    }

    private void reg(Class<?> clazz) {
        this.server.onCommandRegistration(this.commands.registerAndReturn(clazz), this.commands);
    }

    public LocalSession getSession(String player) {
        return (LocalSession)this.sessions.get(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalSession getSession(LocalPlayer player) {
        LocalSession session;
        HashMap<String, com.sk89q.worldedit.LocalSession> hashMap = this.sessions;
        synchronized (hashMap) {
            if (this.sessions.containsKey(player.getName())) {
                return (LocalSession)this.sessions.get(player.getName());
            }
            session = new LocalSession(this.config);
            if (!player.hasPermission("worldedit.limit.unrestricted") && this.config.maxChangeLimit > -1) {
                if (this.config.defaultChangeLimit < 0) {
                    session.setBlockChangeLimit(this.config.maxChangeLimit);
                } else {
                    int limit = Math.min(this.config.defaultChangeLimit, this.config.maxChangeLimit);
                    session.setBlockChangeLimit(limit);
                }
            } else {
                session.setBlockChangeLimit(this.config.defaultChangeLimit);
            }
            session.setUseInventory(this.config.useInventory && (!this.config.useInventoryOverride || !player.hasPermission("worldedit.inventory.unrestricted")));
            this.sessions.put(player.getName(), (com.sk89q.worldedit.LocalSession)session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSession(LocalPlayer player) {
        HashMap<String, com.sk89q.worldedit.LocalSession> hashMap = this.sessions;
        synchronized (hashMap) {
            return this.sessions.containsKey(player.getName());
        }
    }

    public BaseBlock getBlock(LocalPlayer player, String arg, boolean allAllowed) throws UnknownItemException, DisallowedItemException {
        return this.getBlock(player, arg, allAllowed, false);
    }

    public BaseBlock getBlock(LocalPlayer player, String arg, boolean allAllowed, boolean allowNoData) throws UnknownItemException, DisallowedItemException {
        BlockType blockType;
        int data;
        int blockId;
        String testID;
        String[] typeAndData;
        String[] blockAndExtraData;
        block38: {
            arg = arg.replace("_", " ");
            arg = arg.replace(";", "|");
            blockAndExtraData = arg.split("\\|");
            typeAndData = blockAndExtraData[0].split(":", 2);
            testID = typeAndData[0];
            blockId = -1;
            data = -1;
            try {
                blockId = Integer.parseInt(testID);
                blockType = BlockType.fromID(blockId);
            }
            catch (NumberFormatException e2) {
                int t2;
                blockType = BlockType.lookup(testID);
                if (blockType != null || (t2 = this.server.resolveItem(testID)) <= 0 || t2 >= 256) break block38;
                blockType = BlockType.fromID(t2);
            }
        }
        if (blockId == -1 && blockType == null) {
            ClothColor col = ClothColor.lookup(testID);
            if (col != null) {
                blockType = BlockType.CLOTH;
                data = col.getID();
            } else {
                throw new UnknownItemException(arg);
            }
        }
        if (blockId == -1) {
            blockId = blockType.getID();
        }
        if (!player.getWorld().isValidBlockType(blockId)) {
            throw new UnknownItemException(arg);
        }
        if (data == -1) {
            try {
                int n2 = typeAndData.length > 1 && typeAndData[1].length() > 0 ? Integer.parseInt(typeAndData[1]) : (data = allowNoData ? -1 : 0);
                if (data > 15 || data < 0 && (!allAllowed || data != -1)) {
                    data = 0;
                }
            }
            catch (NumberFormatException e3) {
                if (blockType != null) {
                    block2 : switch (blockType) {
                        case CLOTH: {
                            ClothColor col = ClothColor.lookup(typeAndData[1]);
                            if (col != null) {
                                data = col.getID();
                                break;
                            }
                            throw new InvalidItemException(arg, "Unknown cloth color '" + typeAndData[1] + "'");
                        }
                        case STEP: 
                        case DOUBLE_STEP: {
                            BlockType dataType = BlockType.lookup(typeAndData[1]);
                            if (dataType != null) {
                                switch (dataType) {
                                    case STONE: {
                                        data = 0;
                                        break block2;
                                    }
                                    case SANDSTONE: {
                                        data = 1;
                                        break block2;
                                    }
                                    case WOOD: {
                                        data = 2;
                                        break block2;
                                    }
                                    case COBBLESTONE: {
                                        data = 3;
                                        break block2;
                                    }
                                    case BRICK: {
                                        data = 4;
                                        break block2;
                                    }
                                    case STONE_BRICK: {
                                        data = 5;
                                    }
                                }
                                throw new InvalidItemException(arg, "Invalid step type '" + typeAndData[1] + "'");
                            }
                            throw new InvalidItemException(arg, "Unknown step type '" + typeAndData[1] + "'");
                        }
                        default: {
                            throw new InvalidItemException(arg, "Unknown data value '" + typeAndData[1] + "'");
                        }
                    }
                }
                throw new InvalidItemException(arg, "Unknown data value '" + typeAndData[1] + "'");
            }
        }
        if (allAllowed || player.hasPermission("worldedit.anyblock") || !this.config.disallowedBlocks.contains(blockId)) {
            if (blockType != null) {
                switch (blockType) {
                    case SIGN_POST: 
                    case WALL_SIGN: {
                        String[] text = new String[]{blockAndExtraData.length > 1 ? blockAndExtraData[1] : "", blockAndExtraData.length > 2 ? blockAndExtraData[2] : "", blockAndExtraData.length > 3 ? blockAndExtraData[3] : "", blockAndExtraData.length > 4 ? blockAndExtraData[4] : ""};
                        return new SignBlock(blockType.getID(), data, text);
                    }
                    case MOB_SPAWNER: {
                        if (blockAndExtraData.length > 1) {
                            String mobName = blockAndExtraData[1];
                            for (MobType mobType : MobType.values()) {
                                if (!mobType.getName().toLowerCase().equals(mobName.toLowerCase())) continue;
                                mobName = mobType.getName();
                                break;
                            }
                            if (!this.server.isValidMobType(mobName)) {
                                throw new InvalidItemException(arg, "Unknown mob type '" + mobName + "'");
                            }
                            return new MobSpawnerBlock(data, mobName);
                        }
                        return new MobSpawnerBlock(data, MobType.PIG.getName());
                    }
                    case NOTE_BLOCK: {
                        if (blockAndExtraData.length > 1) {
                            byte note = Byte.parseByte(blockAndExtraData[1]);
                            if (note < 0 || note > 24) {
                                throw new InvalidItemException(arg, "Out of range note value: '" + blockAndExtraData[1] + "'");
                            }
                            return new NoteBlock(data, note);
                        }
                        return new NoteBlock(data, 0);
                    }
                }
                return new BaseBlock(blockId, data);
            }
            return new BaseBlock(blockId, data);
        }
        throw new DisallowedItemException(arg);
    }

    public BaseBlock getBlock(LocalPlayer player, String id2) throws UnknownItemException, DisallowedItemException {
        return this.getBlock(player, id2, false);
    }

    public Set<com.sk89q.worldedit.blocks.BaseBlock> getBlocks(LocalPlayer player, String list, boolean allAllowed, boolean allowNoData) throws DisallowedItemException, UnknownItemException {
        String[] items = list.split(",");
        HashSet<com.sk89q.worldedit.blocks.BaseBlock> blocks = new HashSet<com.sk89q.worldedit.blocks.BaseBlock>();
        for (String id2 : items) {
            blocks.add((com.sk89q.worldedit.blocks.BaseBlock)this.getBlock(player, id2, allAllowed, allowNoData));
        }
        return blocks;
    }

    public Set<com.sk89q.worldedit.blocks.BaseBlock> getBlocks(LocalPlayer player, String list, boolean allAllowed) throws DisallowedItemException, UnknownItemException {
        return this.getBlocks(player, list, allAllowed, false);
    }

    public Set<com.sk89q.worldedit.blocks.BaseBlock> getBlocks(LocalPlayer player, String list) throws DisallowedItemException, UnknownItemException {
        return this.getBlocks(player, list, false);
    }

    public Pattern getBlockPattern(LocalPlayer player, String patternString) throws UnknownItemException, DisallowedItemException {
        String[] items = patternString.split(",");
        if (patternString.charAt(0) == '#') {
            if (patternString.equals("#clipboard") || patternString.equals("#copy")) {
                CuboidClipboard clipboard;
                LocalSession session = this.getSession(player);
                try {
                    clipboard = session.getClipboard();
                }
                catch (EmptyClipboardException e2) {
                    player.printError("Copy a selection first with //copy.");
                    throw new UnknownItemException("#clipboard");
                }
                return new ClipboardPattern(clipboard);
            }
            throw new UnknownItemException(patternString);
        }
        if (items.length == 1) {
            return new SingleBlockPattern(this.getBlock(player, items[0]));
        }
        ArrayList<com.sk89q.worldedit.patterns.BlockChance> blockChances = new ArrayList<com.sk89q.worldedit.patterns.BlockChance>();
        for (String s2 : items) {
            BaseBlock block;
            double chance;
            if (s2.matches("[0-9]+(?:\\.(?:[0-9]+)?)?%.*")) {
                String[] p2 = s2.split("%");
                chance = Double.parseDouble(p2[0]);
                block = this.getBlock(player, p2[1]);
            } else {
                chance = 1.0;
                block = this.getBlock(player, s2);
            }
            blockChances.add((com.sk89q.worldedit.patterns.BlockChance)new BlockChance(block, chance));
        }
        return new RandomFillPattern(blockChances);
    }

    public Mask getBlockMask(LocalPlayer player, LocalSession session, String maskString) throws WorldEditException {
        ArrayList<com.sk89q.worldedit.masks.Mask> masks = new ArrayList<com.sk89q.worldedit.masks.Mask>();
        for (String component : maskString.split(" ")) {
            if (component.length() == 0) continue;
            Mask current = this.getBlockMaskComponent(player, session, masks, component);
            masks.add((com.sk89q.worldedit.masks.Mask)current);
        }
        switch (masks.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Mask)masks.get(0);
            }
        }
        return new CombinedMask(masks);
    }

    private Mask getBlockMaskComponent(LocalPlayer player, LocalSession session, List<com.sk89q.worldedit.masks.Mask> masks, String component) throws WorldEditException {
        char firstChar = component.charAt(0);
        switch (firstChar) {
            case '#': {
                if (component.equalsIgnoreCase("#existing")) {
                    return new ExistingBlockMask();
                }
                if (component.equalsIgnoreCase("#dregion") || component.equalsIgnoreCase("#dselection") || component.equalsIgnoreCase("#dsel")) {
                    return new DynamicRegionMask();
                }
                if (component.equalsIgnoreCase("#selection") || component.equalsIgnoreCase("#region") || component.equalsIgnoreCase("#sel")) {
                    return new RegionMask(session.getSelection(player.getWorld()));
                }
                throw new UnknownItemException(component);
            }
            case '<': 
            case '>': {
                Mask submask = component.length() > 1 ? this.getBlockMaskComponent(player, session, masks, component.substring(1)) : new ExistingBlockMask();
                return new UnderOverlayMask(submask, firstChar == '>');
            }
            case '$': {
                String[] biomesList;
                HashSet<com.sk89q.worldedit.BiomeType> biomes = new HashSet<com.sk89q.worldedit.BiomeType>();
                for (String biomeName : biomesList = component.substring(1).split(",")) {
                    BiomeType biome = this.server.getBiomes().get(biomeName);
                    biomes.add((com.sk89q.worldedit.BiomeType)biome);
                }
                return new BiomeTypeMask(biomes);
            }
            case '!': {
                if (component.length() <= 1) break;
                return new InvertedMask(this.getBlockMaskComponent(player, session, masks, component.substring(1)));
            }
        }
        return new BlockTypeMask(this.getBlockIDs(player, component, true));
    }

    public Set<Integer> getBlockIDs(LocalPlayer player, String list, boolean allBlocksAllowed) throws UnknownItemException, DisallowedItemException {
        String[] items = list.split(",");
        HashSet<Integer> blocks = new HashSet<Integer>();
        for (String s2 : items) {
            blocks.add(this.getBlock(player, s2, allBlocksAllowed).getType());
        }
        return blocks;
    }

    public File getSafeSaveFile(LocalPlayer player, File dir, String filename, String defaultExt, String ... extensions) throws FilenameException {
        return this.getSafeFile(player, dir, filename, defaultExt, extensions, true);
    }

    public File getSafeOpenFile(LocalPlayer player, File dir, String filename, String defaultExt, String ... extensions) throws FilenameException {
        return this.getSafeFile(player, dir, filename, defaultExt, extensions, false);
    }

    private File getSafeFile(LocalPlayer player, File dir, String filename, String defaultExt, String[] extensions, boolean isSave) throws FilenameException {
        File f2;
        if (extensions != null && extensions.length == 1 && extensions[0] == null) {
            extensions = null;
        }
        if (filename.equals("#")) {
            f2 = isSave ? player.openFileSaveDialog(extensions) : player.openFileOpenDialog(extensions);
            if (f2 == null) {
                throw new FileSelectionAbortedException("No file selected");
            }
        } else {
            if (defaultExt != null && filename.lastIndexOf(46) == -1) {
                filename = filename + "." + defaultExt;
            }
            if (!filename.matches("^[A-Za-z0-9_\\- \\./\\\\'\\$@~!%\\^\\*\\(\\)\\[\\]\\+\\{\\},\\?]+\\.[A-Za-z0-9]+$")) {
                throw new InvalidFilenameException(filename, "Invalid characters or extension missing");
            }
            f2 = new File(dir, filename);
        }
        try {
            String filePath = f2.getCanonicalPath();
            String dirPath = dir.getCanonicalPath();
            if (!filePath.substring(0, dirPath.length()).equals(dirPath)) {
                throw new FilenameResolutionException(filename, "Path is outside allowable root");
            }
            return f2;
        }
        catch (IOException e2) {
            throw new FilenameResolutionException(filename, "Failed to resolve path");
        }
    }

    public void checkMaxRadius(double radius) throws MaxRadiusException {
        if (this.config.maxRadius > 0 && radius > (double)this.config.maxRadius) {
            throw new MaxRadiusException();
        }
    }

    public File getWorkingDirectoryFile(String path) {
        File f2 = new File(path);
        if (f2.isAbsolute()) {
            return f2;
        }
        return new File(this.config.getWorkingDirectory(), path);
    }

    public static int divisorMod(int a2, int n2) {
        return (int)((double)a2 - (double)n2 * Math.floor(Math.floor(a2) / (double)n2));
    }

    public Vector getDirection(LocalPlayer player, String dirStr) throws UnknownDirectionException {
        dirStr = dirStr.toLowerCase();
        PlayerDirection dir = this.getPlayerDirection(player, dirStr);
        switch (dir) {
            case WEST: 
            case EAST: 
            case SOUTH: 
            case NORTH: 
            case UP: 
            case DOWN: {
                return dir.vector();
            }
        }
        throw new UnknownDirectionException(dir.name());
    }

    private PlayerDirection getPlayerDirection(LocalPlayer player, String dirStr) throws UnknownDirectionException {
        PlayerDirection dir;
        switch (dirStr.charAt(0)) {
            case 'w': {
                dir = PlayerDirection.WEST;
                break;
            }
            case 'e': {
                dir = PlayerDirection.EAST;
                break;
            }
            case 's': {
                if (dirStr.indexOf(119) > 0) {
                    return PlayerDirection.SOUTH_WEST;
                }
                if (dirStr.indexOf(101) > 0) {
                    return PlayerDirection.SOUTH_EAST;
                }
                dir = PlayerDirection.SOUTH;
                break;
            }
            case 'n': {
                if (dirStr.indexOf(119) > 0) {
                    return PlayerDirection.NORTH_WEST;
                }
                if (dirStr.indexOf(101) > 0) {
                    return PlayerDirection.NORTH_EAST;
                }
                dir = PlayerDirection.NORTH;
                break;
            }
            case 'u': {
                dir = PlayerDirection.UP;
                break;
            }
            case 'd': {
                dir = PlayerDirection.DOWN;
                break;
            }
            case 'f': 
            case 'm': {
                dir = player.getCardinalDirection(0);
                break;
            }
            case 'b': {
                dir = player.getCardinalDirection(180);
                break;
            }
            case 'l': {
                dir = player.getCardinalDirection(-90);
                break;
            }
            case 'r': {
                dir = player.getCardinalDirection(90);
                break;
            }
            default: {
                throw new UnknownDirectionException(dirStr);
            }
        }
        return dir;
    }

    public Vector getDiagonalDirection(LocalPlayer player, String dirStr) throws UnknownDirectionException {
        return this.getPlayerDirection(player, dirStr.toLowerCase()).vector();
    }

    public CuboidClipboard.FlipDirection getFlipDirection(LocalPlayer player, String dirStr) throws UnknownDirectionException {
        PlayerDirection dir = this.getPlayerDirection(player, dirStr);
        switch (dir) {
            case WEST: 
            case EAST: {
                return CuboidClipboard.FlipDirection.WEST_EAST;
            }
            case SOUTH: 
            case NORTH: {
                return CuboidClipboard.FlipDirection.NORTH_SOUTH;
            }
            case UP: 
            case DOWN: {
                return CuboidClipboard.FlipDirection.UP_DOWN;
            }
        }
        throw new UnknownDirectionException(dir.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(LocalPlayer player) {
        HashMap<String, com.sk89q.worldedit.LocalSession> hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.remove(player.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSessions() {
        HashMap<String, com.sk89q.worldedit.LocalSession> hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.clear();
        }
    }

    public void flushBlockBag(LocalPlayer player, EditSession editSession) {
        Set<Integer> missingBlocks;
        BlockBag blockBag = editSession.getBlockBag();
        if (blockBag != null) {
            blockBag.flushChanges();
        }
        if ((missingBlocks = editSession.popMissingBlocks()).size() > 0) {
            StringBuilder str = new StringBuilder();
            str.append("Missing these blocks: ");
            int size = missingBlocks.size();
            int i2 = 0;
            for (Integer id2 : missingBlocks) {
                BlockType type = BlockType.fromID(id2);
                str.append(type != null ? type.getName() + " (" + id2 + ")" : id2.toString());
                if (++i2 == size) continue;
                str.append(", ");
            }
            player.printError(str.toString());
        }
    }

    public Map<String, String> getCommands() {
        return this.commands.getCommands();
    }

    public CommandsManager<com.sk89q.worldedit.LocalPlayer> getCommandsManager() {
        return this.commands;
    }

    @Deprecated
    public void handleDisconnect(LocalPlayer player) {
        this.forgetPlayer(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markExpire(LocalPlayer player) {
        HashMap<String, com.sk89q.worldedit.LocalSession> hashMap = this.sessions;
        synchronized (hashMap) {
            LocalSession session = (LocalSession)this.sessions.get(player.getName());
            if (session != null) {
                session.update();
            }
        }
    }

    public void forgetPlayer(LocalPlayer player) {
        this.removeSession(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushExpiredSessions(SessionCheck checker) {
        HashMap<String, com.sk89q.worldedit.LocalSession> hashMap = this.sessions;
        synchronized (hashMap) {
            Iterator<Map.Entry<String, com.sk89q.worldedit.LocalSession>> it2 = this.sessions.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry<String, com.sk89q.worldedit.LocalSession> entry = it2.next();
                if (!((LocalSession)entry.getValue()).hasExpired() || checker.isOnlinePlayer(entry.getKey())) continue;
                it2.remove();
            }
        }
    }

    public boolean handleArmSwing(LocalPlayer player) {
        if (player.getItemInHand() == this.config.navigationWand) {
            if (this.config.navigationWandMaxDistance <= 0) {
                return false;
            }
            if (!player.hasPermission("worldedit.navigation.jumpto.tool") && !player.hasPermission("worldedit.navigation.jumpto")) {
                return false;
            }
            WorldVector pos = player.getSolidBlockTrace(this.config.navigationWandMaxDistance);
            if (pos != null) {
                player.findFreePosition(pos);
            } else {
                player.printError("No block in sight (or too far)!");
            }
            return true;
        }
        LocalSession session = this.getSession(player);
        Tool tool = session.getTool(player.getItemInHand());
        if (tool != null && tool instanceof DoubleActionTraceTool && tool.canUse(player)) {
            ((DoubleActionTraceTool)tool).actSecondary(this.server, this.config, player, session);
            return true;
        }
        return false;
    }

    public boolean handleRightClick(LocalPlayer player) {
        if (player.getItemInHand() == this.config.navigationWand) {
            if (this.config.navigationWandMaxDistance <= 0) {
                return false;
            }
            if (!player.hasPermission("worldedit.navigation.thru.tool") && !player.hasPermission("worldedit.navigation.thru")) {
                return false;
            }
            if (!player.passThroughForwardWall(40)) {
                player.printError("Nothing to pass through!");
            }
            return true;
        }
        LocalSession session = this.getSession(player);
        Tool tool = session.getTool(player.getItemInHand());
        if (tool != null && tool instanceof TraceTool && tool.canUse(player)) {
            ((TraceTool)tool).actPrimary(this.server, this.config, player, session);
            return true;
        }
        return false;
    }

    public boolean handleBlockRightClick(LocalPlayer player, WorldVector clicked) {
        LocalSession session = this.getSession(player);
        if (player.getItemInHand() == this.config.wandItem) {
            if (!session.isToolControlEnabled()) {
                return false;
            }
            if (!player.hasPermission("worldedit.selection.pos")) {
                return false;
            }
            RegionSelector selector = session.getRegionSelector(player.getWorld());
            if (selector.selectSecondary(clicked)) {
                selector.explainSecondarySelection(player, session, clicked);
            }
            return true;
        }
        Tool tool = session.getTool(player.getItemInHand());
        if (tool != null && tool instanceof BlockTool && tool.canUse(player)) {
            ((BlockTool)tool).actPrimary(this.server, this.config, player, session, clicked);
            return true;
        }
        return false;
    }

    public boolean handleBlockLeftClick(LocalPlayer player, WorldVector clicked) {
        BlockTool superPickaxe;
        LocalSession session = this.getSession(player);
        if (player.getItemInHand() == this.config.wandItem) {
            if (!session.isToolControlEnabled()) {
                return false;
            }
            if (!player.hasPermission("worldedit.selection.pos")) {
                return false;
            }
            RegionSelector selector = session.getRegionSelector(player.getWorld());
            if (selector.selectPrimary(clicked)) {
                selector.explainPrimarySelection(player, session, clicked);
            }
            return true;
        }
        if (player.isHoldingPickAxe() && session.hasSuperPickAxe() && (superPickaxe = session.getSuperPickaxe()) != null && superPickaxe.canUse(player)) {
            return superPickaxe.actPrimary(this.server, this.config, player, session, clicked);
        }
        Tool tool = session.getTool(player.getItemInHand());
        if (tool != null && tool instanceof DoubleActionBlockTool && tool.canUse(player)) {
            ((DoubleActionBlockTool)tool).actSecondary(this.server, this.config, player, session, clicked);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleCommand(LocalPlayer player, String[] split) {
        try {
            split = this.commandDetection(split);
            if (!this.commands.hasCommand(split[0])) {
                return false;
            }
            LocalSession session = this.getSession(player);
            EditSession editSession = session.createEditSession(player);
            editSession.enableQueue();
            session.tellVersion(player);
            long start = System.currentTimeMillis();
            try {
                this.commands.execute(split, (com.sk89q.worldedit.LocalPlayer)player, session, player, editSession);
                return true;
            }
            catch (CommandPermissionsException e2) {
                player.printError("You don't have permission to do this.");
                return true;
            }
            catch (MissingNestedCommandException e3) {
                player.printError(e3.getUsage());
                return true;
            }
            catch (CommandUsageException e4) {
                player.printError(e4.getMessage());
                player.printError(e4.getUsage());
                return true;
            }
            catch (WrappedCommandException e5) {
                throw e5.getCause();
            }
            catch (UnhandledCommandException e6) {
                player.printError("Command could not be handled; invalid sender!");
                boolean bl2 = false;
                return bl2;
            }
            finally {
                session.remember(editSession);
                editSession.flushQueue();
                if (this.config.profile) {
                    long time = System.currentTimeMillis() - start;
                    int changed = editSession.getBlockChangeCount();
                    if (time > 0L) {
                        double throughput = (double)changed / ((double)time / 1000.0);
                        player.printDebug((double)time / 1000.0 + "s elapsed (history: " + changed + " changed; " + Math.round(throughput) + " blocks/sec).");
                    } else {
                        player.printDebug((double)time / 1000.0 + "s elapsed.");
                    }
                }
                this.flushBlockBag(player, editSession);
            }
        }
        catch (NumberFormatException e7) {
            Matcher matcher = numberFormatExceptionPattern.matcher(e7.getMessage());
            if (matcher.matches()) {
                player.printError("Number expected; string \"" + matcher.group(1) + "\" given.");
                return true;
            }
            player.printError("Number expected; string given.");
            return true;
        }
        catch (IncompleteRegionException e8) {
            player.printError("Make a region selection first.");
            return true;
        }
        catch (UnknownItemException e9) {
            player.printError("Block name '" + e9.getID() + "' was not recognized.");
            return true;
        }
        catch (InvalidItemException e10) {
            player.printError(e10.getMessage());
            return true;
        }
        catch (DisallowedItemException e11) {
            player.printError("Block '" + e11.getID() + "' not allowed (see WorldEdit configuration).");
            return true;
        }
        catch (MaxChangedBlocksException e12) {
            player.printError("Max blocks changed in an operation reached (" + e12.getBlockLimit() + ").");
            return true;
        }
        catch (MaxRadiusException e13) {
            player.printError("Maximum radius: " + this.config.maxRadius);
            return true;
        }
        catch (UnknownDirectionException e14) {
            player.printError("Unknown direction: " + e14.getDirection());
            return true;
        }
        catch (InsufficientArgumentsException e15) {
            player.printError(e15.getMessage());
            return true;
        }
        catch (EmptyClipboardException e16) {
            player.printError("Your clipboard is empty. Use //copy first.");
            return true;
        }
        catch (InvalidFilenameException e17) {
            player.printError("Filename '" + e17.getFilename() + "' invalid: " + e17.getMessage());
            return true;
        }
        catch (FilenameResolutionException e18) {
            player.printError("File '" + e18.getFilename() + "' resolution error: " + e18.getMessage());
            return true;
        }
        catch (InvalidToolBindException e19) {
            player.printError("Can't bind tool to " + ItemType.toHeldName(e19.getItemId()) + ": " + e19.getMessage());
            return true;
        }
        catch (FileSelectionAbortedException e20) {
            player.printError("File selection aborted.");
            return true;
        }
        catch (WorldEditException e21) {
            player.printError(e21.getMessage());
            return true;
        }
        catch (Throwable excp) {
            player.printError("Please report this error: [See console]");
            player.printRaw(excp.getClass().getName() + ": " + excp.getMessage());
            excp.printStackTrace();
        }
        return true;
    }

    public String[] commandDetection(String[] split) {
        String searchCmd;
        split[0] = split[0].substring(1);
        if (split[0].matches("^[^/].*\\.js$")) {
            String[] newSplit = new String[split.length + 1];
            System.arraycopy(split, 0, newSplit, 1, split.length);
            newSplit[0] = "cs";
            newSplit[1] = newSplit[1];
            split = newSplit;
        }
        if (!this.commands.hasCommand(searchCmd = split[0].toLowerCase())) {
            if (this.config.noDoubleSlash && this.commands.hasCommand("/" + searchCmd)) {
                split[0] = "/" + split[0];
            } else if (split[0].length() >= 2 && split[0].charAt(0) == '/' && this.commands.hasCommand(searchCmd.substring(1))) {
                split[0] = split[0].substring(1);
            }
        }
        return split;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScript(LocalPlayer player, File f2, String[] args) throws WorldEditException {
        String script;
        int index;
        String filename = f2.getPath();
        String ext = filename.substring((index = filename.lastIndexOf(".")) + 1, filename.length());
        if (!ext.equalsIgnoreCase("js")) {
            player.printError("Only .js scripts are currently supported");
            return;
        }
        try {
            InputStream file;
            if (!f2.exists()) {
                file = WorldEdit.class.getResourceAsStream("craftscripts/" + filename);
                if (file == null) {
                    player.printError("Script does not exist: " + filename);
                    return;
                }
            } else {
                file = new FileInputStream(f2);
            }
            DataInputStream in2 = new DataInputStream(file);
            byte[] data = new byte[in2.available()];
            in2.readFully(data);
            in2.close();
            script = new String(data, 0, data.length, "utf-8");
        }
        catch (IOException e2) {
            player.printError("Script read error: " + e2.getMessage());
            return;
        }
        LocalSession session = this.getSession(player);
        CraftScriptContext scriptContext = new CraftScriptContext(this, this.server, this.config, session, player, args);
        RhinoCraftScriptEngine engine = null;
        try {
            engine = new RhinoCraftScriptEngine();
        }
        catch (NoClassDefFoundError e3) {
            player.printError("Failed to find an installed script engine.");
            player.printError("Please see http://wiki.sk89q.com/wiki/WorldEdit/Installation");
            return;
        }
        engine.setTimeLimit(this.config.scriptTimeout);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("argv", args);
        vars.put("context", scriptContext);
        vars.put("player", player);
        try {
            engine.evaluate(script, filename, vars);
        }
        catch (ScriptException e4) {
            player.printError("Failed to execute:");
            player.printRaw(e4.getMessage());
            e4.printStackTrace();
        }
        catch (NumberFormatException e5) {
            throw e5;
        }
        catch (WorldEditException e6) {
            throw e6;
        }
        catch (Throwable e7) {
            player.printError("Failed to execute (see console):");
            player.printRaw(e7.getClass().getCanonicalName());
            e7.printStackTrace();
        }
        finally {
            for (EditSession editSession : scriptContext.getEditSessions()) {
                editSession.flushQueue();
                session.remember(editSession);
            }
        }
    }

    public LocalConfiguration getConfiguration() {
        return this.config;
    }

    public ServerInterface getServer() {
        return this.server;
    }

    public static String getVersion() {
        if (version != null) {
            return version;
        }
        Package p2 = WorldEdit.class.getPackage();
        if (p2 == null) {
            p2 = Package.getPackage("com.sk89q.worldedit");
        }
        if (p2 == null) {
            version = "(unknown)";
        } else {
            version = p2.getImplementationVersion();
            if (version == null) {
                version = "(unknown)";
            }
        }
        return version;
    }

    public static void setVersion(String version) {
        WorldEdit.version = version;
    }

    static {
        WorldEdit.getVersion();
        numberFormatExceptionPattern = java.util.regex.Pattern.compile("^For input string: \"(.*)\"$");
    }
}

