/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit;

import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.VectorFace;
import wecui.vendor.com.sk89q.worldedit.WorldVector;

public class WorldVectorFace
extends WorldVector {
    private VectorFace face;

    public WorldVectorFace(LocalWorld world, double x2, double y2, double z2, VectorFace face) {
        super(world, x2, y2, z2);
        this.face = face;
    }

    public WorldVectorFace(LocalWorld world, int x2, int y2, int z2, VectorFace face) {
        super(world, x2, y2, z2);
        this.face = face;
    }

    public WorldVectorFace(LocalWorld world, float x2, float y2, float z2, VectorFace face) {
        super(world, x2, y2, z2);
        this.face = face;
    }

    public WorldVectorFace(LocalWorld world, Vector pt2, VectorFace face) {
        super(world, pt2);
        this.face = face;
    }

    public WorldVectorFace(LocalWorld world, VectorFace face) {
        super(world);
        this.face = face;
    }

    public VectorFace getFace() {
        return this.face;
    }

    public WorldVector getFaceVector() {
        return new WorldVector(this.getWorld(), this.getBlockX() - this.face.getModX(), this.getBlockY() - this.face.getModY(), this.getBlockZ() - this.face.getModZ());
    }

    public static WorldVectorFace getWorldVectorFace(LocalWorld world, Vector vector, Vector face) {
        if (vector == null || face == null) {
            return null;
        }
        int x1 = vector.getBlockX();
        int y1 = vector.getBlockY();
        int z1 = vector.getBlockZ();
        int modX = x1 - face.getBlockX();
        int modY = y1 - face.getBlockY();
        int modZ = z1 - face.getBlockZ();
        modX = modX > 0 ? 1 : (modX < 0 ? -1 : 0);
        modY = modY > 0 ? 1 : (modY < 0 ? -1 : 0);
        modZ = modZ > 0 ? 1 : (modZ < 0 ? -1 : 0);
        return new WorldVectorFace(world, x1, y1, z1, VectorFace.fromMods(modX, modY, modZ));
    }
}

