/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.blocks;

import com.sk89q.jnbt.Tag;
import java.util.HashMap;
import java.util.Map;
import wecui.vendor.com.sk89q.jnbt.NBTUtils;
import wecui.vendor.com.sk89q.jnbt.ShortTag;
import wecui.vendor.com.sk89q.jnbt.StringTag;
import wecui.vendor.com.sk89q.worldedit.MobType;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.TileEntityBlock;
import wecui.vendor.com.sk89q.worldedit.data.DataException;

public class MobSpawnerBlock
extends BaseBlock
implements TileEntityBlock {
    private String mobType;
    private short delay;

    public MobSpawnerBlock() {
        super(52);
        this.mobType = MobType.PIG.getName();
    }

    public MobSpawnerBlock(String mobType) {
        super(52);
        this.mobType = mobType;
    }

    public MobSpawnerBlock(int data) {
        super(52, data);
    }

    public MobSpawnerBlock(int data, String mobType) {
        super(52, data);
        this.mobType = mobType;
    }

    public String getMobType() {
        return this.mobType;
    }

    public void setMobType(String mobType) {
        this.mobType = mobType;
    }

    public short getDelay() {
        return this.delay;
    }

    public void setDelay(short delay) {
        this.delay = delay;
    }

    @Override
    public String getTileEntityID() {
        return "MobSpawner";
    }

    @Override
    public Map<String, Tag> toTileEntityNBT() throws DataException {
        HashMap<String, Tag> values = new HashMap<String, Tag>();
        values.put("EntityId", (Tag)new StringTag("EntityId", this.mobType));
        values.put("Delay", (Tag)new ShortTag("Delay", this.delay));
        return values;
    }

    @Override
    public void fromTileEntityNBT(Map<String, Tag> values) throws DataException {
        if (values == null) {
            return;
        }
        wecui.vendor.com.sk89q.jnbt.Tag t2 = (wecui.vendor.com.sk89q.jnbt.Tag)values.get("id");
        if (!(t2 instanceof StringTag) || !((StringTag)t2).getValue().equals("MobSpawner")) {
            throw new DataException("'MobSpawner' tile entity expected");
        }
        StringTag mobTypeTag = NBTUtils.getChildTag(values, "EntityId", StringTag.class);
        ShortTag delayTag = NBTUtils.getChildTag(values, "Delay", ShortTag.class);
        this.mobType = mobTypeTag.getValue();
        this.delay = delayTag.getValue();
    }
}

