/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.bukkit;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import wecui.vendor.com.sk89q.worldedit.BlockVector;
import wecui.vendor.com.sk89q.worldedit.BlockWorldVector;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.Location;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.WorldVector;
import wecui.vendor.com.sk89q.worldedit.bukkit.BukkitWorld;
import wecui.vendor.com.sk89q.worldedit.bukkit.entity.BukkitEntity;
import wecui.vendor.com.sk89q.worldedit.bukkit.entity.BukkitExpOrb;
import wecui.vendor.com.sk89q.worldedit.bukkit.entity.BukkitItem;

public class BukkitUtil {
    private static final Map<World, com.sk89q.worldedit.LocalWorld> wlw = new HashMap<World, com.sk89q.worldedit.LocalWorld>();
    public static final double EQUALS_PRECISION = 1.0E-4;

    private BukkitUtil() {
    }

    public static LocalWorld getLocalWorld(World w2) {
        LocalWorld lw2 = (LocalWorld)wlw.get(w2);
        if (lw2 == null) {
            lw2 = new BukkitWorld(w2);
            wlw.put(w2, (com.sk89q.worldedit.LocalWorld)lw2);
        }
        return lw2;
    }

    public static BlockVector toVector(Block block) {
        return new BlockVector(block.getX(), block.getY(), block.getZ());
    }

    public static BlockVector toVector(BlockFace face) {
        return new BlockVector(face.getModX(), face.getModY(), face.getModZ());
    }

    public static BlockWorldVector toWorldVector(Block block) {
        return new BlockWorldVector(BukkitUtil.getLocalWorld(block.getWorld()), block.getX(), block.getY(), block.getZ());
    }

    public static Vector toVector(org.bukkit.Location loc) {
        return new Vector(loc.getX(), loc.getY(), loc.getZ());
    }

    public static Location toLocation(org.bukkit.Location loc) {
        return new Location(BukkitUtil.getLocalWorld(loc.getWorld()), new Vector(loc.getX(), loc.getY(), loc.getZ()), loc.getYaw(), loc.getPitch());
    }

    public static Vector toVector(org.bukkit.util.Vector vector) {
        return new Vector(vector.getX(), vector.getY(), vector.getZ());
    }

    public static org.bukkit.Location toLocation(WorldVector pt2) {
        return new org.bukkit.Location(BukkitUtil.toWorld(pt2), pt2.getX(), pt2.getY(), pt2.getZ());
    }

    public static org.bukkit.Location toLocation(World world, Vector pt2) {
        return new org.bukkit.Location(world, pt2.getX(), pt2.getY(), pt2.getZ());
    }

    public static org.bukkit.Location center(org.bukkit.Location loc) {
        return new org.bukkit.Location(loc.getWorld(), (double)loc.getBlockX() + 0.5, (double)loc.getBlockY() + 0.5, (double)loc.getBlockZ() + 0.5, loc.getPitch(), loc.getYaw());
    }

    public static Player matchSinglePlayer(Server server, String name) {
        List players = server.matchPlayer(name);
        if (players.size() == 0) {
            return null;
        }
        return (Player)players.get(0);
    }

    public static Block toBlock(BlockWorldVector pt2) {
        return BukkitUtil.toWorld(pt2).getBlockAt(BukkitUtil.toLocation(pt2));
    }

    public static World toWorld(WorldVector pt2) {
        return ((BukkitWorld)pt2.getWorld()).getWorld();
    }

    public static boolean equals(org.bukkit.Location a2, org.bukkit.Location b2) {
        if (Math.abs(a2.getX() - b2.getX()) > 1.0E-4) {
            return false;
        }
        if (Math.abs(a2.getY() - b2.getY()) > 1.0E-4) {
            return false;
        }
        return !(Math.abs(a2.getZ() - b2.getZ()) > 1.0E-4);
    }

    public static org.bukkit.Location toLocation(Location teleportLocation) {
        Vector pt2 = teleportLocation.getPosition();
        return new org.bukkit.Location(BukkitUtil.toWorld(teleportLocation.getWorld()), pt2.getX(), pt2.getY(), pt2.getZ(), teleportLocation.getYaw(), teleportLocation.getPitch());
    }

    public static World toWorld(LocalWorld world) {
        return ((BukkitWorld)world).getWorld();
    }

    public static BukkitEntity toLocalEntity(Entity e2) {
        switch (e2.getType()) {
            case EXPERIENCE_ORB: {
                return new BukkitExpOrb(BukkitUtil.toLocation(e2.getLocation()), e2.getUniqueId(), ((ExperienceOrb)e2).getExperience());
            }
            case DROPPED_ITEM: {
                return new BukkitItem(BukkitUtil.toLocation(e2.getLocation()), ((Item)e2).getItemStack(), e2.getUniqueId());
            }
        }
        return new BukkitEntity(BukkitUtil.toLocation(e2.getLocation()), e2.getType(), e2.getUniqueId());
    }
}

